/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.utils;

import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.client.graph.data.HostAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.connector.nebula.utils.NebulaConstant;

public class NebulaUtils {
    public static List<HostAddress> getHostAndPorts(String address) {
        if (address == null || "".equalsIgnoreCase(address)) {
            throw new IllegalArgumentException("empty address");
        }
        ArrayList<HostAddress> hostAndPortList = new ArrayList<HostAddress>();
        for (String addr : address.split(NebulaConstant.COMMA)) {
            String[] hostPort = addr.split(NebulaConstant.COLON);
            if (hostPort.length < 2) {
                throw new IllegalArgumentException("wrong address");
            }
            hostAndPortList.add(new HostAddress(hostPort[0], Integer.parseInt(hostPort[1])));
        }
        return hostAndPortList;
    }

    public static boolean isNumeric(String str) {
        String newStr = null;
        newStr = str.startsWith("-") ? str.substring(1) : str;
        for (char c : newStr.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String extraValue(Object value, int type) {
        if (value == null) {
            return null;
        }
        switch (PropertyType.findByValue(type)) {
            case STRING: 
            case FIXED_STRING: {
                return NebulaUtils.mkString(NebulaUtils.escapeUtil(String.valueOf(value)), "\"", "", "\"");
            }
            case DATE: {
                return "date(\"" + value + "\")";
            }
            case TIME: {
                return "time(\"" + value + "\")";
            }
            case DATETIME: {
                return "datetime(\"" + value + "\")";
            }
            case TIMESTAMP: {
                if (NebulaUtils.isNumeric(String.valueOf(value))) {
                    return String.valueOf(value);
                }
                return "timestamp(\"" + value + "\")";
            }
            case GEOGRAPHY: {
                return "ST_GeogFromText(\"" + value + "\")";
            }
        }
        return String.valueOf(value);
    }

    public static String escapeUtil(String value) {
        String s = value;
        if (s.contains("\\")) {
            s = s.replaceAll("\\\\", "\\\\\\\\");
        }
        if (s.contains("\t")) {
            s = s.replaceAll("\t", "\\\\t");
        }
        if (s.contains("\n")) {
            s = s.replaceAll("\n", "\\\\n");
        }
        if (s.contains("\"")) {
            s = s.replaceAll("\"", "\\\\\"");
        }
        if (s.contains("'")) {
            s = s.replaceAll("'", "\\\\'");
        }
        if (s.contains("\r")) {
            s = s.replaceAll("\r", "\\\\r");
        }
        if (s.contains("\b")) {
            s = s.replaceAll("\b", "\\\\b");
        }
        return s;
    }

    public static String mkString(String value, String start, String sep, String end) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append(start);
        for (char c : value.toCharArray()) {
            if (first) {
                builder.append(c);
                first = false;
                continue;
            }
            builder.append(sep);
            builder.append(c);
        }
        builder.append(end);
        return builder.toString();
    }

    public static boolean checkValidVidType(String vidType) {
        if ("INT".equals(vidType) || "INT64".equals(vidType)) {
            return true;
        }
        String regex = "FIXED_STRING\\(\\d+\\)";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(vidType);
        return matcher.matches();
    }
}

