/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeAdaptingVisitHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class NodeAdaptedVisitor<H extends NodeAdaptingVisitHandler<?, ?>> {
    private final Map<Class<?>, H> myCustomHandlersMap = new HashMap();

    public NodeAdaptedVisitor(H ... handlers) {
        this.addHandlers((NodeAdaptingVisitHandler[])handlers);
    }

    public NodeAdaptedVisitor(H[] ... handlers) {
        this.addHandlers((NodeAdaptingVisitHandler[][])handlers);
    }

    public NodeAdaptedVisitor(Collection<H> handlers) {
        this.addHandlers(handlers);
    }

    public NodeAdaptedVisitor<H> addHandlers(H ... handlers) {
        for (H handler : handlers) {
            this.myCustomHandlersMap.put(((NodeAdaptingVisitHandler)handler).getNodeType(), handler);
        }
        return this;
    }

    public NodeAdaptedVisitor<H> addHandlers(H[] ... handlers) {
        H[][] HArray = handlers;
        int n = HArray.length;
        for (int i = 0; i < n; ++i) {
            H[] moreVisitors;
            for (H handler : moreVisitors = HArray[i]) {
                this.myCustomHandlersMap.put(((NodeAdaptingVisitHandler)handler).getNodeType(), handler);
            }
        }
        return this;
    }

    public NodeAdaptedVisitor<H> addHandlers(Collection<H> handlers) {
        for (NodeAdaptingVisitHandler handler : handlers) {
            this.myCustomHandlersMap.put(handler.getNodeType(), handler);
        }
        return this;
    }

    public H getHandler(Node node) {
        return (H)((NodeAdaptingVisitHandler)this.myCustomHandlersMap.get(node.getClass()));
    }

    public H getHandler(Class<?> nodeClass) {
        return (H)((NodeAdaptingVisitHandler)this.myCustomHandlersMap.get(nodeClass));
    }

    public Set<Class<?>> getNodeClasses() {
        return this.myCustomHandlersMap.keySet();
    }
}

