/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.MappedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.RichCharSequenceBase;
import com.vladsch.flexmark.util.sequence.SubSequence;

public abstract class BasedSequenceImpl
extends RichCharSequenceBase<BasedSequence>
implements BasedSequence {
    public static BasedSequence firstNonNull(BasedSequence ... sequences) {
        for (BasedSequence sequence : sequences) {
            if (sequence == null || sequence == NULL) continue;
            return sequence;
        }
        return NULL;
    }

    public BasedSequence[] emptyArray() {
        return EMPTY_ARRAY;
    }

    @Override
    public BasedSequence nullSequence() {
        return NULL;
    }

    @Override
    public BasedSequence sequenceOf(CharSequence charSequence, int startIndex, int endIndex) {
        return BasedSequenceImpl.of(charSequence, startIndex, endIndex);
    }

    @Override
    public Range getIndexRange(int startOffset, int endOffset) {
        int baseOffset = this.getStartOffset();
        if (startOffset > this.getEndOffset() || endOffset < baseOffset) {
            throw new IllegalArgumentException("getIndexRange(" + startOffset + ", " + endOffset + ") not in range [" + baseOffset + ", " + this.getEndOffset() + "]");
        }
        return Range.of(startOffset - baseOffset, endOffset - baseOffset);
    }

    @Override
    public final BasedSequence toMapped(CharMapper mapper) {
        return MappedSequence.of(mapper, this);
    }

    @Override
    public BasedSequence baseSubSequence(int start) {
        return this.baseSubSequence(start, this.getBaseSequence().getEndOffset());
    }

    @Override
    public char safeCharAt(int index) {
        return index < 0 || index >= this.length() ? (char)'\u0000' : this.charAt(index);
    }

    @Override
    public char safeBaseCharAt(int index) {
        if (index >= 0 && index < this.length()) {
            return this.charAt(index);
        }
        int baseIndex = this.getStartOffset() + index;
        return this.getBaseSequence().safeCharAt(baseIndex);
    }

    @Override
    public BasedSequence getEmptyPrefix() {
        return (BasedSequence)this.subSequence(0, 0);
    }

    @Override
    public BasedSequence getEmptySuffix() {
        return (BasedSequence)this.subSequence(this.length());
    }

    @Override
    public String unescape() {
        return Escaping.unescapeString(this);
    }

    @Override
    public String unescapeNoEntities() {
        return Escaping.unescapeString(this, false);
    }

    @Override
    public BasedSequence unescape(ReplacedTextMapper textMapper) {
        return Escaping.unescape(this, textMapper);
    }

    @Override
    public BasedSequence normalizeEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(this, textMapper);
    }

    @Override
    public BasedSequence normalizeEndWithEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEndWithEOL(this, textMapper);
    }

    @Override
    public boolean isContinuedBy(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getStartOffset() == this.getEndOffset();
    }

    @Override
    public boolean isContinuationOf(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getEndOffset() == this.getStartOffset();
    }

    @Override
    public BasedSequence spliceAtEnd(BasedSequence other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        assert (this.isContinuedBy(other)) : "sequence[" + this.getStartOffset() + ", " + this.getEndOffset() + "] is not continued by other[" + other.getStartOffset() + ", " + other.getEndOffset() + "]";
        return this.baseSubSequence(this.getStartOffset(), other.getEndOffset());
    }

    @Override
    public boolean containsAllOf(BasedSequence other) {
        return this.getBase() == other.getBase() && other.getStartOffset() >= this.getStartOffset() && other.getEndOffset() <= this.getEndOffset();
    }

    @Override
    public boolean containsSomeOf(BasedSequence other) {
        return this.getBase() == other.getBase() && this.getStartOffset() < other.getEndOffset() && this.getEndOffset() > other.getStartOffset();
    }

    @Override
    public BasedSequence intersect(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getEndOffset() <= this.getStartOffset()) {
            return (BasedSequence)this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return (BasedSequence)this.subSequence(this.length(), this.length());
        }
        return this.baseSubSequence(Utils.max(this.getStartOffset(), other.getStartOffset()), Utils.min(this.getEndOffset(), other.getEndOffset()));
    }

    @Override
    public BasedSequence extendByAny(CharSequence charSet, int maxCount) {
        int count = this.getBaseSequence().countLeading(charSet, this.getEndOffset(), this.getEndOffset() + maxCount);
        return count == 0 ? this : this.baseSubSequence(this.getStartOffset(), this.getEndOffset() + count);
    }

    @Override
    public BasedSequence extendToAny(CharSequence charSet, int maxCount) {
        if (charSet.length() == 0) {
            return this;
        }
        int count = this.getBaseSequence().countLeadingNot(charSet, this.getEndOffset(), this.getEndOffset() + maxCount);
        return count == this.getBaseSequence().length() - this.getEndOffset() ? this : this.baseSubSequence(this.getStartOffset(), this.getEndOffset() + count + 1);
    }

    @Override
    public BasedSequence prefixWithIndent(int maxColumns) {
        int offset;
        block9: {
            int startOffset;
            offset = this.getStartOffset();
            int columns = 0;
            int columnOffset = 0;
            boolean hadTab = false;
            for (startOffset = this.getStartOffset(); startOffset >= 0; --startOffset) {
                char c = this.getBaseSequence().charAt(startOffset);
                if (c == '\t') {
                    hadTab = true;
                    continue;
                }
                if (c != '\n') continue;
                ++startOffset;
                break;
            }
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (startOffset >= offset) break block9;
            if (hadTab) {
                int[] offsetColumns = new int[offset - startOffset];
                for (int currOffset = startOffset; currOffset < offset; ++currOffset) {
                    if (this.getBaseSequence().charAt(currOffset) == '\t') {
                        int n = 4 - columnOffset % 4;
                        offsetColumns[currOffset - startOffset] = n;
                        columnOffset += n;
                        continue;
                    }
                    offsetColumns[currOffset - startOffset] = 1;
                    ++columnOffset;
                }
                while (columns < maxColumns && offset > 0 && (this.getBaseSequence().charAt(offset - 1) == ' ' || this.getBaseSequence().charAt(offset - 1) == '\t') && (columns += offsetColumns[offset - 1 - startOffset]) <= maxColumns) {
                    --offset;
                }
            } else {
                while (columns < maxColumns && offset > 0 && (this.getBaseSequence().charAt(offset - 1) == ' ' || this.getBaseSequence().charAt(offset - 1) == '\t')) {
                    ++columns;
                    --offset;
                }
            }
        }
        return offset == this.getStartOffset() ? this : this.baseSubSequence(offset, this.getEndOffset());
    }

    @Override
    public BasedSequence prefixOf(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getStartOffset() <= this.getStartOffset()) {
            return (BasedSequence)this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this;
        }
        return this.baseSubSequence(this.getStartOffset(), other.getStartOffset());
    }

    @Override
    public BasedSequence suffixOf(BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return SubSequence.NULL;
        }
        if (other.getEndOffset() >= this.getEndOffset()) {
            return (BasedSequence)this.subSequence(this.length(), this.length());
        }
        if (other.getEndOffset() <= this.getStartOffset()) {
            return this;
        }
        return this.baseSubSequence(other.getEndOffset(), this.getEndOffset());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, false);
    }

    @Override
    public boolean equalsIgnoreCase(CharSequence other) {
        return this == other || other != null && other.length() == this.length() && this.matchChars(other, 0, true);
    }

    @Override
    public boolean equals(Object other, boolean ignoreCase) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, ignoreCase);
    }

    @Override
    public int compareTo(CharSequence other) {
        int len2;
        int len1 = this.length();
        int iMax = len1 <= (len2 = other.length()) ? len1 : len2;
        for (int i = 0; i < iMax; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static BasedSequence of(CharSequence charSequence) {
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)charSequence;
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence);
        }
        if (charSequence != null) {
            return SubSequence.of(charSequence);
        }
        return BasedSequence.NULL;
    }

    public static BasedSequence of(CharSequence charSequence, int start) {
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)((BasedSequence)charSequence).subSequence(start);
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence, start);
        }
        return SubSequence.of(charSequence, start);
    }

    public static BasedSequence of(CharSequence charSequence, int start, int end) {
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)((BasedSequence)charSequence).subSequence(start, end);
        }
        if (charSequence instanceof String) {
            return CharSubSequence.of(charSequence, start, end);
        }
        return SubSequence.of(charSequence, start, end);
    }
}

