/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.application;

import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeartbeaterService
implements Runnable,
Closeable {
    private static final Logger logger = Logger.getLogger(HeartbeaterService.class.getCanonicalName());
    private final WavefrontMetricSender wavefrontMetricSender;
    private final List<Map<String, String>> heartbeatMetricTagsList = new ArrayList<Map<String, String>>();
    private final ScheduledExecutorService scheduler;
    private final String source;
    private final Set<Map<String, String>> customTagsSet = Collections.newSetFromMap(new ConcurrentHashMap());

    public HeartbeaterService(WavefrontMetricSender wavefrontMetricSender, final ApplicationTags applicationTags, List<String> components, String source) {
        this.wavefrontMetricSender = wavefrontMetricSender;
        this.source = source;
        for (final String component : components) {
            this.heartbeatMetricTagsList.add((Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("application", applicationTags.getApplication());
                    this.put("cluster", applicationTags.getCluster() == null ? "none" : applicationTags.getCluster());
                    this.put("service", applicationTags.getService());
                    this.put("shard", applicationTags.getShard() == null ? "none" : applicationTags.getShard());
                    this.put("component", component);
                    if (applicationTags.getCustomTags() != null) {
                        this.putAll(applicationTags.getCustomTags());
                    }
                }
            });
        }
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("heart-beater").setDaemon(true));
        this.scheduler.scheduleAtFixedRate(this, 1L, 300L, TimeUnit.SECONDS);
    }

    public void reportCustomTags(Map<String, String> customTagsMap) {
        this.customTagsSet.add(customTagsMap);
    }

    @Override
    public void run() {
        Iterator<Map<String, String>> iter = this.customTagsSet.iterator();
        while (iter.hasNext()) {
            try {
                this.wavefrontMetricSender.sendMetric("~component.heartbeat", 1.0, System.currentTimeMillis(), this.source, iter.next());
                iter.remove();
            }
            catch (Throwable t) {
                logger.warning("Cannot report custom ~component.heartbeat to Wavefront");
            }
        }
        for (Map<String, String> heartbeatMetricTags : this.heartbeatMetricTagsList) {
            try {
                this.wavefrontMetricSender.sendMetric("~component.heartbeat", 1.0, System.currentTimeMillis(), this.source, heartbeatMetricTags);
            }
            catch (Throwable t) {
                logger.warning("Cannot report ~component.heartbeat to Wavefront");
            }
        }
    }

    @Override
    public void close() {
        try {
            Utils.shutdownExecutorAndWait(this.scheduler);
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "shutdown error", ex);
        }
    }
}

