/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationData
extends CoreAuthenticationData {
    private final byte[] userHandle;
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions;

    public AuthenticationData(@Nullable byte[] credentialId, @Nullable byte[] userHandle, @Nullable AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, @Nullable byte[] authenticatorDataBytes, @Nullable CollectedClientData collectedClientData, @Nullable byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions, @Nullable byte[] signature) {
        super(credentialId, authenticatorData, authenticatorDataBytes, collectedClientDataBytes == null ? null : MessageDigestUtil.createSHA256().digest(collectedClientDataBytes), signature);
        this.userHandle = ArrayUtil.clone((byte[])userHandle);
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
    }

    public @Nullable byte[] getUserHandle() {
        return ArrayUtil.clone((byte[])this.userHandle);
    }

    public @Nullable CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public @Nullable byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public @Nullable AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationData that = (AuthenticationData)o;
        return Arrays.equals(this.userHandle, that.userHandle) && Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }

    @Override
    public String toString() {
        return "AuthenticationData(userHandle=" + ArrayUtil.toHexString((byte[])this.userHandle) + ", collectedClientData=" + this.collectedClientData + ", clientExtensions=" + this.clientExtensions + ')';
    }
}

