/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jaxrs.listing;

import com.wordnik.swagger.config.FilterFactory;
import com.wordnik.swagger.config.Scanner;
import com.wordnik.swagger.config.ScannerFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.filter.SpecFilter;
import com.wordnik.swagger.core.filter.SwaggerSpecFilter;
import com.wordnik.swagger.jaxrs.Reader;
import com.wordnik.swagger.jaxrs.config.JaxrsScanner;
import com.wordnik.swagger.jaxrs.listing.SwaggerSerializers;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.util.Yaml;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ApiListingResource {
    Logger LOGGER = LoggerFactory.getLogger(ApiListingResource.class);
    static boolean initialized = false;
    @Context
    ServletContext context;

    protected synchronized Swagger scan(Application app, ServletConfig sc) {
        Swagger swagger = null;
        Scanner scanner = ScannerFactory.getScanner();
        this.LOGGER.debug("using scanner " + scanner);
        if (scanner != null) {
            SwaggerSerializers.setPrettyPrint(scanner.getPrettyPrint());
            swagger = (Swagger)this.context.getAttribute("swagger");
            HashSet<Class<?>> classes = new HashSet();
            if (scanner instanceof JaxrsScanner) {
                JaxrsScanner jaxrsScanner = (JaxrsScanner)scanner;
                classes = jaxrsScanner.classesFromContext(app, sc);
            } else {
                classes = scanner.classes();
            }
            if (classes != null) {
                Reader reader = new Reader(swagger);
                swagger = reader.read(classes);
                if (scanner instanceof SwaggerConfig) {
                    swagger = ((SwaggerConfig)scanner).configure(swagger);
                } else {
                    SwaggerConfig configurator = (SwaggerConfig)this.context.getAttribute("reader");
                    if (configurator != null) {
                        this.LOGGER.debug("configuring swagger with " + configurator);
                        configurator.configure(swagger);
                    } else {
                        this.LOGGER.debug("no configurator");
                    }
                }
                this.context.setAttribute("swagger", (Object)swagger);
            }
        }
        initialized = true;
        return swagger;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/swagger.json")
    public Response getListingJson(@Context Application app, @Context ServletConfig sc, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Swagger swagger = (Swagger)this.context.getAttribute("swagger");
        if (!initialized) {
            swagger = this.scan(app, sc);
        }
        if (swagger != null) {
            SwaggerSpecFilter filterImpl = FilterFactory.getFilter();
            if (filterImpl != null) {
                SpecFilter f = new SpecFilter();
                swagger = f.filter(swagger, filterImpl, this.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), this.getCookies(headers), this.getHeaders(headers));
            }
            return Response.ok().entity((Object)swagger).build();
        }
        return Response.status((int)404).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="/swagger.yaml")
    public Response getListingYaml(@Context Application app, @Context ServletConfig sc, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Swagger swagger = (Swagger)this.context.getAttribute("swagger");
        if (!initialized) {
            swagger = this.scan(app, sc);
        }
        try {
            if (swagger != null) {
                SwaggerSpecFilter filterImpl = FilterFactory.getFilter();
                this.LOGGER.debug("using filter " + filterImpl);
                if (filterImpl != null) {
                    SpecFilter f = new SpecFilter();
                    swagger = f.filter(swagger, filterImpl, this.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), this.getCookies(headers), this.getHeaders(headers));
                }
                String yaml = Yaml.mapper().writeValueAsString((Object)swagger);
                String[] parts = yaml.split("\n");
                StringBuilder b = new StringBuilder();
                for (String part : parts) {
                    int pos = part.indexOf("!<");
                    int endPos = part.indexOf(">");
                    b.append(part);
                    b.append("\n");
                }
                return Response.ok().entity((Object)b.toString()).type("text/plain").build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)404).build();
    }

    protected Map<String, List<String>> getQueryParams(MultivaluedMap<String, String> params) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (params != null) {
            for (String key : params.keySet()) {
                List values = (List)params.get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    protected Map<String, String> getCookies(HttpHeaders headers) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.getCookies().keySet()) {
                Cookie cookie = (Cookie)headers.getCookies().get(key);
                output.put(key, cookie.getValue());
            }
        }
        return output;
    }

    protected Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (headers != null) {
            for (String key : headers.getRequestHeaders().keySet()) {
                List values = (List)headers.getRequestHeaders().get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }
}

