/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.media;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

public class CaptchaUtil {
    private int width = 90;
    private int height = 20;
    private int codeCount = 4;
    private int xx = 15;
    private int fontHeight = 21;
    private int codeY = 16;
    public char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private Font font;
    private String[] code;
    private Color backgroundColor = Color.WHITE;
    Random random;

    public CaptchaUtil() {
        this.code = new String[this.codeCount];
        this.random = new Random();
        this.font = new Font("Fixedsys", 1, this.fontHeight);
        this.generateCode();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public void setCodeCount(int codeCount) {
        this.codeCount = codeCount;
        this.code = new String[codeCount];
        this.generateCode();
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getCode() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.code.length; ++i) {
            sb.append(this.code[i]);
        }
        return sb.toString();
    }

    public void setCode(String[] code) {
        this.code = code;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    private void generateCode() {
        for (int i = 0; i < this.codeCount; ++i) {
            this.code[i] = String.valueOf(this.codeSequence[this.random.nextInt(31)]);
        }
    }

    public BufferedImage createImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics gd = bufferedImage.getGraphics();
        gd.setColor(this.backgroundColor);
        gd.fillRect(0, 0, this.width, this.height);
        gd.setFont(this.font);
        gd.setColor(Color.BLACK);
        for (int i = 0; i < 15; ++i) {
            int x = this.random.nextInt(this.width);
            int y = this.random.nextInt(this.height);
            int xl = this.random.nextInt(12);
            int yl = this.random.nextInt(12);
            gd.drawLine(x, y, x + xl, y + yl);
        }
        StringBuffer randomCode = new StringBuffer();
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < this.code.length; ++i) {
            red = this.random.nextInt(255);
            green = this.random.nextInt(255);
            blue = this.random.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawString(this.code[i], (i + 1) * this.xx, this.codeY);
            randomCode.append(this.code);
        }
        return bufferedImage;
    }
}

