/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.media;

import java.awt.Color;

public class ColorUtil {
    public static String colorToHex(Color color) {
        StringBuilder su = new StringBuilder();
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        r = r.length() == 1 ? "0" + r : r;
        g = g.length() == 1 ? "0" + g : g;
        b = b.length() == 1 ? "0" + b : b;
        r = r.toUpperCase();
        g = g.toUpperCase();
        b = b.toUpperCase();
        su.append(r);
        su.append(g);
        su.append(b);
        return su.toString();
    }

    public static Color hexToColor(String colorStr) {
        return ColorUtil.intToColor(ColorUtil.hexToInt(colorStr));
    }

    public static int hexToInt(String hex) {
        return Integer.valueOf(hex, 16);
    }

    public static String RgbToHex(int r, int g, int b) {
        return ColorUtil.vali(ColorUtil.getHexNum(r)) + ColorUtil.vali(ColorUtil.getHexNum(g)) + ColorUtil.vali(ColorUtil.getHexNum(b));
    }

    public static String intToHex(int rgb) {
        Color color = ColorUtil.intToColor(rgb);
        return ColorUtil.RgbToHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String vali(String s) {
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static String getHexNum(int num) {
        int result = num / 16;
        int mod = num % 16;
        StringBuilder s = new StringBuilder();
        ColorUtil.hexHelp(result, mod, s);
        return s.toString();
    }

    private static void hexHelp(int result, int mod, StringBuilder s) {
        char[] H = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (result > 0) {
            ColorUtil.hexHelp(result / 16, result % 16, s);
        }
        s.append(H[mod]);
    }

    public static Color intToColor(int value) {
        Color color = new Color(value);
        return color;
    }
}

