/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.media;

import com.xnx3.media.ColorUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImageUtil {
    public static BufferedImage replaceColor(BufferedImage bufferedImage, String oldHex, String newHex) {
        int newC = ColorUtil.hexToInt(newHex);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, bufferedImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(bufferedImage, 0, 0, width, height, null);
        g.dispose();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!ColorUtil.intToHex(newImage.getRGB(x, y)).equals(oldHex)) continue;
                newImage.setRGB(x, y, newC);
            }
        }
        return newImage;
    }

    public static BufferedImage bigImage(BufferedImage originalImage, Integer times) {
        int width = originalImage.getWidth() * times;
        int height = originalImage.getHeight() * times;
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return newImage;
    }

    public static InputStream proportionZoom(InputStream inputStream, int maxWidth, String suffix) {
        if (inputStream == null) {
            return null;
        }
        if (maxWidth == 0 || maxWidth < 0) {
            return inputStream;
        }
        try {
            BufferedImage bi = ImageIO.read(inputStream);
            BufferedImage b = ImageUtil.proportionZoom(bi, maxWidth);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)b, suffix, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return is;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage proportionZoom(BufferedImage bufferedImage, int maxWidth) {
        if (maxWidth == 0 || maxWidth < 0) {
            return bufferedImage;
        }
        if (bufferedImage == null) {
            return null;
        }
        int originalWidth = bufferedImage.getWidth();
        if (maxWidth < originalWidth) {
            int originalHeight = bufferedImage.getHeight();
            int height = originalHeight * maxWidth / originalWidth;
            BufferedImage newImage = new BufferedImage(maxWidth, height, bufferedImage.getType());
            Graphics g = newImage.getGraphics();
            g.drawImage(bufferedImage, 0, 0, maxWidth, height, null);
            g.dispose();
            return newImage;
        }
        return bufferedImage;
    }

    public static BufferedImage getBufferedImageByUrl(String imageUrl) {
        URL url = null;
        try {
            url = new URL(imageUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage inputStreamToBufferedImage(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            return ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] inputStreamToByte(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        try {
            while ((rc = is.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageType(byte[] imageBytes) {
        if (imageBytes == null) {
            return null;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(imageBytes);
        ImageInputStream imageInput = null;
        String type = null;
        try {
            imageInput = ImageIO.createImageInputStream(input);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInput);
            if (iterator.hasNext()) {
                ImageReader reader = iterator.next();
                type = reader.getFormatName().toUpperCase();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (imageInput != null) {
                try {
                    imageInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return type;
    }

    public static InputStream bufferedImageToInputStream(BufferedImage bufferedImage, String imageFileSuffix) {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, imageFileSuffix, os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return is;
    }

    public static byte[] bufferedImageToByte(BufferedImage bufferedImage, String imageSuffix) {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, imageSuffix, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out == null) {
            return null;
        }
        return out.toByteArray();
    }

    public static BufferedImage loadLocalhostImage(String path) {
        if (path == null) {
            return null;
        }
        try {
            return ImageIO.read(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveToLocalhost(BufferedImage bufferedImage, String formatName, String path) {
        File f = new File(path);
        try {
            ImageIO.write((RenderedImage)bufferedImage, formatName, f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage formatConversion(BufferedImage bufferedImage) {
        Image image = bufferedImage.getScaledInstance(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        BufferedImage tag = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return tag;
    }

    public static BufferedImage watermark(BufferedImage originalImage, BufferedImage shuiyinImage, int startX, int startY, int width, int height) {
        Graphics2D g = originalImage.createGraphics();
        g.drawImage(shuiyinImage, startX, startY, width, height, null);
        return originalImage;
    }

    public static String bufferedImageToBase64(BufferedImage bufferedImage, String suffix) {
        byte[] data = ImageUtil.bufferedImageToByte(bufferedImage, suffix);
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data).replaceAll("\r|\n", "");
    }

    public static BufferedImage base64TobufferedImage(String base64Str) {
        if (base64Str == null) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(base64Str);
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            BufferedImage bi = ImageIO.read(bais);
            return bi;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

