/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamCleanerJob;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ActivityStreamCleaner {
    private static final Log LOG = LogFactory.getLog(ActivityStreamCleaner.class);
    private static final String CLEANER_JOB_DOCNAME = "Scheduler.ActivityStreamCleaner";
    private static final String CLEANER_JOB_NAME = "ActivityStream cleaner";
    private static final String CLEANER_JOB_CRON = "0 0 0 ? * SUN";
    private static final String XWIKI_DEFAULT_ADMIN = "XWiki.Admin";
    private static final String XWIKI_RIGHTS_CLASS = "XWiki.XWikiRights";
    private static ActivityStreamCleaner instance;

    private ActivityStreamCleaner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityStreamCleaner getInstance() {
        Class<ActivityStreamCleaner> clazz = ActivityStreamCleaner.class;
        synchronized (ActivityStreamCleaner.class) {
            if (instance == null) {
                instance = new ActivityStreamCleaner();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static int getNumberOfDaysToKeep(XWikiContext context) {
        ActivityStreamPlugin plugin = (ActivityStreamPlugin)context.getWiki().getPlugin("activitystream", context);
        String pref = plugin.getActivityStreamPreference("daystokeepevents", "0", context);
        return Integer.parseInt(pref);
    }

    private boolean setCleanerCommonDocumentsFields(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((String)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(XWIKI_DEFAULT_ADMIN);
        }
        if (StringUtils.isBlank((String)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator(XWIKI_DEFAULT_ADMIN);
        }
        if (StringUtils.isBlank((String)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("Scheduler.WebHome");
        }
        return needsUpdate;
    }

    private boolean createWatchListJobRightsObject(XWikiDocument doc, XWikiContext context) throws XWikiException {
        BaseObject rights = doc.getObject(XWIKI_RIGHTS_CLASS);
        if (rights == null) {
            int index = doc.createNewObject(XWIKI_RIGHTS_CLASS, context);
            rights = doc.getObject(XWIKI_RIGHTS_CLASS, index);
            rights.setLargeStringValue("groups", "XWiki.XWikiAdminGroup");
            rights.setStringValue("levels", "edit,delete");
            rights.setIntValue("allow", 1);
            return true;
        }
        return false;
    }

    private void initCleanerJob(XWikiContext context) throws XWikiException {
        boolean needsUpdate = false;
        BaseObject job = null;
        try {
            XWikiDocument doc = context.getWiki().getDocument(CLEANER_JOB_DOCNAME, context);
            needsUpdate = this.setCleanerCommonDocumentsFields(doc);
            job = doc.getObject("XWiki.SchedulerJobClass");
            if (job == null) {
                needsUpdate = true;
                int index = doc.createNewObject("XWiki.SchedulerJobClass", context);
                job = doc.getObject("XWiki.SchedulerJobClass", index);
                job.setStringValue("jobName", CLEANER_JOB_NAME);
                job.setStringValue("jobClass", ActivityStreamCleanerJob.class.getName());
                job.setStringValue("cron", CLEANER_JOB_CRON);
                job.setStringValue("contextUser", XWIKI_DEFAULT_ADMIN);
                job.setStringValue("contextLang", "en");
                job.setStringValue("contextDatabase", "xwiki");
            }
            needsUpdate = this.createWatchListJobRightsObject(doc, context);
            if (StringUtils.isBlank((String)doc.getContent())) {
                needsUpdate = true;
                doc.setContent("{{include document=\"XWiki.SchedulerJobSheet\"/}}");
                doc.setSyntaxId(XWikiDocument.XWIKI20_SYNTAXID);
            }
            if (needsUpdate) {
                context.getWiki().saveDocument(doc, "", true, context);
                ((SchedulerPlugin)context.getWiki().getPlugin("scheduler", context)).scheduleJob(job, context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot initialize ActivityStreamCleanerJob", (Throwable)e);
        }
    }

    public void init(XWikiContext context) throws XWikiException {
        if (ActivityStreamCleaner.getNumberOfDaysToKeep(context) > 0) {
            this.initCleanerJob(context);
        }
    }
}

