/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPlugin;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationManagerPluginApi
extends PluginApi {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Log LOG = LogFactory.getLog((Class)(class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManagerPluginApi == null ? (class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManagerPluginApi = ApplicationManagerPluginApi.class$("com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi")) : class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManagerPluginApi));
    private XWikiExceptionApi defaultException;
    private XWikiPluginMessageTool messageTool;
    static /* synthetic */ Class class$com$xpn$xwiki$plugin$applicationmanager$ApplicationManagerPluginApi;

    public ApplicationManagerPluginApi(ApplicationManagerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        this.defaultException = new XWikiExceptionApi((XWikiException)ApplicationManagerException.getDefaultException(), context);
        Locale locale = (Locale)context.get("locale");
        this.messageTool = new XWikiPluginMessageTool(locale, (XWikiPluginInterface)plugin, context);
        context.put("applicationmanagermessagetool", this.messageTool);
    }

    public XWikiExceptionApi getDefaultException() {
        return this.defaultException;
    }

    public XWikiMessageTool getMessageTool() {
        return this.messageTool;
    }

    public XWikiApplication createApplicationDocument() throws XWikiException {
        return (XWikiApplication)XWikiApplicationClass.getInstance(((Api)this).context).newSuperDocument(((Api)this).context);
    }

    public int createApplication(XWikiApplication appSuperDocument, boolean failOnExist) throws XWikiException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().createApplication(appSuperDocument, failOnExist, this.messageTool.get("applicationmanager.plugin.createapplication.comment", appSuperDocument.toString()), ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)MessageFormat.format("Try to create application [{0}]", appSuperDocument), (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteApplication(String appName) throws XWikiException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().deleteApplication(appName, ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)MessageFormat.format("Try to delete application [{0}]", appName), (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public List getApplicationDocumentList() throws XWikiException {
        List listDocument = Collections.EMPTY_LIST;
        try {
            listDocument = ApplicationManager.getInstance().getApplicationList(((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to get all applications documents", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
        }
        return listDocument;
    }

    public XWikiApplication getApplicationDocument(String appName) throws XWikiException {
        XWikiApplication app = null;
        try {
            app = ApplicationManager.getInstance().getApplication(appName, ((Api)this).context, true);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to get application document from application name", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
        }
        return app;
    }

    public int exportApplicationXAR(String appName) throws XWikiException, IOException {
        return this.exportApplicationXAR(appName, true, false);
    }

    public int exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory) throws XWikiException, IOException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().exportApplicationXAR(appName, recurse, withDocHistory, ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to export application in a XAR package", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int importApplication(String packageName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            ApplicationManager.getInstance().importApplication(((Api)this).context.getDoc(), packageName, this.messageTool.get("applicationmanager.plugin.importapplication.comment", packageName), ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to import applications from XAR package", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadApplication(String appName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            XWikiApplication app = ApplicationManager.getInstance().getApplication(appName, ((Api)this).context, true);
            ApplicationManager.getInstance().reloadApplication(app, this.messageTool.get("applicationmanager.plugin.reloadapplication.comment", app.getAppName()), ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to reload application", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadAllApplications() throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            ApplicationManager.getInstance().reloadAllApplications(this.messageTool.get("applicationmanager.plugin.reloadallapplications.comment"), ((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to reload all applications", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
            returncode = e.getCode();
        }
        return returncode;
    }

    public XWikiApplication getRootApplication() throws XWikiException {
        XWikiApplication app = null;
        try {
            app = ApplicationManager.getInstance().getRootApplication(((Api)this).context);
        }
        catch (ApplicationManagerException e) {
            LOG.error((Object)"Try to get root application document", (Throwable)((Object)e));
            ((Api)this).context.put(CONTEXT_LASTERRORCODE, new Integer(e.getCode()));
            ((Api)this).context.put(CONTEXT_LASTEXCEPTION, new XWikiExceptionApi((XWikiException)e, ((Api)this).context));
        }
        return app;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

