/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.BooleanClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultXObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocumentDoesNotExistException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXClassManager<T extends XObjectDocument>
implements XClassManager<T> {
    private static final String DEFAULT_XWIKICLASS_PARENT = "XWiki.XWikiClasses";
    private static final String DOCUMENTCONTENT_EXT = ".vm";
    private static final String DOCUMENTCONTENT_SHEET_PREFIX = "sheets/";
    private static final String DOCUMENTCONTENT_TEMPLATE_PREFIX = "templates/";
    private static final String HQL_PARAMETER_STRING = "?";
    private final String classSpacePrefix;
    private final String classPrefix;
    private final String classSpace;
    private final String className;
    private final String classFullName;
    private final String classSheetSpace;
    private final String classSheetName;
    private final String classSheetFullName;
    private final String classTemplateSpace;
    private final String classTemplateName;
    private final String classTemplateFullName;
    private final String classSheetDefaultContent;
    private final String classTemplateDefaultContent;
    private BaseClass baseClass;
    private boolean checkingClass;
    private boolean checkingClassSheet;
    private boolean checkingClassTemplate;

    protected AbstractXClassManager(String prefix) {
        this("XWiki", prefix);
    }

    protected AbstractXClassManager(String spaceprefix, String prefix) {
        this(spaceprefix, prefix, true);
    }

    protected AbstractXClassManager(String spaceprefix, String prefix, boolean dispatch) {
        this.classSpacePrefix = spaceprefix;
        this.classPrefix = prefix;
        this.classSpace = dispatch ? this.classSpacePrefix + "Classes" : this.classSpacePrefix;
        this.className = this.classPrefix + "Class";
        this.classFullName = this.classSpace + "." + this.className;
        this.classSheetSpace = dispatch ? this.classSpacePrefix + "Sheets" : this.classSpacePrefix;
        this.classSheetName = this.classPrefix + "ClassSheet";
        this.classSheetFullName = this.classSheetSpace + "." + this.classSheetName;
        this.classTemplateSpace = dispatch ? this.classSpacePrefix + "Templates" : this.classSpacePrefix;
        this.classTemplateName = this.classPrefix + "ClassTemplate";
        this.classTemplateFullName = this.classTemplateSpace + "." + this.classTemplateName;
        this.classSheetDefaultContent = "## you can modify this page to customize the presentation of your object\n\n1 Document $doc.name\n\n#set($class = $doc.getObject(\"" + this.classFullName + "\").xWikiClass)\n" + "\n" + "<dl>\n" + "  #foreach($prop in $class.properties)\n" + "    <dt> ${prop.prettyName} </dt>\n" + "    <dd>$doc.display($prop.getName())</dd>\n  #end\n" + "</dl>\n";
        this.classTemplateDefaultContent = "#includeForm(\"" + this.classSheetFullName + "\")\n";
    }

    @Override
    public String getClassSpacePrefix() {
        return this.classSpacePrefix;
    }

    @Override
    public String getClassSpace() {
        return this.classSpace;
    }

    @Override
    public String getClassPrefix() {
        return this.classPrefix;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getClassFullName() {
        return this.classFullName;
    }

    @Override
    public String getClassTemplateSpace() {
        return this.classTemplateSpace;
    }

    @Override
    public String getClassTemplateName() {
        return this.classTemplateName;
    }

    @Override
    public String getClassTemplateFullName() {
        return this.classTemplateFullName;
    }

    @Override
    public String getClassSheetSpace() {
        return this.classSheetSpace;
    }

    @Override
    public String getClassSheetName() {
        return this.classSheetName;
    }

    @Override
    public String getClassSheetFullName() {
        return this.classSheetFullName;
    }

    @Override
    public boolean forceValidDocumentName() {
        return false;
    }

    protected void check(XWikiContext context) throws XWikiException {
        this.checkClassDocument(context);
        this.checkClassSheetDocument(context);
        this.checkClassTemplateDocument(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClassDocument(XWikiContext context) throws XWikiException {
        if (this.checkingClass) {
            return;
        }
        this.checkingClass = true;
        try {
            XWikiDocument doc;
            XWiki xwiki = context.getWiki();
            boolean needsUpdate = false;
            try {
                doc = xwiki.getDocument(this.getClassFullName(), context);
            }
            catch (Exception e) {
                doc = new XWikiDocument();
                doc.setSpace(this.getClassSpace());
                doc.setName(this.getClassName());
                doc.setParent(DEFAULT_XWIKICLASS_PARENT);
                doc.setCreator("superadmin");
                doc.setAuthor(doc.getCreator());
                needsUpdate = true;
            }
            this.baseClass = doc.getxWikiClass();
            if (doc.isNew() || (needsUpdate |= this.updateBaseClass(this.baseClass))) {
                xwiki.saveDocument(doc, context);
            }
        }
        finally {
            this.checkingClass = false;
        }
    }

    @Override
    public String getClassSheetDefaultContent() {
        return this.classSheetDefaultContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceDocumentContent(String path) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
        if (in != null) {
            try {
                StringBuffer content = new StringBuffer(in.available());
                InputStreamReader isr = new InputStreamReader(in);
                try {
                    BufferedReader reader = new BufferedReader(isr);
                    String str = reader.readLine();
                    while (str != null) {
                        content.append(str);
                        content.append('\n');
                        str = reader.readLine();
                    }
                }
                finally {
                    isr.close();
                }
                return content.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClassSheetDocument(XWikiContext context) throws XWikiException {
        if (this.checkingClassSheet) {
            return;
        }
        this.checkingClassSheet = true;
        try {
            XWikiDocument doc;
            XWiki xwiki = context.getWiki();
            boolean needsUpdate = false;
            try {
                doc = xwiki.getDocument(this.getClassSheetFullName(), context);
            }
            catch (Exception e) {
                doc = new XWikiDocument();
                doc.setSpace(this.getClassSheetSpace());
                doc.setName(this.getClassSheetName());
                doc.setParent(this.getClassFullName());
                needsUpdate = true;
            }
            if (doc.isNew()) {
                String documentContentPath = DOCUMENTCONTENT_SHEET_PREFIX + this.getClassSheetFullName() + DOCUMENTCONTENT_EXT;
                String content = this.getResourceDocumentContent(documentContentPath);
                doc.setContent(content != null ? content : this.getClassSheetDefaultContent());
                doc.setSyntaxId(XWikiDocument.XWIKI10_SYNTAXID);
            }
            if (doc.isNew() || needsUpdate) {
                xwiki.saveDocument(doc, context);
            }
        }
        finally {
            this.checkingClassSheet = false;
        }
    }

    @Override
    public String getClassTemplateDefaultContent() {
        return this.classTemplateDefaultContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClassTemplateDocument(XWikiContext context) throws XWikiException {
        if (this.checkingClassTemplate) {
            return;
        }
        this.checkingClassTemplate = true;
        try {
            XWikiDocument doc;
            XWiki xwiki = context.getWiki();
            boolean needsUpdate = false;
            try {
                doc = xwiki.getDocument(this.getClassTemplateFullName(), context);
            }
            catch (Exception e) {
                doc = new XWikiDocument();
                doc.setSpace(this.getClassTemplateSpace());
                doc.setName(this.getClassTemplateName());
                needsUpdate = true;
            }
            if (doc.getObject(this.getClassFullName()) == null) {
                doc.createNewObject(this.getClassFullName(), context);
                needsUpdate = true;
            }
            if (doc.isNew()) {
                String content = this.getResourceDocumentContent(DOCUMENTCONTENT_TEMPLATE_PREFIX + this.getClassTemplateFullName() + DOCUMENTCONTENT_EXT);
                doc.setContent(content != null ? content : this.getClassTemplateDefaultContent());
                doc.setSyntaxId(XWikiDocument.XWIKI10_SYNTAXID);
                doc.setParent(this.getClassFullName());
            }
            if (doc.isNew() || (needsUpdate |= this.updateClassTemplateDocument(doc))) {
                xwiki.saveDocument(doc, context);
            }
        }
        finally {
            this.checkingClassTemplate = false;
        }
    }

    protected int intFromBoolean(Boolean value) {
        return value == null ? -1 : (value != false ? 1 : 0);
    }

    protected boolean updateClassTemplateDocument(XWikiDocument doc) {
        return false;
    }

    protected boolean updateDocStringValue(XWikiDocument doc, String fieldName, String value) {
        boolean needsUpdate = false;
        if (!value.equals(doc.getStringValue(this.getClassFullName(), fieldName))) {
            doc.setStringValue(this.getClassFullName(), fieldName, value);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    protected boolean updateDocBooleanValue(XWikiDocument doc, String fieldName, Boolean value) {
        boolean needsUpdate = false;
        int intvalue = this.intFromBoolean(value);
        if (intvalue != doc.getIntValue(this.getClassFullName(), fieldName)) {
            doc.setIntValue(this.getClassFullName(), fieldName, intvalue);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    protected boolean updateBaseClass(BaseClass baseClass) {
        boolean needUpdate = false;
        if (!baseClass.getName().equals(this.getClassFullName())) {
            baseClass.setName(this.getClassFullName());
            needUpdate = true;
        }
        return needUpdate;
    }

    protected boolean updateBooleanClassDefaultValue(BaseClass baseClass, String fieldName, Boolean value) {
        boolean needsUpdate = false;
        BooleanClass bc = (BooleanClass)baseClass.get(fieldName);
        int old = bc.getDefaultValue();
        int intvalue = this.intFromBoolean(value);
        if (intvalue != old) {
            bc.setDefaultValue(intvalue);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    @Override
    public BaseClass getBaseClass() {
        if (this.baseClass == null) {
            this.baseClass = new BaseClass();
            this.updateBaseClass(this.baseClass);
        }
        return this.baseClass;
    }

    @Override
    public Document getClassDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassFullName(), context).newDocument(context);
    }

    @Override
    public Document getClassSheetDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassSheetFullName(), context).newDocument(context);
    }

    @Override
    public Document getClassTemplateDocument(XWikiContext context) throws XWikiException {
        this.check(context);
        return context.getWiki().getDocument(this.getClassTemplateFullName(), context).newDocument(context);
    }

    @Override
    public boolean isInstance(XWikiDocument doc) {
        return doc.getObjectNumbers(this.getClassFullName()) > 0 && (!this.forceValidDocumentName() || this.isValidName(doc.getFullName()));
    }

    @Override
    public boolean isInstance(Document doc) {
        return doc.getObjectNumbers(this.getClassFullName()) > 0 && (!this.forceValidDocumentName() || this.isValidName(doc.getFullName()));
    }

    @Override
    public boolean isValidName(String fullName) {
        return this.getItemDefaultName(fullName) != null;
    }

    @Override
    public String getItemDocumentDefaultName(String itemName, XWikiContext context) {
        String cleanedItemName = context != null ? context.getWiki().clearName(itemName, true, true, context) : itemName;
        return this.getClassPrefix() + cleanedItemName.substring(0, 1).toUpperCase() + cleanedItemName.substring(1).toLowerCase();
    }

    @Override
    public String getItemDocumentDefaultFullName(String itemName, XWikiContext context) {
        return this.getClassSpacePrefix() + "." + this.getItemDocumentDefaultName(itemName, context);
    }

    @Override
    public String getItemDefaultName(String docFullName) {
        String prefix = this.getClassSpacePrefix() + "." + this.getClassPrefix();
        if (!docFullName.startsWith(prefix)) {
            return null;
        }
        return docFullName.substring(prefix.length()).toLowerCase();
    }

    @Override
    public T getXObjectDocument(String itemName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(this.getItemDocumentDefaultFullName(itemName, context), context);
        if (doc.isNew() || !this.isInstance(doc)) {
            throw new XObjectDocumentDoesNotExistException(itemName + " object does not exist");
        }
        return this.newXObjectDocument(doc, objectId, context);
    }

    @Override
    public String createWhereClause(Object[][] fieldDescriptors, List<Object> parameterValues) {
        StringBuffer from = new StringBuffer(", BaseObject as obj");
        StringBuffer where = new StringBuffer(" where doc.fullName=obj.name and obj.className=?");
        parameterValues.add(this.getClassFullName());
        if (this.forceValidDocumentName()) {
            where.append(" and doc.fullName LIKE?");
            parameterValues.add(this.getItemDocumentDefaultFullName("%", null));
        }
        where.append(" and doc.fullName<>?");
        parameterValues.add(this.getClassTemplateFullName());
        String andSymbol = " and ";
        if (fieldDescriptors != null) {
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                String fieldName = (String)fieldDescriptors[i][0];
                String type = (String)fieldDescriptors[i][1];
                Object value = fieldDescriptors[i][2];
                if (type != null) {
                    String fieldPrefix = "field" + i;
                    from.append(", " + type + " as " + fieldPrefix);
                    where.append(andSymbol + "obj.id=" + fieldPrefix + ".id.id");
                    where.append(andSymbol + fieldPrefix + ".name=" + HQL_PARAMETER_STRING);
                    parameterValues.add(fieldName);
                    if (value instanceof String) {
                        where.append(andSymbol + "lower(" + fieldPrefix + ".value)=" + HQL_PARAMETER_STRING);
                        parameterValues.add(((String)value).toLowerCase());
                        continue;
                    }
                    where.append(andSymbol + "" + fieldPrefix + ".value=" + HQL_PARAMETER_STRING);
                    parameterValues.add(value);
                    continue;
                }
                if (value instanceof String) {
                    where.append(" and lower(doc." + fieldName + ")=" + HQL_PARAMETER_STRING);
                    parameterValues.add(((String)value).toLowerCase());
                    continue;
                }
                where.append(" and doc." + fieldName + "=" + HQL_PARAMETER_STRING);
                parameterValues.add(value);
            }
        }
        return from.append(where).toString();
    }

    public List<T> searchXObjectDocuments(XWikiContext context) throws XWikiException {
        return this.searchXObjectDocumentsByFields(null, context);
    }

    public List<T> searchXObjectDocumentsByField(String fieldName, Object fieldValue, String fieldType, XWikiContext context) throws XWikiException {
        Object[][] fieldDescriptors = new Object[][]{{fieldName, fieldType, fieldValue}};
        return this.searchXObjectDocumentsByFields(fieldDescriptors, context);
    }

    public List<T> searchXObjectDocumentsByFields(Object[][] fieldDescriptors, XWikiContext context) throws XWikiException {
        this.check(context);
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String where = this.createWhereClause(fieldDescriptors, parameterValues);
        return this.newXObjectDocumentList(context.getWiki().getStore().searchDocuments(where, parameterValues, context), context);
    }

    @Override
    public T newXObjectDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return (T)new DefaultXObjectDocument(this, doc, objId, context);
    }

    @Override
    public T newXObjectDocument(String docFullName, int objId, XWikiContext context) throws XWikiException {
        return this.newXObjectDocument(context.getWiki().getDocument(docFullName, context), objId, context);
    }

    @Override
    public T newXObjectDocument(XWikiContext context) throws XWikiException {
        return this.newXObjectDocument(new XWikiDocument(), 0, context);
    }

    @Override
    public List<T> newXObjectDocumentList(XWikiDocument document, XWikiContext context) throws XWikiException {
        ArrayList<XWikiDocument> documents = new ArrayList<XWikiDocument>(1);
        documents.add(document);
        return this.newXObjectDocumentList(documents, context);
    }

    @Override
    public List<T> newXObjectDocumentList(List<XWikiDocument> documents, XWikiContext context) throws XWikiException {
        ArrayList<T> list = new ArrayList<T>(documents.size());
        for (XWikiDocument doc : documents) {
            Vector objects = doc.getObjects(this.getClassFullName());
            for (BaseObject bobject : objects) {
                if (bobject == null) continue;
                list.add(this.newXObjectDocument(doc, bobject.getNumber(), context));
            }
        }
        return list;
    }
}

