/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPlugin;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManagerPluginApi
extends PluginApi<ApplicationManagerPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Log LOG = LogFactory.getLog(ApplicationManagerPluginApi.class);
    private XWikiExceptionApi defaultException;
    private ApplicationManagerMessageTool messageTool;

    public ApplicationManagerPluginApi(ApplicationManagerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        this.defaultException = new XWikiExceptionApi((XWikiException)((Object)ApplicationManagerException.getDefaultException()), context);
        Locale locale = (Locale)context.get((Object)"locale");
        this.messageTool = new ApplicationManagerMessageTool(locale, plugin, context);
        context.put((Object)"applicationmanagermessagetool", (Object)this.messageTool);
    }

    public XWikiExceptionApi getDefaultException() {
        return this.defaultException;
    }

    public XWikiMessageTool getMessageTool() {
        return this.messageTool;
    }

    public void logError(String errorMessage, XWikiException e) {
        LOG.error((Object)errorMessage, (Throwable)e);
        this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi(e, this.context));
    }

    public XWikiApplication createApplicationDocument() throws XWikiException {
        return (XWikiApplication)XWikiApplicationClass.getInstance(this.context).newXObjectDocument(this.context);
    }

    public int createApplication(XWikiApplication appXObjectDocument, boolean failOnExist) throws XWikiException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().createApplication(appXObjectDocument, failOnExist, this.messageTool.get("applicationmanager.plugin.comment.createapplication", appXObjectDocument.toString()), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.createapplication", appXObjectDocument.toString()), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteApplication(String appName) throws XWikiException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().deleteApplication(appName, this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.deleteapplication", appName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public List<XWikiApplication> getApplicationDocumentList() throws XWikiException {
        List<XWikiApplication> listDocument = Collections.emptyList();
        try {
            listDocument = ApplicationManager.getInstance().getApplicationList(this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.getallapplications"), (XWikiException)((Object)e));
        }
        return listDocument;
    }

    public XWikiApplication getApplicationDocument(String appName) throws XWikiException {
        XWikiApplication app = null;
        try {
            app = ApplicationManager.getInstance().getApplication(appName, this.context, true);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.getapplication", appName), (XWikiException)((Object)e));
        }
        return app;
    }

    public int exportApplicationXAR(String appName) throws XWikiException, IOException {
        return this.exportApplicationXAR(appName, true, false);
    }

    public int exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory) throws XWikiException, IOException {
        int returncode = -1;
        try {
            ApplicationManager.getInstance().exportApplicationXAR(appName, recurse, withDocHistory, this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.exportapplication", appName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int importApplication(String packageName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            ApplicationManager.getInstance().importApplication(this.context.getDoc(), packageName, this.messageTool.get("applicationmanager.plugin.comment.importapplication", packageName), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.importapplication", packageName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadApplication(String appName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            XWikiApplication app = ApplicationManager.getInstance().getApplication(appName, this.context, true);
            ApplicationManager.getInstance().reloadApplication(app, this.messageTool.get("applicationmanager.plugin.comment.reloadapplication", app.getAppName()), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.reloadapplication", appName), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadAllApplications() throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            ApplicationManager.getInstance().reloadAllApplications(this.messageTool.get("applicationmanager.plugin.comment.reloadallapplications"), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.realoadallapplications"), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public XWikiApplication getRootApplication() throws XWikiException {
        XWikiApplication app = null;
        try {
            app = ApplicationManager.getInstance().getRootApplication(this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.messageTool.get("applicationmanager.plugin.log.getrootapplication"), (XWikiException)((Object)e));
        }
        return app;
    }
}

