/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.invitationmanager.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.invitationmanager.api.Invitation;
import com.xpn.xwiki.plugin.invitationmanager.impl.InvitationManagerImpl;
import com.xpn.xwiki.plugin.invitationmanager.impl.JoinRequestImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InvitationImpl
extends JoinRequestImpl
implements Invitation {
    public InvitationImpl(String invitee, String space, boolean create, InvitationManagerImpl manager, XWikiContext context) throws XWikiException {
        this(invitee, null, space, false, Collections.EMPTY_LIST, Collections.EMPTY_MAP, create, manager, context);
    }

    public InvitationImpl(String invitee, String inviter, String space, boolean open, List roles, Map map, boolean create, InvitationManagerImpl manager, XWikiContext context) throws XWikiException {
        super(manager, context);
        this.initRequestDoc(space, invitee);
        if (create && this.isNew()) {
            this.createRequestDoc(invitee, inviter, space, open, roles, map);
        }
    }

    public InvitationImpl(String fullName, InvitationManagerImpl manager, XWikiContext context) throws XWikiException {
        super(fullName, manager, context);
    }

    protected String getClassName() {
        return this.manager.getInvitationClassName();
    }

    public String getCode() {
        String code = (String)this.getValue("code", this.getObject(this.getClassName()));
        return code == null ? "" : code;
    }

    public String getInvitee() {
        String invitee = (String)this.getValue("invitee", this.getObject(this.getClassName()));
        return invitee == null ? "" : invitee;
    }

    public String getInviter() {
        String inviter = (String)this.getValue("inviter", this.getObject(this.getClassName()));
        return inviter == null ? "" : inviter;
    }

    public boolean isOpen() {
        Integer open = (Integer)this.getValue("open", this.getObject(this.getClassName()));
        return open != null && open > 0;
    }

    public void setCode(String code) {
        this.getDoc().getObject(this.getClassName()).setStringValue("code", code);
    }

    public void setInvitee(String invitee) {
        this.getDoc().getObject(this.getClassName()).setStringValue("invitee", invitee);
    }

    public void setInviter(String inviter) {
        this.getDoc().getObject(this.getClassName()).setStringValue("inviter", inviter);
    }

    public void setOpen(boolean open) {
        this.getDoc().getObject(this.getClassName()).setIntValue("open", open ? 1 : 0);
    }

    protected void initRequestDoc(String space, String invitee) throws XWikiException {
        String docName = this.manager.getJoinRequestDocumentName("Invitation", space, invitee, this.context);
        this.doc = this.context.getWiki().getDocument(docName, this.context);
    }

    protected void createRequestDoc(String invitee, String inviter, String space, boolean open, List roles, Map map) {
        XWikiDocument requestDoc = this.getDoc();
        String className = this.getClassName();
        BaseObject requestObj = new BaseObject();
        requestObj.setName(this.doc.getFullName());
        requestObj.setClassName(className);
        requestDoc.addObject(className, requestObj);
        this.setInvitee(invitee);
        this.setInviter(inviter);
        this.setSpace(space);
        this.setOpen(open);
        this.setRoles(roles);
        this.setMap(map);
    }

    public static interface InvitationFields
    extends JoinRequestImpl.JoinRequestFields {
        public static final String INVITEE = "invitee";
        public static final String INVITER = "inviter";
        public static final String CODE = "code";
        public static final String OPEN = "open";
    }
}

