/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.invitationmanager.impl;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.invitationmanager.api.Invitation;
import com.xpn.xwiki.plugin.invitationmanager.api.InvitationManager;
import com.xpn.xwiki.plugin.invitationmanager.api.InvitationManagerException;
import com.xpn.xwiki.plugin.invitationmanager.api.JoinRequest;
import com.xpn.xwiki.plugin.invitationmanager.api.MembershipRequest;
import com.xpn.xwiki.plugin.invitationmanager.impl.InvitationImpl;
import com.xpn.xwiki.plugin.invitationmanager.impl.MembershipRequestImpl;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import com.xpn.xwiki.plugin.spacemanager.api.Space;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManager;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagers;
import com.xpn.xwiki.plugin.spacemanager.impl.SpaceUserProfileImpl;
import com.xpn.xwiki.render.XWikiVelocityRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.velocity.VelocityContext;

public class InvitationManagerImpl
implements InvitationManager {
    public static final String USER_PROFILES_DEFAULT = "1";
    public static final String SPACE_VELOCITY_KEY = "space";
    public static final String INVITATION_VELOCITY_KEY = "invitation";
    public static final String MEMBERSHIP_REQUEST_VELOCITY_KEY = "membershiprequest";
    public static final String INVITATION_CLASS_NAME = "XWiki.InvitationClass";
    public static final String MEMBERSHIP_REQUEST_CLASS_NAME = "XWiki.MembershipRequestClass";
    private boolean mailNotification = true;

    public boolean acceptInvitation(String space, String email, String code, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, email, context);
            if (code.equals(invitation.getCode()) && invitation.getStatus() == 2) {
                if (!invitation.isOpen()) {
                    invitation.setStatus(3);
                    invitation.setResponseDate(new Date());
                    invitation.setInvitee(context.getUser());
                    invitation.saveWithProgrammingRights();
                }
                if (this.isWithUserProfiles(context)) {
                    this.createSpaceUserProfile(space, context);
                }
                this.addMember(space, context.getUser(), invitation.getRoles(), context);
                this.customizeInvitation(invitation, 3, context);
                return true;
            }
            return false;
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public boolean verifyInvitation(String space, String email, String code, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, email, context);
            return code.equals(invitation.getCode()) && invitation.getStatus() == 2;
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public boolean acceptInvitation(String space, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, context.getUser(), context);
            if (invitation.isNew()) {
                return false;
            }
            int status = invitation.getStatus();
            if (status == 2 || status == 4) {
                invitation.setResponseDate(new Date());
                invitation.setStatus(3);
                if (this.isWithUserProfiles(context)) {
                    this.createSpaceUserProfile(space, context);
                }
                this.addMember(space, context.getUser(), invitation.getRoles(), context);
                invitation.saveWithProgrammingRights();
                return true;
            }
            return false;
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public boolean verifyInvitation(String space, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, context.getUser(), context);
            return invitation != null && invitation.getStatus() == 2;
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public boolean acceptMembership(String space, String userName, String templateMail, XWikiContext context) throws InvitationManagerException {
        try {
            MembershipRequest request = this.getMembershipRequest(space, userName, context);
            if (request.isNew()) {
                return false;
            }
            int status = request.getStatus();
            if (status == 2 || status == 4) {
                request.setResponseDate(new Date());
                request.setResponder(context.getUser());
                request.setStatus(3);
                this.sendMail("Accept", request, templateMail, context);
                this.createSpaceUserProfile(space, request, context);
                this.addMember(space, userName, request.getRoles(), context);
                request.saveWithProgrammingRights();
                return true;
            }
            return false;
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public boolean acceptMembership(String space, String userName, XWikiContext context) throws InvitationManagerException {
        String templateMail = this.getDefaultTemplateMailDocumentName(space, "Request", "Accept", context);
        return this.acceptMembership(space, userName, templateMail, context);
    }

    public void cancelInvitation(String userNameOrMail, String space, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, userNameOrMail, context);
            if (invitation.getStatus() == 2) {
                invitation.setStatus(5);
                invitation.saveWithProgrammingRights();
            }
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void cancelMembershipRequest(String space, XWikiContext context) throws InvitationManagerException {
        try {
            MembershipRequest request = this.getMembershipRequest(space, context.getUser(), context);
            if (request.getStatus() == 2) {
                request.setStatus(5);
                request.saveWithProgrammingRights();
            }
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public List getInvitations(int status, int start, int count, XWikiContext context) {
        try {
            Invitation prototype = this.createInvitation(context.getUser(), null, context);
            prototype.setStatus(status);
            return this.getInvitations(prototype, start, count, context);
        }
        catch (XWikiException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public void initClasses(XWikiContext context) throws XWikiException {
        this.getInvitationClass(context);
        this.getMembershipRequestClass(context);
    }

    protected BaseClass getInvitationClass(XWikiContext context) throws XWikiException {
        String className = this.getInvitationClassName();
        String classContent = "1 XWiki Invitation Class";
        return this.getJoinRequestClass(className, classContent, context);
    }

    protected BaseClass getMembershipRequestClass(XWikiContext context) throws XWikiException {
        String className = this.getMembershipRequestClassName();
        String classContent = "1 XWiki Membership Request Class";
        return this.getJoinRequestClass(className, classContent, context);
    }

    private BaseClass getJoinRequestClass(String className, String classContent, XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(className, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setFullName(className);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(className);
        needsUpdate |= bclass.addDateField("requestDate", "Request Date");
        needsUpdate |= bclass.addDateField("responseDate", "Response Date");
        needsUpdate |= bclass.addTextAreaField("text", "Text", 80, 10);
        needsUpdate |= bclass.addTextAreaField("map", "Map", 80, 10);
        needsUpdate |= bclass.addTextField(SPACE_VELOCITY_KEY, "Space", 32);
        needsUpdate |= bclass.addStaticListField("status", "Status", 1, false, "0=none|1=created|2=sent|3=accepted|4=refused|5=cancelled", "select");
        needsUpdate |= bclass.addDBListField("roles", "Roles", 5, true, "");
        if (className.equals(this.getInvitationClassName())) {
            needsUpdate |= bclass.addTextField("code", "Code", 40);
            needsUpdate |= bclass.addTextField("invitee", "Invitee", 40);
            needsUpdate |= bclass.addTextField("invitee", "Inviter", 40);
            needsUpdate |= bclass.addBooleanField("open", "Open", "yesno");
        } else if (className.equals(this.getMembershipRequestClassName())) {
            needsUpdate |= bclass.addTextField("requester", "Requester", 40);
            needsUpdate |= bclass.addTextField("responder", "Responder", 40);
        }
        String content = doc.getContent();
        if (content == null || content.equals("")) {
            needsUpdate = true;
            doc.setContent(classContent);
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    public List getInvitations(int start, int count, XWikiContext context) {
        return this.getInvitations(0, start, count, context);
    }

    public List getInvitations(int status, XWikiContext context) {
        return this.getInvitations(status, 0, 0, context);
    }

    public List getInvitations(Invitation prototype, int start, int count, XWikiContext context) {
        try {
            String inviter;
            List roles;
            String className = this.getInvitationClassName();
            StringBuffer fromClause = new StringBuffer("from XWikiDocument as doc, BaseObject as obj");
            StringBuffer whereClause = new StringBuffer("where doc.fullName=obj.name and obj.className = '" + className + "'");
            String space = prototype.getSpace();
            String invitee = prototype.getInvitee();
            if (!"".equals(space) && !"".equals(invitee)) {
                Invitation invitation = this.getInvitation(space, invitee, context);
                if (((Document)invitation).isNew()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList<Invitation> list = new ArrayList<Invitation>();
                list.add(invitation);
                return list;
            }
            if (!"".equals(space)) {
                fromClause.append(", StringProperty as space");
                whereClause.append(" and obj.id=space.id.id and space.id.name='space' and space.value='" + space + "'");
            } else if (!"".equals(invitee)) {
                fromClause.append(" StringProperty as invitee");
                whereClause.append(" and obj.id=invitee.id.id and invitee.id.name='invitee' and invitee.value='" + invitee + "'");
            }
            int status = prototype.getStatus();
            if (status != 0) {
                fromClause.append(", StringProperty as status");
                whereClause.append(" and obj.id=status.id.id and status.id.name='status' and status.value='" + status + "'");
            }
            if ((roles = prototype.getRoles()) != null && roles.size() > 0) {
                String role = (String)prototype.getRoles().get(0);
                fromClause.append(", DBStringListProperty as roles join roles.list as role");
                whereClause.append(" and obj.id=roles.id.id and roles.id.name='roles' and instr(role.id, '" + role + "')>0");
            }
            if (!"".equals(inviter = prototype.getInviter())) {
                fromClause.append(" StringProperty as inviter");
                whereClause.append(" and obj.id=inviter.id.id and inviter.id.name='inviter' and inviter.value='" + inviter + "'");
            }
            String sql = "select distinct doc.fullName " + fromClause.toString() + " " + whereClause.toString();
            return this.wrapInvitations(context.getWiki().getStore().search(sql, count, start, context), context);
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    private List wrapInvitations(List list, XWikiContext context) {
        ArrayList<InvitationImpl> result = new ArrayList<InvitationImpl>();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            String inviteDocName = (String)list.get(i);
            try {
                result.add(new InvitationImpl(inviteDocName, this, context));
                continue;
            }
            catch (XWikiException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List wrapMembershipRequests(List list, XWikiContext context) {
        ArrayList<MembershipRequestImpl> result = new ArrayList<MembershipRequestImpl>();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            String inviteDocName = (String)list.get(i);
            try {
                result.add(new MembershipRequestImpl(inviteDocName, this, context));
                continue;
            }
            catch (XWikiException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List getInvitations(Invitation prototype, XWikiContext context) {
        return this.getInvitations(prototype, 0, 0, context);
    }

    public List getInvitations(String space, int status, int start, int count, XWikiContext context) {
        return this.getInvitations(space, status, null, start, count, context);
    }

    public List getInvitations(String space, int start, int count, XWikiContext context) {
        return this.getInvitations(space, 0, start, count, context);
    }

    public List getInvitations(String space, int status, String role, int start, int count, XWikiContext context) {
        try {
            Invitation prototype = this.createInvitation(null, space, context);
            if (role != null && !"".equals(role)) {
                ArrayList<String> roles = new ArrayList<String>();
                roles.add(role);
                prototype.setRoles(roles);
            }
            prototype.setStatus(status);
            return this.getInvitations(prototype, start, count, context);
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List getInvitations(String space, int status, String role, XWikiContext context) {
        return this.getInvitations(space, status, role, 0, 0, context);
    }

    public List getInvitations(String space, int status, XWikiContext context) {
        return this.getInvitations(space, status, 0, 0, context);
    }

    public List getInvitations(String space, String role, int start, int count, XWikiContext context) {
        return this.getInvitations(space, 0, role, start, count, context);
    }

    public List getInvitations(String space, String role, XWikiContext context) {
        return this.getInvitations(space, role, 0, 0, context);
    }

    public List getInvitations(String space, XWikiContext context) {
        return this.getInvitations(space, 0, 0, context);
    }

    public List getInvitations(XWikiContext context) {
        return this.getInvitations(0, 0, context);
    }

    public List getMembershipRequests(int status, int start, int count, XWikiContext context) {
        try {
            MembershipRequest prototype = this.createMembershipRequest(context.getUser(), null, context);
            prototype.setStatus(status);
            return this.getMembershipRequests(prototype, start, count, context);
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List getMembershipRequests(int start, int count, XWikiContext context) {
        return this.getMembershipRequests(0, start, count, context);
    }

    public List getMembershipRequests(int status, XWikiContext context) {
        return this.getMembershipRequests(status, 0, 0, context);
    }

    public List getMembershipRequests(MembershipRequest prototype, int start, int count, XWikiContext context) {
        try {
            String responder;
            List roles;
            String className = this.getMembershipRequestClassName();
            StringBuffer fromClause = new StringBuffer("from XWikiDocument as doc, BaseObject as obj");
            StringBuffer whereClause = new StringBuffer("where doc.fullName=obj.name and obj.className = '" + className + "'");
            String space = prototype.getSpace();
            String requester = prototype.getRequester();
            if (!"".equals(space) && !"".equals(requester)) {
                MembershipRequest request = this.getMembershipRequest(space, requester, context);
                if (((Document)request).isNew()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList<MembershipRequest> list = new ArrayList<MembershipRequest>();
                list.add(request);
                return list;
            }
            if (!"".equals(space)) {
                fromClause.append(", StringProperty as space");
                whereClause.append(" and obj.id=space.id.id and space.id.name='space' and space.value='" + space + "'");
            } else if (!"".equals(requester)) {
                fromClause.append(" StringProperty as requester");
                whereClause.append(" and obj.id=requester.id.id and requester.id.name='requester' and requester.value='" + requester + "'");
            }
            int status = prototype.getStatus();
            if (status != 0) {
                fromClause.append(", StringProperty as status");
                whereClause.append(" and obj.id=status.id.id and status.id.name='status' and status.value='" + status + "'");
            }
            if ((roles = prototype.getRoles()) != null && roles.size() > 0) {
                String role = (String)prototype.getRoles().get(0);
                fromClause.append(", DBStringListProperty as roles join roles.list as role");
                whereClause.append(" and obj.id=roles.id.id and roles.id.name='roles' and instr(role.id, '" + role + "')>0");
            }
            if (!"".equals(responder = prototype.getResponder())) {
                fromClause.append(" StringProperty as responder");
                whereClause.append(" and obj.id=responder.id.id and responder.id.name='responder' and responder.value='" + responder + "'");
            }
            String sql = "select distinct doc.fullName " + fromClause.toString() + " " + whereClause.toString();
            return this.wrapMembershipRequests(context.getWiki().getStore().search(sql, count, start, context), context);
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List getMembershipRequests(MembershipRequest prototype, XWikiContext context) {
        return this.getMembershipRequests(prototype, 0, 0, context);
    }

    public List getMembershipRequests(String space, int status, int start, int count, XWikiContext context) {
        return this.getMembershipRequests(space, status, null, start, count, context);
    }

    public List getMembershipRequests(String space, int start, int count, XWikiContext context) {
        return this.getMembershipRequests(space, 0, start, count, context);
    }

    public List getMembershipRequests(String space, int status, String role, int start, int count, XWikiContext context) {
        try {
            MembershipRequest prototype = this.createMembershipRequest(null, space, context);
            if (role != null && !"".equals(role)) {
                ArrayList<String> roles = new ArrayList<String>();
                roles.add(role);
                prototype.setRoles(roles);
            }
            prototype.setStatus(status);
            return this.getMembershipRequests(prototype, start, count, context);
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List getMembershipRequests(String space, int status, String role, XWikiContext context) {
        return this.getMembershipRequests(space, status, role, 0, 0, context);
    }

    public List getMembershipRequests(String space, int status, XWikiContext context) {
        return this.getMembershipRequests(space, status, 0, 0, context);
    }

    public List getMembershipRequests(String space, String role, int start, int count, XWikiContext context) {
        return this.getMembershipRequests(space, 0, role, start, count, context);
    }

    public List getMembershipRequests(String space, String role, XWikiContext context) {
        return this.getMembershipRequests(space, role, 0, 0, context);
    }

    public List getMembershipRequests(String space, XWikiContext context) {
        return this.getMembershipRequests(space, 0, 0, context);
    }

    public List getMembershipRequests(XWikiContext context) {
        return this.getMembershipRequests(0, 0, context);
    }

    private void addToAlreadyMember(String user, XWikiContext context) {
        ArrayList<String> list = (ArrayList<String>)context.get((Object)"im_alreadymember");
        if (list == null) {
            list = new ArrayList<String>();
            context.put((Object)"im_alreadymember", list);
        }
        list.add(user);
    }

    private void addToAlreadyInvited(String user, XWikiContext context) {
        ArrayList<String> list = (ArrayList<String>)context.get((Object)"im_alreadyinvited");
        if (list == null) {
            list = new ArrayList<String>();
            context.put((Object)"im_alreadyinvited", list);
        }
        list.add(user);
    }

    public void inviteUser(String wikiNameOrMailAddress, String space, boolean open, List roles, String templateMail, Map map, XWikiContext context) throws InvitationManagerException {
        try {
            int status;
            String invitee;
            if (wikiNameOrMailAddress == null || wikiNameOrMailAddress.trim().length() == 0) {
                throw new InvitationManagerException(101, 101001, "Invitee missing");
            }
            String registeredUser = this.getRegisteredUser(wikiNameOrMailAddress = wikiNameOrMailAddress.trim(), context);
            if (registeredUser == null) {
                if (!this.isEmailAddress(wikiNameOrMailAddress)) {
                    throw new InvitationManagerException(101, 101002, "Invalid invitee e-mail address");
                }
                invitee = this.encodeEmailAddress(wikiNameOrMailAddress);
            } else {
                invitee = registeredUser;
                if (this.isMember(space, invitee, context)) {
                    this.addToAlreadyMember(invitee, context);
                    throw new InvitationManagerException(101, 101004, "Already member");
                }
            }
            Invitation invitation = this.createInvitation(invitee, space, context);
            if (!(invitation.isNew() || 1 != (status = invitation.getStatus()) && 2 != status)) {
                this.addToAlreadyInvited(invitee, context);
                throw new InvitationManagerException(101, 101003, "Already invited");
            }
            invitation.setInviter(context.getUser());
            invitation.setMap(map);
            invitation.setOpen(open);
            invitation.setRequestDate(new Date());
            invitation.setRoles(roles);
            invitation.setStatus(2);
            if (registeredUser == null) {
                invitation.setCode(this.generateInvitationCode());
                invitation.setInvitee(wikiNameOrMailAddress);
            } else {
                invitation.setInvitee(registeredUser);
            }
            if (templateMail == null) {
                templateMail = this.getDefaultTemplateMailDocumentName(space, "Invitation", "Send", context);
            }
            this.sendMail("Send", invitation, templateMail, context);
            invitation.saveWithProgrammingRights();
        }
        catch (InvitationManagerException e) {
            throw e;
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void inviteUser(String user, String space, boolean open, List roles, String templateMail, XWikiContext context) throws InvitationManagerException {
        this.inviteUser(user, space, open, roles, templateMail, Collections.EMPTY_MAP, context);
    }

    public void inviteUser(String user, String space, boolean open, List roles, XWikiContext context) throws InvitationManagerException {
        String templateMail = this.getDefaultTemplateMailDocumentName(space, "Invitation", "Send", context);
        this.inviteUser(user, space, open, roles, templateMail, context);
    }

    public void inviteUser(String user, String space, boolean open, String role, XWikiContext context) throws InvitationManagerException {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(role);
        this.inviteUser(user, space, open, roles, context);
    }

    public void inviteUser(String user, String space, boolean open, XWikiContext context) throws InvitationManagerException {
        this.inviteUser(user, space, open, Collections.EMPTY_LIST, context);
    }

    public void rejectInvitation(String space, String email, String code, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, email, context);
            if (code.equals(invitation.getCode()) && invitation.getStatus() == 2) {
                if (!invitation.isOpen()) {
                    invitation.setStatus(4);
                    invitation.setResponseDate(new Date());
                    invitation.setInvitee(context.getUser());
                    invitation.saveWithProgrammingRights();
                }
                this.customizeInvitation(invitation, 4, context);
            }
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void rejectInvitation(String space, XWikiContext context) throws InvitationManagerException {
        try {
            Invitation invitation = this.getInvitation(space, context.getUser(), context);
            if (invitation.getStatus() == 2) {
                invitation.setStatus(4);
                invitation.setResponseDate(new Date());
                invitation.saveWithProgrammingRights();
            }
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void rejectMembership(String space, String userName, String templateMail, XWikiContext context) throws InvitationManagerException {
        try {
            MembershipRequest request = this.getMembershipRequest(space, userName, context);
            if (request.getStatus() == 2) {
                request.setStatus(4);
                request.setResponseDate(new Date());
                request.setResponder(context.getUser());
                this.sendMail("Reject", request, templateMail, context);
                request.saveWithProgrammingRights();
            }
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void rejectMembership(String space, String userName, XWikiContext context) throws InvitationManagerException {
        String templateMail = this.getDefaultTemplateMailDocumentName(space, "Request", "Reject", context);
        this.rejectMembership(space, userName, templateMail, context);
    }

    public void requestMembership(String space, String message, List roles, Map map, XWikiContext context) throws InvitationManagerException {
        try {
            MembershipRequest request = this.createMembershipRequest(context.getUser(), space, context);
            request.setMap(map);
            request.setRequestDate(new Date());
            request.setRoles(roles);
            request.setStatus(2);
            request.setText(message);
            String requestSentMailTemplate = this.getDefaultTemplateMailDocumentName(space, "Request", "Create", context);
            this.sendMail("Create", request, requestSentMailTemplate, context);
            String requestPendingMailTemplate = this.getDefaultTemplateMailDocumentName(space, "Request", "Send", context);
            this.sendMail("Send", request, requestPendingMailTemplate, context);
            request.saveWithProgrammingRights();
        }
        catch (XWikiException e) {
            throw new InvitationManagerException(e);
        }
    }

    public void requestMembership(String space, String message, List roles, XWikiContext context) throws InvitationManagerException {
        this.requestMembership(space, message, roles, Collections.EMPTY_MAP, context);
    }

    public void requestMembership(String space, String message, String role, XWikiContext context) throws InvitationManagerException {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(role);
        this.requestMembership(space, message, roles, context);
    }

    public void requestMembership(String space, String message, XWikiContext context) throws InvitationManagerException {
        this.requestMembership(space, message, Collections.EMPTY_LIST, context);
    }

    private String getDefaultTemplateMailDocumentName(String space, String type, String action, XWikiContext context) {
        String docName = space + "." + "MailTemplate" + action + type;
        try {
            if (context.getWiki().getDocument(docName, context).isNew()) {
                docName = null;
            }
        }
        catch (XWikiException e) {
            docName = null;
        }
        if (docName == null) {
            docName = this.getDefaultResourceSpace(context) + "." + "MailTemplate" + action + type;
        }
        return docName;
    }

    private String getDefaultResourceSpace(XWikiContext context) {
        return context.getWiki().Param("xwiki.invitationmanager.resourcespace", "InvitationManagerResources");
    }

    private String getDefaultInvitationsSpaceSuffix(XWikiContext context) {
        return context.getWiki().Param("xwiki.invitationmanager.invitationspacesuffix", "_Invitations");
    }

    public String getJoinRequestDocumentName(String type, String space, String user, XWikiContext context) {
        if (space == null) {
            space = System.currentTimeMillis() + "";
        }
        if (user == null) {
            user = System.currentTimeMillis() + "";
        }
        user = this.clearUserName(user);
        return this.getInvitationSpaceName(space, context) + "." + type + "_" + user;
    }

    private String clearUserName(String user) {
        if (this.isEmailAddress(user)) {
            return user.replaceAll("\\.", "_").replaceAll("\\@", "_at_");
        }
        return user.replaceAll("XWiki\\.", "");
    }

    private String getInvitationSpaceName(String space, XWikiContext context) {
        return space + this.getDefaultInvitationsSpaceSuffix(context);
    }

    public String getInvitationClassName() {
        return INVITATION_CLASS_NAME;
    }

    public String getMembershipRequestClassName() {
        return MEMBERSHIP_REQUEST_CLASS_NAME;
    }

    private Invitation getInvitation(String space, String invitee, XWikiContext context) throws XWikiException {
        InvitationImpl invitation = null;
        if (space != null && invitee != null) {
            if (this.isEmailAddress(invitee)) {
                String realInvitee;
                String email = invitee.trim();
                String encodedEmail = this.encodeEmailAddress(email);
                String user = this.getRegisteredUser(invitee, context);
                invitation = new InvitationImpl(encodedEmail, space, false, this, context);
                if (invitation.isNew() && user != null) {
                    invitation = new InvitationImpl(user, space, false, this, context);
                }
                if (!email.equals(realInvitee = invitation.getInvitee()) && !user.equals(realInvitee)) {
                    invitation = null;
                }
            } else {
                String user = this.getRegisteredUser(invitee, context);
                if (user != null) {
                    String realInvitee;
                    String email = "";
                    String encodedEmail = this.encodeEmailAddress(email);
                    invitation = new InvitationImpl(user, space, false, this, context);
                    if (invitation.isNew()) {
                        invitation = new InvitationImpl(encodedEmail, space, false, this, context);
                    }
                    if (!email.equals(realInvitee = invitation.getInvitee()) && !user.equals(realInvitee)) {
                        invitation = null;
                    }
                }
            }
        }
        if (invitation == null) {
            invitation = new InvitationImpl(null, null, false, this, context);
        }
        return invitation;
    }

    private Invitation createInvitation(String invitee, String space, XWikiContext context) throws XWikiException {
        return new InvitationImpl(invitee, space, true, this, context);
    }

    private void customizeInvitation(Invitation invitation, int status, XWikiContext context) throws XWikiException {
        Invitation customInvitation = this.createInvitation(context.getUser(), invitation.getSpace(), context);
        customInvitation.setInviter(invitation.getInviter());
        customInvitation.setMap(invitation.getMap());
        customInvitation.setRequestDate(invitation.getRequestDate());
        customInvitation.setResponseDate(new Date());
        customInvitation.setRoles(invitation.getRoles());
        customInvitation.setStatus(status);
        customInvitation.setOpen(false);
        customInvitation.setText(invitation.getText());
        customInvitation.saveWithProgrammingRights();
    }

    private MembershipRequest getMembershipRequest(String space, String requester, XWikiContext context) throws XWikiException {
        return new MembershipRequestImpl(requester, space, false, this, context);
    }

    private MembershipRequest createMembershipRequest(String requester, String space, XWikiContext context) throws XWikiException {
        return new MembershipRequestImpl(requester, space, true, this, context);
    }

    private String encodeEmailAddress(String emailAddress) {
        return emailAddress.hashCode() + "";
    }

    private String generateInvitationCode() {
        return RandomStringUtils.randomAlphabetic((int)8).toLowerCase();
    }

    private void addMember(String space, String user, List roles, XWikiContext context) throws XWikiException {
        SpaceManager spaceManager = SpaceManagers.findSpaceManagerForSpace((String)space, (XWikiContext)context);
        if (!spaceManager.isMember(space, user, context)) {
            spaceManager.addMember(space, user, context);
            if (roles != null && roles.size() > 0) {
                spaceManager.addUserToRoles(space, user, roles, context);
            }
        }
    }

    private boolean isMember(String space, String user, XWikiContext context) {
        try {
            SpaceManager spaceManager = SpaceManagers.findSpaceManagerForSpace((String)space, (XWikiContext)context);
            return spaceManager.isMember(space, user, context);
        }
        catch (XWikiException e) {
            return false;
        }
    }

    private void sendMail(String action, JoinRequest request, String templateDocFullName, XWikiContext context) throws XWikiException {
        if (!this.mailNotification) {
            return;
        }
        VelocityContext vContext = new VelocityContext();
        String spaceName = request.getSpace();
        SpaceManager spaceManager = SpaceManagers.findSpaceManagerForSpace((String)spaceName, (XWikiContext)context);
        Space space = spaceManager.getSpace(spaceName, context);
        vContext.put(SPACE_VELOCITY_KEY, (Object)space);
        String fromUser = context.getWiki().getXWikiPreference("invitation_email", context);
        if (fromUser == null || fromUser.trim().length() == 0) {
            fromUser = context.getWiki().getXWikiPreference("admin_email", context);
        }
        String[] toUsers = new String[]{};
        if (request instanceof Invitation) {
            Invitation invitation = (Invitation)request;
            vContext.put(INVITATION_VELOCITY_KEY, (Object)invitation);
            toUsers = "Send".equals(action) ? new String[]{invitation.getInvitee()} : new String[]{invitation.getInviter()};
        } else if (request instanceof MembershipRequest) {
            MembershipRequest membershipRequest = (MembershipRequest)request;
            vContext.put(MEMBERSHIP_REQUEST_VELOCITY_KEY, (Object)membershipRequest);
            if ("Send".equals(action)) {
                Collection admins = spaceManager.getAdmins(spaceName, context);
                toUsers = admins.toArray(new String[admins.size()]);
            } else {
                toUsers = new String[]{membershipRequest.getRequester()};
            }
        }
        if (fromUser == null) {
            throw new InvitationManagerException(101, 101005, "Sender email is invalid");
        }
        boolean toUsersValid = toUsers.length > 0;
        for (int i = 0; i < toUsers.length && toUsersValid; ++i) {
            if (!this.isEmailAddress(toUsers[i])) {
                toUsers[i] = this.getEmailAddress(toUsers[i], context);
            }
            if (toUsers[i] != null) continue;
            toUsersValid = false;
        }
        if (!toUsersValid) {
            throw new InvitationManagerException(101, 101006, "Target email is invalid");
        }
        String strToUsers = InvitationManagerImpl.join(toUsers, ",");
        MailSenderPlugin mailSender = this.getMailSenderPlugin(context);
        XWikiDocument mailDoc = context.getWiki().getDocument(templateDocFullName, context);
        XWikiDocument translatedMailDoc = mailDoc.getTranslatedDocument(context);
        vContext.put("xwiki", (Object)new com.xpn.xwiki.api.XWiki(context.getWiki(), context));
        vContext.put("context", (Object)new Context(context));
        vContext.put("doc", (Object)translatedMailDoc);
        String mailSubject = XWikiVelocityRenderer.evaluate((String)translatedMailDoc.getTitle(), (String)templateDocFullName, (VelocityContext)vContext, (XWikiContext)context);
        String mailContent = XWikiVelocityRenderer.evaluate((String)translatedMailDoc.getContent(), (String)templateDocFullName, (VelocityContext)vContext, (XWikiContext)context);
        Mail mail = new Mail(fromUser, strToUsers, null, null, mailSubject, mailContent, null);
        try {
            mailSender.sendMail(mail, context);
        }
        catch (Exception e) {
            throw new InvitationManagerException(101, 101007, "Sending notification email failed", e);
        }
    }

    private static final String join(String[] array, String separator) {
        StringBuffer result = new StringBuffer("");
        if (array.length > 0) {
            result.append(array[0]);
        }
        for (int i = 1; i < array.length; ++i) {
            result.append("," + array[i]);
        }
        return result.toString();
    }

    private MailSenderPlugin getMailSenderPlugin(XWikiContext context) throws InvitationManagerException {
        MailSenderPlugin mailSender = (MailSenderPlugin)context.getWiki().getPlugin("mailsender", context);
        if (mailSender == null) {
            throw new InvitationManagerException(101, 101008, "Invitation Manager requires the mail sender plugin");
        }
        return mailSender;
    }

    private String getRegisteredUser(String wikiNameOrMailAddress, XWikiContext context) {
        if (!this.isEmailAddress(wikiNameOrMailAddress)) {
            return this.findUser(wikiNameOrMailAddress, context);
        }
        String email = wikiNameOrMailAddress;
        String sql = "select distinct doc.fullName from XWikiDocument as doc, BaseObject as obj, StringProperty as prop where doc.fullName=obj.name and obj.className = 'XWiki.XWikiUsers' and obj.id=prop.id.id and prop.id.name='email' and prop.value='" + email + "'";
        List userList = Collections.EMPTY_LIST;
        try {
            userList = context.getWiki().getStore().search(sql, 1, 0, context);
        }
        catch (XWikiException e) {
            // empty catch block
        }
        if (userList.size() > 0) {
            return (String)userList.get(0);
        }
        return null;
    }

    private boolean isEmailAddress(String str) {
        return str.contains("@");
    }

    private String getEmailAddress(String user, XWikiContext context) throws InvitationManagerException {
        try {
            String wikiuser;
            String string = wikiuser = user.startsWith("XWiki.") ? user : "XWiki." + user;
            if (wikiuser == null) {
                return null;
            }
            XWikiDocument userDoc = null;
            userDoc = context.getWiki().getDocument(wikiuser, context);
            if (userDoc.isNew()) {
                return null;
            }
            String email = "";
            try {
                email = userDoc.getObject("XWiki.XWikiUsers").getStringValue("email");
            }
            catch (Exception e) {
                return null;
            }
            if (email == null || email.equals("")) {
                return null;
            }
            return email;
        }
        catch (Exception e) {
            throw new InvitationManagerException(101, 101010, "Cannot find email address of user " + user, e);
        }
    }

    private String findUser(String userName, XWikiContext context) {
        if (!(userName = userName.trim()).startsWith("XWiki.")) {
            userName = "XWiki." + userName;
        }
        if (context.getWiki().exists(userName, context)) {
            return userName;
        }
        return null;
    }

    private void createSpaceUserProfile(String spaceName, MembershipRequest request, XWikiContext context) throws XWikiException {
        SpaceManager spaceManager = SpaceManagers.findSpaceManagerForSpace((String)spaceName, (XWikiContext)context);
        SpaceUserProfileImpl profile = new SpaceUserProfileImpl(request.getRequester(), spaceName, spaceManager, context);
        profile.setAllowNotifications("true".equals(request.getMap().get("allowNotifications")));
        profile.setAllowNotificationsFromSelf("true".equals(request.getMap().get("allowNotificationsFromSelf")));
        String profileText = (String)request.getMap().get("profile");
        if (profileText == null) {
            profileText = request.getText();
        }
        if (profileText == null) {
            profileText = "";
        }
        profile.setProfile(profileText);
        profile.saveWithProgrammingRights();
    }

    private void createSpaceUserProfile(String spaceName, XWikiContext context) throws XWikiException {
        SpaceManager spaceManager = SpaceManagers.findSpaceManagerForSpace((String)spaceName, (XWikiContext)context);
        SpaceUserProfileImpl profile = new SpaceUserProfileImpl(context.getUser(), spaceName, spaceManager, context);
        profile.updateProfileFromRequest();
        profile.saveWithProgrammingRights();
    }

    public boolean isWithUserProfiles(XWikiContext context) {
        return !context.getWiki().Param("xwiki.invitationmanager.userprofiles", USER_PROFILES_DEFAULT).equals("0");
    }

    public boolean isMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(boolean mailNotification) {
        this.mailNotification = mailNotification;
    }

    public static interface JoinRequestAction {
        public static final String CREATE = "Create";
        public static final String SEND = "Send";
        public static final String ACCEPT = "Accept";
        public static final String REJECT = "Reject";
    }
}

