/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.IndexFields;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class IndexData {
    private static final Log LOG = LogFactory.getLog(IndexData.class);
    private String documentTitle;
    private String documentName;
    private String documentWeb;
    private String documentFullName;
    private String fullName;
    private String author;
    private Date creationDate;
    private String creator;
    private String language;
    private Date modificationDate;
    private String wiki;

    public IndexData(XWikiDocument doc, XWikiContext context) {
        this.setDocumentName(doc.getName());
        this.setDocumentTitle(doc.getDisplayTitle(context));
        this.setDocumentWeb(doc.getSpace());
        this.setDocumentFullName(doc.getFullName());
        this.setWiki(doc.getDatabase() == null ? context.getDatabase() : doc.getDatabase());
        this.setFullName(new StringBuffer(this.wiki).append(":").append(this.documentWeb).append(".").append(this.documentName).toString());
        this.setLanguage(doc.getLanguage());
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        luceneDoc.add((Fieldable)new Field("_docid", this.getId(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        luceneDoc.add((Fieldable)new Field("lang", this.language, Field.Store.YES, Field.Index.TOKENIZED));
        if (this.wiki != null && this.wiki.length() > 0) {
            luceneDoc.add((Fieldable)new Field("wiki", this.wiki, Field.Store.YES, Field.Index.TOKENIZED));
        }
        if (this.getType() != null) {
            luceneDoc.add((Fieldable)new Field("type", this.getType(), Field.Store.YES, Field.Index.TOKENIZED));
        }
        if (this.modificationDate != null) {
            luceneDoc.add((Fieldable)new Field("date", IndexFields.dateToString(this.modificationDate), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (this.creationDate != null) {
            luceneDoc.add((Fieldable)new Field("creationdate", IndexFields.dateToString(this.creationDate), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (this.documentTitle != null) {
            luceneDoc.add((Fieldable)new Field("title", this.documentTitle, Field.Store.YES, Field.Index.TOKENIZED));
        }
        luceneDoc.add((Fieldable)new Field("name", this.documentName, Field.Store.YES, Field.Index.TOKENIZED));
        luceneDoc.add((Fieldable)new Field("web", this.documentWeb, Field.Store.YES, Field.Index.TOKENIZED));
        luceneDoc.add((Fieldable)new Field("fullname", this.documentFullName, Field.Store.YES, Field.Index.TOKENIZED));
        if (this.author != null) {
            luceneDoc.add((Fieldable)new Field("author", this.author, Field.Store.YES, Field.Index.TOKENIZED));
        }
        if (this.creator != null) {
            luceneDoc.add((Fieldable)new Field("creator", this.creator, Field.Store.YES, Field.Index.TOKENIZED));
        }
        try {
            String ft = this.getFullText(doc, context);
            if (ft != null) {
                luceneDoc.add((Fieldable)new Field("ft", ft, Field.Store.NO, Field.Index.TOKENIZED));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("error extracting fulltext for document " + this), (Throwable)e);
        }
    }

    public Query buildQuery() {
        return new TermQuery(new Term("_docid", this.getId()));
    }

    public String getId() {
        StringBuffer retval = new StringBuffer();
        if (this.wiki != null && this.wiki.length() > 0) {
            retval.append(this.wiki).append(":");
        }
        retval.append(this.documentWeb).append(".");
        retval.append(this.documentName).append(".");
        retval.append(this.language);
        return retval.toString();
    }

    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuffer sb = new StringBuffer(this.documentName).append(" ").append(this.documentWeb).append(" ").append(this.author).append(this.creator);
        return sb.toString();
    }

    public abstract String getType();

    public String toString() {
        return this.getId();
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public void setDocumentWeb(String documentWeb) {
        this.documentWeb = documentWeb;
    }

    public void setDocumentFullName(String documentFullName) {
        this.documentFullName = documentFullName;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getDocumentWeb() {
        return this.documentWeb;
    }

    public String getDocumentFullName() {
        return this.documentFullName;
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) {
        this.language = lang != null && lang.length() > 0 ? lang : "default";
    }
}

