/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.plugin.lucene.IndexData;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class DocumentData
extends IndexData {
    private static final Log LOG = LogFactory.getLog(DocumentData.class);

    public DocumentData(XWikiDocument doc, XWikiContext context) {
        super(doc, context);
        this.setAuthor(doc.getAuthor());
        this.setCreator(doc.getCreator());
        this.setModificationDate(doc.getDate());
        this.setCreationDate(doc.getCreationDate());
    }

    public String getType() {
        return "wikipage";
    }

    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        super.getFullText(sb, doc, context);
        sb.append(" ");
        sb.append(this.getDocumentTitle());
        sb.append(" ");
        sb.append(doc.getContent());
        sb.append(" ");
        this.getObjectFullText(sb, doc, context);
    }

    private void getObjectFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        super.getFullText(sb, doc, context);
        this.getObjectContentAsText(sb, doc, context);
    }

    private void getObjectContentAsText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        LOG.info((Object)doc.getFullName());
        for (String className : doc.getxWikiObjects().keySet()) {
            for (BaseObject obj : doc.getObjects(className)) {
                this.extractObjectContent(sb, obj, context);
            }
        }
    }

    private void getObjectContentAsText(StringBuilder contentText, BaseObject baseObject, String property, XWikiContext context) {
        PropertyInterface prop;
        BaseProperty baseProperty = (BaseProperty)baseObject.getField(property);
        if (baseProperty != null && baseProperty.getValue() != null && !((prop = baseObject.getxWikiClass(context).getField(property)) instanceof PasswordClass)) {
            contentText.append(baseProperty.getValue().toString());
        }
    }

    private void extractObjectContent(StringBuilder contentText, BaseObject baseObject, XWikiContext context) {
        if (baseObject != null) {
            String[] propertyNames;
            for (String propertyName : propertyNames = baseObject.getPropertyNames()) {
                this.getObjectContentAsText(contentText, baseObject, propertyName, context);
                contentText.append(" ");
            }
        }
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        super.addDataToLuceneDocument(luceneDoc, doc, context);
        for (String className : doc.getxWikiObjects().keySet()) {
            for (BaseObject obj : doc.getObjects(className)) {
                if (obj == null) continue;
                luceneDoc.add((Fieldable)new Field("object", obj.getClassName(), Field.Store.YES, Field.Index.ANALYZED));
                String[] propertyNames = obj.getPropertyNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    this.indexProperty(luceneDoc, obj, propertyNames[i], context);
                }
            }
        }
    }

    private void indexProperty(Document luceneDoc, BaseObject baseObject, String propertyName, XWikiContext context) {
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        BaseClass bClass = baseObject.getxWikiClass(context);
        PropertyInterface prop = bClass.getField(propertyName);
        if (!(prop instanceof PasswordClass)) {
            if (prop instanceof StaticListClass && ((StaticListClass)prop).isMultiSelect()) {
                this.indexStaticList(luceneDoc, baseObject, (StaticListClass)prop, propertyName, context);
            } else {
                StringBuilder sb = new StringBuilder();
                this.getObjectContentAsText(sb, baseObject, propertyName, context);
                luceneDoc.add((Fieldable)new Field(fieldFullName, sb.toString(), Field.Store.YES, Field.Index.ANALYZED));
            }
        }
    }

    private void indexStaticList(Document luceneDoc, BaseObject baseObject, StaticListClass prop, String propertyName, XWikiContext context) {
        Map possibleValues = prop.getMap(context);
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        for (String value : baseObject.getListValue(propertyName)) {
            ListItem item = (ListItem)possibleValues.get(value);
            if (item != null) {
                String fieldName = fieldFullName + ".key";
                luceneDoc.add((Fieldable)new Field(fieldName, item.getId(), Field.Store.YES, Field.Index.ANALYZED));
                fieldName = fieldFullName + ".value";
                luceneDoc.add((Fieldable)new Field(fieldName, item.getValue(), Field.Store.YES, Field.Index.ANALYZED));
                if (!item.getId().equals(item.getValue())) {
                    luceneDoc.add((Fieldable)new Field(fieldFullName, item.getValue(), Field.Store.YES, Field.Index.ANALYZED));
                }
            }
            luceneDoc.add((Fieldable)new Field(fieldFullName, value, Field.Store.YES, Field.Index.ANALYZED));
        }
    }
}

