/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.plugin.lucene.textextraction.MSExcelTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MSPowerPointTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MSWordTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.MimetypeTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.PDFTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.PlainTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.XmlTextExtractor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextExtractor {
    private static final Log LOG = LogFactory.getLog(TextExtractor.class);
    private static final Map<String, MimetypeTextExtractor> TEXTEXTRACTORS = new HashMap<String, MimetypeTextExtractor>();

    public static String getText(byte[] content, String mimetype) {
        MimetypeTextExtractor extractor = TEXTEXTRACTORS.get(mimetype);
        if (extractor != null) {
            try {
                return extractor.getText(content);
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting text for mimetype [" + mimetype + "]"), (Throwable)e);
            }
        } else {
            LOG.info((Object)("No text extractor for mimetype [" + mimetype + "]"));
        }
        return null;
    }

    static {
        XmlTextExtractor xmlTextExtractor = new XmlTextExtractor();
        TEXTEXTRACTORS.put("application/xhtml+xml", xmlTextExtractor);
        TEXTEXTRACTORS.put("text/xml", xmlTextExtractor);
        TEXTEXTRACTORS.put("text/plain", new PlainTextExtractor());
        TEXTEXTRACTORS.put("application/pdf", new PDFTextExtractor());
        TEXTEXTRACTORS.put("application/msword", new MSWordTextExtractor());
        TEXTEXTRACTORS.put("application/ms-word", new MSWordTextExtractor());
        TEXTEXTRACTORS.put("application/vnd.msword", new MSWordTextExtractor());
        TEXTEXTRACTORS.put("application/vnd.ms-word", new MSWordTextExtractor());
        TEXTEXTRACTORS.put("application/vnd.ms-powerpoint", new MSPowerPointTextExtractor());
        TEXTEXTRACTORS.put("application/ms-powerpoint", new MSPowerPointTextExtractor());
        TEXTEXTRACTORS.put("application/ms-excel", new MSExcelTextExtractor());
        TEXTEXTRACTORS.put("application/vnd.ms-excel", new MSExcelTextExtractor());
    }
}

