/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.textextraction;

import com.xpn.xwiki.plugin.lucene.textextraction.MimetypeTextExtractor;
import com.xpn.xwiki.plugin.lucene.textextraction.xmlutil.XmlEncodingDetector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlpull.mxp1.MXParser;

public class OpenOfficeTextExtractor
implements MimetypeTextExtractor {
    private static final String TEXTNAMESPACE = "http://openoffice.org/2000/text";

    public String getText(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = null;
        String zipEntryName = null;
        StringBuffer text = new StringBuffer();
        while ((ze = zis.getNextEntry()) != null && !(zipEntryName = ze.getName()).equals("content.xml")) {
        }
        if (zipEntryName != null && zipEntryName.equals("content.xml")) {
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((InputStream)zis, XmlEncodingDetector.detectEncoding(data));
            boolean inText = false;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                eventType = parser.next();
                if (eventType == 2) {
                    if (!parser.getName().equals("p") || !parser.getNamespace().equals(TEXTNAMESPACE)) continue;
                    text.append(' ');
                    inText = true;
                    continue;
                }
                if (eventType == 3) {
                    if (!parser.getName().equals("p") || !parser.getNamespace().equals(TEXTNAMESPACE)) continue;
                    inText = false;
                    continue;
                }
                if (eventType != 4 || !inText) continue;
                String gotText = parser.getText();
                text.append(gotText);
            }
        } else {
            throw new Exception("Invalid OpenOffice document format (content.xml not found)");
        }
        return text.toString();
    }
}

