/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.IndexData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;

public class AttachmentData
extends IndexData {
    private static final Log LOG = LogFactory.getLog(AttachmentData.class);
    private int size;
    private String filename;

    public AttachmentData(XWikiDocument document, XWikiAttachment attachment, XWikiContext context) {
        super(attachment.getDoc(), context);
        this.setModificationDate(attachment.getDate());
        this.setAuthor(attachment.getAuthor());
        this.setSize(attachment.getFilesize());
        this.setFilename(attachment.getFilename());
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        super.addDataToLuceneDocument(luceneDoc, doc, context);
        if (this.filename != null) {
            luceneDoc.add((Fieldable)new Field("filename", this.filename, Field.Store.YES, Field.Index.ANALYZED));
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return "attachment";
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getId() {
        return new StringBuffer(super.getId()).append(".file.").append(this.filename).toString();
    }

    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        super.getFullText(sb, doc, context);
        String contentText = this.getContentAsText(doc, context);
        if (contentText != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getContentAsText(doc, context));
        }
    }

    private String getContentAsText(XWikiDocument doc, XWikiContext context) {
        String contentText = null;
        try {
            XWikiAttachment att = doc.getAttachment(this.filename);
            LOG.debug((Object)("Start parsing attachement [" + this.filename + "] in document [" + doc.getPrefixedFullName() + "]"));
            Tika tika = new Tika();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", this.filename);
            contentText = this.filename + " " + tika.parseToString(att.getContentInputStream(context), metadata);
        }
        catch (Throwable e) {
            LOG.warn((Object)("error getting content of attachment [" + this.filename + "] for document [" + doc.getPrefixedFullName() + "]"), e);
        }
        return contentText;
    }
}

