/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.IndexUpdater;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.xwiki.context.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexRebuilder
extends AbstractXWikiRunnable {
    private static final Log LOG = LogFactory.getLog(IndexRebuilder.class);
    private static final int RETRYINTERVAL = 30000;
    private final IndexUpdater indexUpdater;
    private volatile boolean rebuildInProgress = false;
    private Collection<String> wikis = null;
    private String hqlFilter = null;
    private boolean onlyNew = false;

    public IndexRebuilder(IndexUpdater indexUpdater, XWikiContext context) {
        super("xwikicontext", context.clone());
        this.indexUpdater = indexUpdater;
    }

    private XWikiContext getContext() {
        return (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
    }

    public int startRebuildIndex(XWikiContext context) {
        return this.startIndex(null, "", true, false, context);
    }

    public synchronized int startIndex(Collection<String> wikis, String hqlFilter, boolean clearIndex, boolean onlyNew, XWikiContext context) {
        if (this.rebuildInProgress) {
            LOG.warn((Object)"Cannot launch rebuild because a build is in progress");
            return -2;
        }
        if (clearIndex && wikis == null) {
            this.indexUpdater.cleanIndex();
        }
        this.wikis = wikis != null ? new ArrayList<String>(wikis) : null;
        this.hqlFilter = hqlFilter;
        this.onlyNew = onlyNew;
        this.rebuildInProgress = true;
        Thread indexRebuilderThread = new Thread((Runnable)((Object)this), "Lucene Index Rebuilder");
        indexRebuilderThread.setDaemon(true);
        indexRebuilderThread.setPriority(3);
        indexRebuilderThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        MDC.put((String)"url", (Object)"Lucene index rebuilder thread");
        LOG.debug((Object)"Starting lucene index rebuild");
        XWikiContext context = null;
        try {
            context = this.getContext();
            context.remove((Object)"hibsession");
            context.remove((Object)"hibtransaction");
            context.remove((Object)"vcontext");
            context.setRequest(null);
            context.setResponse(null);
            this.rebuildIndex(context);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in lucene rebuild thread", (Throwable)e);
        }
        finally {
            this.rebuildInProgress = false;
            if (context != null) {
                context.getWiki().getStore().cleanUp(context);
            }
            MDC.remove((String)"url");
        }
        LOG.debug((Object)"Lucene index rebuild done");
    }

    private int rebuildIndex(XWikiContext context) {
        int retval = 0;
        Collection<String> wikiServers = this.wikis;
        if (wikiServers == null) {
            XWiki xwiki = context.getWiki();
            if (xwiki.isVirtualMode()) {
                wikiServers = this.findWikiServers(context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found " + wikiServers.size() + " virtual wikis:"));
                    for (String wikiName : wikiServers) {
                        LOG.debug((Object)wikiName);
                    }
                }
            } else {
                wikiServers = new ArrayList<String>();
                wikiServers.add(context.getDatabase());
            }
        }
        for (String wikiName : wikiServers) {
            int wikiResult = this.indexWiki(wikiName, context);
            if (wikiResult <= 0) continue;
            retval += wikiResult;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int indexWiki(String wikiName, XWikiContext context) {
        LOG.info((Object)("Reading content of wiki " + wikiName));
        int retval = 0;
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            Searcher searcher = this.onlyNew ? this.createSearcher(this.indexUpdater.getDirectory(), context) : null;
            List documentNames = context.getWiki().getStore().searchDocumentsNames(this.hqlFilter != null ? this.hqlFilter : "", context);
            retval = this.indexDocuments(wikiName, documentNames, searcher, context);
            if (searcher == null) return retval;
            try {
                searcher.close();
                return retval;
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to close searcher", (Throwable)e);
            }
            return retval;
            catch (XWikiException e) {
                int n;
                block15: {
                    try {
                        LOG.warn((Object)MessageFormat.format("Error getting document names for wiki [{0}] and filter [{1}].", wikiName, this.hqlFilter), (Throwable)e);
                        n = -1;
                        if (searcher == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (searcher == null) throw throwable;
                        try {
                            searcher.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            LOG.error((Object)"Failed to close searcher", (Throwable)e2);
                        }
                        throw throwable;
                    }
                    try {
                        searcher.close();
                    }
                    catch (IOException e3) {
                        LOG.error((Object)"Failed to close searcher", (Throwable)e3);
                    }
                }
                context.setDatabase(database);
                return n;
            }
        }
        finally {
            context.setDatabase(database);
        }
    }

    private int indexDocuments(String wikiName, List<String> documentNames, Searcher searcher, XWikiContext context) {
        int retval = 0;
        for (String documentName : documentNames) {
            if (searcher != null && this.isIndexed(wikiName, documentName, searcher)) continue;
            retval += this.indexDocument(wikiName, documentName, context);
        }
        return retval;
    }

    private int indexDocument(String wikiName, String documentName, XWikiContext context) {
        XWikiDocument document;
        int retval = 0;
        try {
            document = context.getWiki().getDocument(documentName, context);
        }
        catch (XWikiException e) {
            LOG.error((Object)("error fetching document " + wikiName + ":" + documentName), (Throwable)e);
            return retval;
        }
        if (document != null) {
            while (this.indexUpdater.getQueueSize() > (long)this.indexUpdater.getMaxQueueSize()) {
                try {
                    context.getWiki().getStore().cleanUp(context);
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return -2;
                }
            }
            this.indexUpdater.add(document, context);
            ++retval;
            retval += this.addTranslationsOfDocument(document, context);
            retval += this.indexUpdater.addAttachmentsOfDocument(document, context);
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)("XWiki delivered null for document name " + wikiName + ":" + documentName));
        }
        return retval;
    }

    protected int addTranslationsOfDocument(XWikiDocument document, XWikiContext wikiContext) {
        List translations;
        int retval = 0;
        try {
            translations = document.getTranslationList(wikiContext);
        }
        catch (XWikiException e) {
            LOG.error((Object)("error getting list of translations from document " + document), (Throwable)e);
            return 0;
        }
        for (String lang : translations) {
            try {
                this.indexUpdater.add(document.getTranslatedDocument(lang, wikiContext), wikiContext);
                ++retval;
            }
            catch (XWikiException e) {
                LOG.error((Object)("Error getting translated document for document " + document + " and language " + lang), (Throwable)e);
            }
        }
        return retval;
    }

    private Collection<String> findWikiServers(XWikiContext context) {
        List retval = Collections.emptyList();
        try {
            retval = context.getWiki().getVirtualWikisDatabaseNames(context);
            if (!retval.contains(context.getMainXWiki())) {
                retval.add(context.getMainXWiki());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting list of wiki servers!", (Throwable)e);
        }
        return retval;
    }

    public boolean isIndexed(String wikiName, String documentName, Searcher searcher) {
        boolean exists = false;
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("fullname", documentName.toLowerCase())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("wiki", wikiName.toLowerCase())), BooleanClause.Occur.MUST);
        try {
            TopDocs topDocs = searcher.search((Query)query, 1);
            exists = topDocs.totalHits > 1;
        }
        catch (IOException e) {
            LOG.error((Object)("Faild to search for page [" + wikiName + ":" + documentName + "] in Lucene index"), (Throwable)e);
        }
        return exists;
    }

    public Searcher createSearcher(Directory directory, XWikiContext context) {
        IndexSearcher searcher = null;
        try {
            searcher = new IndexSearcher(directory, true);
        }
        catch (Exception e) {
            LOG.error((Object)("Faild to create IndexSearcher for Lucen index [" + directory + "]"), (Throwable)e);
        }
        return searcher;
    }
}

