/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.AbstractXWikiRunnable;
import com.xpn.xwiki.plugin.lucene.AttachmentData;
import com.xpn.xwiki.plugin.lucene.DocumentData;
import com.xpn.xwiki.plugin.lucene.IndexData;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.ObjectData;
import com.xpn.xwiki.plugin.lucene.XWikiDocumentQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ActionExecutionEvent;
import org.xwiki.observation.event.DocumentDeleteEvent;
import org.xwiki.observation.event.DocumentSaveEvent;
import org.xwiki.observation.event.DocumentUpdateEvent;
import org.xwiki.observation.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexUpdater
extends AbstractXWikiRunnable
implements EventListener {
    private static final Log LOG = LogFactory.getLog(IndexUpdater.class);
    private static final String NAME = "lucene";
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentUpdateEvent());
            this.add(new DocumentSaveEvent());
            this.add(new DocumentDeleteEvent());
            this.add(new ActionExecutionEvent("upload"));
        }
    };
    private int indexingInterval = 30000;
    private boolean exit = false;
    private IndexWriter writer;
    private String indexDir;
    private XWikiDocumentQueue queue = new XWikiDocumentQueue();
    public int maxQueueSize = 1000;
    private Analyzer analyzer;
    private LucenePlugin plugin;
    private IndexSearcher searcher;
    private IndexReader reader;
    private XWikiContext context;
    private XWiki xwiki;
    private long activesIndexedDocs = 0L;
    static List<String> fields = new ArrayList<String>();
    public boolean needInitialBuild = false;

    public void doExit() {
        this.exit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)"url", (Object)"Lucene index updating thread");
        try {
            this.initXWikiContainer(this.context);
            this.runMainLoop();
        }
        finally {
            this.cleanupXWikiContainer(this.context);
            this.xwiki.getStore().cleanUp(this.context);
            MDC.remove((String)"url");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMainLoop() {
        while (!this.exit) {
            if (this.queue.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IndexUpdater: queue empty, nothing to do");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IndexUpdater: documents in queue, start indexing");
                }
                HashMap<String, IndexData> toIndex = new HashMap<String, IndexData>();
                ArrayList<Integer> toDelete = new ArrayList<Integer>();
                this.activesIndexedDocs = 0L;
                try {
                    this.openSearcher();
                    while (!this.queue.isEmpty()) {
                        IndexData data = this.queue.remove();
                        List<Integer> oldDocs = this.getOldIndexDocIds(data);
                        if (oldDocs != null) {
                            for (Integer n : oldDocs) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Adding " + n + " to remove list"));
                                }
                                if (!toDelete.contains(n)) {
                                    toDelete.add(n);
                                    continue;
                                }
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("Found " + n + " already in list while adding it to remove list"));
                            }
                        }
                        String id = data.getId();
                        LOG.debug((Object)("Adding " + id + " to index list"));
                        if (toIndex.containsKey(id)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Found " + id + " already in list while adding it to index list"));
                            }
                            toIndex.remove(id);
                        }
                        ++this.activesIndexedDocs;
                        toIndex.put(id, data);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"error preparing index queue", (Throwable)e);
                }
                finally {
                    this.closeSearcher();
                }
                try {
                    this.openSearcher();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("deleting " + toDelete.size() + " docs from lucene index"));
                    }
                    int nb = this.deleteOldDocs(toDelete);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("deleted " + nb + " docs from lucene index"));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"error deleting previous documents", (Throwable)e);
                }
                finally {
                    this.closeSearcher();
                }
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("indexing " + toIndex.size() + " docs to lucene index"));
                    }
                    XWikiContext context = (XWikiContext)this.context.clone();
                    context.getWiki().getStore().cleanUp(context);
                    this.openWriter(false);
                    int nb = 0;
                    for (Map.Entry entry : toIndex.entrySet()) {
                        String id = (String)entry.getKey();
                        IndexData data = (IndexData)entry.getValue();
                        try {
                            XWikiDocument doc = this.xwiki.getDocument(data.getFullName(), context);
                            if (data.getLanguage() != null && !data.getLanguage().equals("")) {
                                doc = doc.getTranslatedDocument(data.getLanguage(), context);
                            }
                            this.addToIndex(data, doc, context);
                            ++nb;
                            --this.activesIndexedDocs;
                        }
                        catch (Exception e) {
                            LOG.error((Object)("error indexing document " + id), (Throwable)e);
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("indexed " + nb + " docs to lucene index"));
                    }
                    this.writer.flush();
                }
                catch (Exception e) {
                    LOG.error((Object)"error indexing documents", (Throwable)e);
                }
                finally {
                    this.context.getWiki().getStore().cleanUp(this.context);
                    this.closeWriter();
                }
                this.plugin.openSearchers();
            }
            try {
                Thread.sleep(this.indexingInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSearcher() {
        try {
            if (this.searcher != null) {
                this.searcher.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"error closing index searcher", (Throwable)e);
        }
        finally {
            this.searcher = null;
            this.reader = null;
        }
    }

    private synchronized void openSearcher() {
        try {
            this.reader = IndexReader.open((String)this.indexDir);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (IOException e) {
            LOG.error((Object)"error opening index searcher", (Throwable)e);
        }
    }

    private int deleteOldDocs(List<Integer> oldDocs) {
        int nb = 0;
        for (Integer id : oldDocs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("delete doc " + id));
            }
            try {
                this.reader.deleteDocument(id.intValue());
                ++nb;
            }
            catch (IOException e1) {
                LOG.error((Object)("error deleting doc " + id), (Throwable)e1);
            }
        }
        return nb;
    }

    private List<Integer> getOldIndexDocIds(IndexData data) {
        ArrayList<Integer> retval = new ArrayList<Integer>(3);
        Query query = data.buildQuery();
        try {
            Hits hits = this.searcher.search(query);
            for (int i = 0; i < hits.length(); ++i) {
                retval.add(new Integer(hits.id(i)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error looking for old versions of document [%s] with query [%s]", data, query), (Throwable)e);
        }
        return retval;
    }

    private void openWriter(boolean create) {
        if (this.writer != null) {
            LOG.error((Object)"Writer already open and createWriter called");
            return;
        }
        try {
            FSDirectory f = FSDirectory.getDirectory((String)this.indexDir);
            this.writer = new IndexWriter((Directory)f, this.analyzer, create);
            this.writer.setUseCompoundFile(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("successfully opened index writer : " + this.indexDir));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException when opening Lucene Index for writing at " + this.indexDir), (Throwable)e);
        }
    }

    private void closeWriter() {
        if (this.writer == null) {
            LOG.error((Object)"Writer not open and closeWriter called");
            return;
        }
        try {
            this.writer.optimize();
        }
        catch (IOException e1) {
            LOG.error((Object)"Exception caught when optimizing Index", (Throwable)e1);
        }
        try {
            this.writer.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught when closing IndexWriter", (Throwable)e);
        }
        this.writer = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"closed writer.");
        }
    }

    private void addToIndex(IndexData data, XWikiDocument doc, XWikiContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addToIndex: " + data));
        }
        Document luceneDoc = new Document();
        data.addDataToLuceneDocument(luceneDoc, doc, context);
        Field fld2 = null;
        for (Field fld2 : luceneDoc.getFields()) {
            if (fields.contains(fld2.name())) continue;
            fields.add(fld2.name());
        }
        this.writer.addDocument(luceneDoc);
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public synchronized void init(Properties config, LucenePlugin plugin, XWikiContext context) {
        this.xwiki = context.getWiki();
        this.context = (XWikiContext)context.clone();
        this.context.setDatabase(this.context.getMainXWiki());
        this.plugin = plugin;
        String[] indexDirs = StringUtils.split((String)plugin.getIndexDirs(), (String)",");
        if (indexDirs != null && indexDirs.length > 0) {
            this.indexDir = indexDirs[0];
            File f = new File(this.indexDir);
            if (!f.isDirectory()) {
                f.mkdirs();
                this.needInitialBuild = true;
            }
            if (!IndexReader.indexExists((File)f)) {
                this.needInitialBuild = true;
            }
        }
        this.indexingInterval = 1000 * Integer.parseInt(config.getProperty("xwiki.plugins.lucene.indexinterval", "30"));
        this.maxQueueSize = Integer.parseInt(config.getProperty("xwiki.plugins.lucene.maxQueueSize", "1000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanIndex() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"trying to clear index for rebuilding");
        }
        while (this.writer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"waiting for existing index writer to close");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IndexUpdater indexUpdater = this;
        synchronized (indexUpdater) {
            this.openWriter(true);
            this.closeWriter();
        }
    }

    public void add(XWikiDocument document, XWikiContext context) {
        this.queue.add(new DocumentData(document, context));
        if (document.hasElement(2)) {
            this.addObject(document, context);
        }
    }

    public void addObject(XWikiDocument document, XWikiContext context) {
        this.queue.add(new ObjectData(document, context));
    }

    public void add(XWikiDocument document, XWikiAttachment attachment, XWikiContext context) {
        if (document != null && attachment != null && context != null) {
            this.queue.add(new AttachmentData(document, attachment, context));
        } else {
            LOG.error((Object)("invalid parameters given to add: " + document + ", " + attachment + ", " + context));
        }
    }

    public int addAttachmentsOfDocument(XWikiDocument document, XWikiContext context) {
        int retval = 0;
        List attachmentList = document.getAttachmentList();
        retval += attachmentList.size();
        for (XWikiAttachment attachment : attachmentList) {
            try {
                this.add(document, attachment, context);
            }
            catch (Exception e) {
                LOG.error((Object)("error retrieving attachment of document " + document.getFullName()), (Throwable)e);
            }
        }
        return retval;
    }

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiContext context = (XWikiContext)data;
        try {
            if (event instanceof ActionExecutionEvent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("upload action notification for doc " + document.getName()));
                }
                XWikiDocument basedoc = context.getWiki().getDocument(document.getFullName(), context);
                List attachments = basedoc.getAttachmentList();
                XWikiAttachment newestAttachment = null;
                for (XWikiAttachment attachment : attachments) {
                    if (newestAttachment != null && !attachment.getDate().after(newestAttachment.getDate())) continue;
                    newestAttachment = attachment;
                }
                this.add(basedoc, newestAttachment, context);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("notify from XWikiDocChangeNotificationInterface, event=" + event + ", doc=" + document));
                }
                this.add(document, context);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error in notify", (Throwable)e);
        }
    }

    public long getQueueSize() {
        return this.queue.getSize();
    }

    public long getLuceneDocCount() {
        if (this.writer != null) {
            return this.writer.docCount();
        }
        return -1L;
    }

    public long getActiveQueueSize() {
        return this.activesIndexedDocs;
    }
}

