/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.plugin.lucene.IndexData;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ObjectData
extends IndexData {
    private static final Log LOG = LogFactory.getLog(ObjectData.class);

    public ObjectData(XWikiDocument doc, XWikiContext context) {
        super(doc, context);
        this.setAuthor(doc.getAuthor());
        this.setCreator(doc.getCreator());
        this.setModificationDate(doc.getDate());
        this.setCreationDate(doc.getCreationDate());
    }

    public String getType() {
        return "objects";
    }

    public String getId() {
        return new StringBuffer(super.getId()).append(".objects").toString();
    }

    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuffer retval = new StringBuffer(super.getFullText(doc, context));
        String contentText = this.getContentAsText(doc, context);
        if (contentText != null) {
            retval.append(" ").append(contentText).toString();
        }
        return retval.toString();
    }

    private String getContentAsText(XWikiDocument doc, XWikiContext context) {
        StringBuffer contentText = new StringBuffer();
        try {
            LOG.info((Object)doc.getFullName());
            for (String className : doc.getxWikiObjects().keySet()) {
                for (BaseObject obj : doc.getObjects(className)) {
                    this.extractContent(contentText, obj, context);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error getting content from  XWiki Objects ", (Throwable)e);
            e.printStackTrace();
        }
        return contentText.toString();
    }

    private void extractContent(StringBuffer contentText, BaseObject baseObject, XWikiContext context) {
        try {
            if (baseObject != null) {
                String[] propertyNames;
                for (String propertyName : propertyNames = baseObject.getPropertyNames()) {
                    PropertyInterface prop;
                    BaseProperty baseProperty = (BaseProperty)baseObject.getField(propertyName);
                    if (baseProperty != null && baseProperty.getValue() != null && !((prop = baseObject.getxWikiClass(context).getField(propertyName)) instanceof PasswordClass)) {
                        contentText.append(baseProperty.getValue().toString());
                    }
                    contentText.append(" ");
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error getting content from  XWiki Object ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        super.addDataToLuceneDocument(luceneDoc, doc, context);
        for (String className : doc.getxWikiObjects().keySet()) {
            for (BaseObject obj : doc.getObjects(className)) {
                if (obj == null) continue;
                luceneDoc.add((Fieldable)new Field("object", obj.getClassName(), Field.Store.YES, Field.Index.TOKENIZED));
                String[] propertyNames = obj.getPropertyNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    try {
                        this.indexProperty(luceneDoc, obj, propertyNames[i], context);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("error extracting fulltext for document " + this), (Throwable)e);
                    }
                }
            }
        }
    }

    private void indexProperty(Document luceneDoc, BaseObject baseObject, String propertyName, XWikiContext context) {
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        BaseClass bClass = baseObject.getxWikiClass(context);
        PropertyInterface prop = bClass.getField(propertyName);
        if (!(prop instanceof PasswordClass)) {
            if (prop instanceof StaticListClass && ((StaticListClass)prop).isMultiSelect()) {
                this.indexStaticList(luceneDoc, baseObject, (StaticListClass)prop, propertyName, context);
            } else {
                String ft = this.getContentAsText(baseObject, propertyName, context);
                if (ft != null) {
                    luceneDoc.add((Fieldable)new Field(fieldFullName, ft, Field.Store.YES, Field.Index.TOKENIZED));
                }
            }
        }
    }

    private void indexStaticList(Document luceneDoc, BaseObject baseObject, StaticListClass prop, String propertyName, XWikiContext context) {
        Map possibleValues = prop.getMap(context);
        List keys = baseObject.getListValue(propertyName);
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        for (String value : keys) {
            ListItem item = (ListItem)possibleValues.get(value);
            if (item != null) {
                String fieldName = fieldFullName + ".key";
                luceneDoc.add((Fieldable)new Field(fieldName, item.getId(), Field.Store.YES, Field.Index.TOKENIZED));
                fieldName = fieldFullName + ".value";
                luceneDoc.add((Fieldable)new Field(fieldName, item.getValue(), Field.Store.YES, Field.Index.TOKENIZED));
                if (!item.getId().equals(item.getValue())) {
                    luceneDoc.add((Fieldable)new Field(fieldFullName, item.getValue(), Field.Store.YES, Field.Index.TOKENIZED));
                }
            }
            luceneDoc.add((Fieldable)new Field(fieldFullName, value, Field.Store.YES, Field.Index.TOKENIZED));
        }
    }

    public String getFullText(XWikiDocument doc, BaseObject baseObject, String property, XWikiContext context) {
        return this.getContentAsText(baseObject, property, context);
    }

    private String getContentAsText(BaseObject baseObject, String property, XWikiContext context) {
        StringBuffer contentText = new StringBuffer();
        try {
            PropertyInterface prop;
            BaseProperty baseProperty = (BaseProperty)baseObject.getField(property);
            if (baseProperty.getValue() != null && !((prop = baseObject.getxWikiClass(context).getField(property)) instanceof PasswordClass)) {
                contentText.append(baseProperty.getValue().toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error getting content from  XWiki Objects ", (Throwable)e);
            e.printStackTrace();
        }
        return contentText.toString();
    }
}

