/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.textextraction;

import com.xpn.xwiki.plugin.lucene.textextraction.MimetypeTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MSExcelTextExtractor
implements MimetypeTextExtractor {
    private static final Log LOG = LogFactory.getLog(MSExcelTextExtractor.class);
    private HSSFWorkbook mWorkbook;
    private HSSFDataFormat mDataFormat;
    public static final int DEFAULT_BUFFER_SIZE = 16384;

    public String getText(byte[] data) throws Exception {
        POIFSFileSystem poiFs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(data));
        this.mWorkbook = new HSSFWorkbook(poiFs);
        this.mDataFormat = this.mWorkbook.createDataFormat();
        StringBuffer cleanBuffer = new StringBuffer(16384);
        for (int sheetIdx = 0; sheetIdx < this.mWorkbook.getNumberOfSheets(); ++sheetIdx) {
            HSSFSheet sheet = this.mWorkbook.getSheetAt(sheetIdx);
            if (sheet == null) continue;
            this.parseSheet(sheet, cleanBuffer);
        }
        return cleanBuffer.toString();
    }

    private void parseSheet(HSSFSheet sheet, StringBuffer cleanBuffer) {
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        for (int rowIdx = firstRow; rowIdx <= lastRow; ++rowIdx) {
            HSSFRow row = sheet.getRow(rowIdx);
            if (row == null) continue;
            this.parseRow(row, cleanBuffer);
        }
    }

    private void parseRow(HSSFRow row, StringBuffer cleanBuffer) {
        short firstCell = row.getFirstCellNum();
        short lastCell = row.getLastCellNum();
        for (short cellIdx = firstCell; cellIdx <= lastCell; cellIdx = (short)(cellIdx + 1)) {
            HSSFCell cell = row.getCell(cellIdx);
            if (cell == null) continue;
            this.parseCell(cell, cleanBuffer);
        }
    }

    private void parseCell(HSSFCell cell, StringBuffer cleanBuffer) {
        String cellValue = null;
        if (cell.getCellType() == 1) {
            cellValue = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 0) {
            HSSFCellStyle style = cell.getCellStyle();
            short formatId = style.getDataFormat();
            String formatPattern = this.mDataFormat.getFormat(formatId);
            formatPattern = MSExcelTextExtractor.replace(formatPattern, "\\ ", " ");
            if (this.isCellDateFormatted(cell)) {
                SimpleDateFormat format;
                formatPattern = MSExcelTextExtractor.replace(formatPattern, "mmmm", "MMMM");
                formatPattern = MSExcelTextExtractor.replace(formatPattern, "/", ".");
                try {
                    format = new SimpleDateFormat(formatPattern);
                }
                catch (Throwable thr) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Creating date format failed: '" + formatPattern + "'"), thr);
                    }
                    format = new SimpleDateFormat();
                }
                double numberValue = cell.getNumericCellValue();
                Date date = HSSFDateUtil.getJavaDate((double)numberValue);
                cellValue = format.format(date);
            } else {
                DecimalFormat format;
                try {
                    format = new DecimalFormat(formatPattern);
                }
                catch (Throwable thr) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Creating number format failed: '" + formatPattern + "'"), thr);
                    }
                    format = new DecimalFormat();
                }
                double numberValue = cell.getNumericCellValue();
                cellValue = format.format(numberValue);
            }
        }
        if (cellValue != null && (cellValue = cellValue.trim()).length() != 0) {
            cleanBuffer.append(cellValue);
            cleanBuffer.append(" ");
        }
    }

    private boolean isCellDateFormatted(HSSFCell cell) {
        short format = cell.getCellStyle().getDataFormat();
        if (HSSFDateUtil.isValidExcelDate((double)cell.getNumericCellValue())) {
            if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                return true;
            }
            String fmtText = this.mDataFormat.getFormat(format);
            if (fmtText != null && ((fmtText = fmtText.toLowerCase()).indexOf("d") >= 0 || fmtText.indexOf("m") >= 0 || fmtText.indexOf("y") >= 0 || fmtText.indexOf("h") >= 0 || fmtText.indexOf("s") >= 0)) {
                return true;
            }
        }
        return false;
    }

    public static String replace(String source, String pattern, String replacement) {
        int firstPatternPos = source.indexOf(pattern);
        if (firstPatternPos == -1) {
            return source;
        }
        StringBuffer target = new StringBuffer(source.length());
        int start = 0;
        int end = firstPatternPos;
        do {
            target.append(source.substring(start, end));
            target.append(replacement);
        } while ((end = source.indexOf(pattern, start = end + pattern.length())) != -1);
        target.append(source.substring(start, source.length()));
        return target.toString();
    }
}

