/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public class SchedulerPluginApi
extends Api {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$xpn$xwiki$plugin$scheduler$SchedulerPluginApi == null ? (class$com$xpn$xwiki$plugin$scheduler$SchedulerPluginApi = SchedulerPluginApi.class$("com.xpn.xwiki.plugin.scheduler.SchedulerPluginApi")) : class$com$xpn$xwiki$plugin$scheduler$SchedulerPluginApi));
    private SchedulerPlugin plugin;
    static /* synthetic */ Class class$com$xpn$xwiki$plugin$scheduler$SchedulerPluginApi;

    public SchedulerPluginApi(SchedulerPlugin plugin, XWikiContext context) {
        super(context);
        this.setPlugin(plugin);
    }

    public String getStatus(Object object) {
        try {
            return this.getJobStatus(object.getXWikiObject()).getValue();
        }
        catch (Exception e) {
            this.context.put("error", e.getMessage());
            return null;
        }
    }

    public JobState getJobStatus(BaseObject object) throws SchedulerException, SchedulerPluginException {
        return this.plugin.getJobStatus(object, this.context);
    }

    public JobState getJobStatus(Object object) throws SchedulerException, SchedulerPluginException {
        return this.plugin.getJobStatus(this.retrieveBaseObject(object), this.context);
    }

    private BaseObject retrieveBaseObject(Object object) throws SchedulerPluginException {
        String docName = object.getName();
        int objNb = object.getNumber();
        try {
            XWikiDocument jobHolder = this.context.getWiki().getDocument(docName, this.context);
            BaseObject jobObject = jobHolder.getObject("XWiki.SchedulerJobClass", objNb);
            return jobObject;
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90010, "Job in document [" + docName + "] with object number [" + objNb + "] could not be retrieved.", e);
        }
    }

    public boolean scheduleJob(Object object) {
        try {
            return this.scheduleJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean scheduleJob(BaseObject object) {
        try {
            this.plugin.scheduleJob(object, this.context);
            return true;
        }
        catch (Exception e) {
            this.context.put("error", e.getMessage());
            return false;
        }
    }

    public boolean scheduleJobs(Document document) {
        boolean result = true;
        try {
            XWikiDocument doc = this.context.getWiki().getDocument(document.getFullName(), this.context);
            Vector objects = doc.getObjects("XWiki.SchedulerJobClass");
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                Object object = (Object)iterator.next();
                result &= this.scheduleJob(object);
            }
        }
        catch (Exception e) {
            this.context.put("error", e.getMessage());
            return false;
        }
        return result;
    }

    public boolean pauseJob(Object object) {
        try {
            return this.pauseJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean pauseJob(BaseObject object) {
        try {
            this.plugin.pauseJob(object, this.context);
            LOG.debug((java.lang.Object)("Pause Job : " + object.getStringValue("jobName")));
            return true;
        }
        catch (XWikiException e) {
            this.context.put("error", e.getMessage());
            return false;
        }
    }

    public boolean resumeJob(Object object) {
        try {
            return this.resumeJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean resumeJob(BaseObject object) {
        try {
            this.plugin.resumeJob(object, this.context);
            LOG.debug((java.lang.Object)("Resume Job : " + object.getStringValue("jobName")));
            return true;
        }
        catch (XWikiException e) {
            this.context.put("error", e.getMessage());
            return false;
        }
    }

    public boolean unscheduleJob(Object object) {
        try {
            return this.unscheduleJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unscheduleJob(BaseObject object) {
        try {
            this.plugin.unscheduleJob(object, this.context);
            LOG.debug((java.lang.Object)("Delete Job : " + object.getStringValue("jobName")));
            return true;
        }
        catch (XWikiException e) {
            this.context.put("error", e.getMessage());
            return false;
        }
    }

    public Date getNextFireTime(Object object) {
        try {
            return this.getNextFireTime(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getNextFireTime(BaseObject object) {
        try {
            return this.plugin.getNextFireTime(object, this.context);
        }
        catch (SchedulerPluginException e) {
            this.context.put("error", e.getMessage());
            return null;
        }
    }

    public void setPlugin(SchedulerPlugin plugin) {
        this.plugin = plugin;
    }

    public XWikiPluginInterface getPlugin() {
        if (this.hasProgrammingRights()) {
            return this.plugin;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

