/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.notify.DocChangeRule;
import com.xpn.xwiki.notify.XWikiActionNotificationInterface;
import com.xpn.xwiki.notify.XWikiActionRule;
import com.xpn.xwiki.notify.XWikiDocChangeNotificationInterface;
import com.xpn.xwiki.notify.XWikiNotificationRule;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.skinx.AbstractSkinExtensionPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentSkinExtensionPlugin
extends AbstractSkinExtensionPlugin
implements XWikiDocChangeNotificationInterface,
XWikiActionNotificationInterface {
    private static final Log LOG = LogFactory.getLog(AbstractDocumentSkinExtensionPlugin.class);
    private static final String USE_FIELDNAME = "use";
    private Map<String, Set<String>> alwaysUsedExtensions;

    public AbstractDocumentSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    protected abstract String getExtensionClassName();

    protected abstract String getExtensionName();

    public void init(XWikiContext context) {
        super.init(context);
        this.alwaysUsedExtensions = new HashMap<String, Set<String>>();
        this.getExtensionClass(context);
        context.getWiki().getNotificationManager().addGeneralRule((XWikiNotificationRule)new DocChangeRule((XWikiDocChangeNotificationInterface)this));
        context.getWiki().getNotificationManager().addGeneralRule((XWikiNotificationRule)new XWikiActionRule((XWikiActionNotificationInterface)this, true, true));
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        this.getExtensionClass(context);
    }

    @Override
    public Set<String> getAlwaysUsedExtensions(XWikiContext context) {
        String currentWiki = StringUtils.defaultIfEmpty((String)context.getDatabase(), (String)context.getMainXWiki());
        if (this.alwaysUsedExtensions.get(currentWiki) != null) {
            return this.alwaysUsedExtensions.get(currentWiki);
        }
        HashSet<String> extensions = new HashSet<String>();
        String query = ", BaseObject as obj, StringProperty as use where obj.className='" + this.getExtensionClassName() + "'" + " and obj.name=doc.fullName and use.id.id=obj.id and use.id.name='use' and use.value='always'";
        try {
            for (String extension : context.getWiki().getStore().searchDocumentsNames(query, context)) {
                try {
                    XWikiDocument doc = context.getWiki().getDocument(extension, context);
                    if (!context.getWiki().getRightService().hasProgrammingRights(doc, context)) continue;
                    extensions.add(extension);
                }
                catch (XWikiException e1) {
                    LOG.error((Object)("Error while adding skin extension [" + extension + "] as always used. It will be ignored."), (Throwable)e1);
                }
            }
            this.alwaysUsedExtensions.put(currentWiki, extensions);
            return extensions;
        }
        catch (XWikiException e) {
            LOG.error((Object)"Error while retrieving always used JS extensions", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public boolean hasPageExtensions(XWikiContext context) {
        XWikiDocument doc = context.getDoc();
        Vector objects = doc.getObjects(this.getExtensionClassName());
        if (objects != null) {
            for (BaseObject obj : objects) {
                if (!obj.getStringValue(USE_FIELDNAME).equals("currentPage")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    public BaseClass getExtensionClass(XWikiContext context) {
        try {
            XWikiDocument doc = context.getWiki().getDocument(this.getExtensionClassName(), context);
            boolean needsUpdate = false;
            String useOptions = "currentPage=Always on this page|onDemand=On demand|always=Always on this wiki";
            BaseClass bclass = doc.getxWikiClass();
            if (context.get((Object)"initdone") != null) {
                return bclass;
            }
            bclass.setName(this.getExtensionClassName());
            needsUpdate |= bclass.addTextField("name", "Name", 30);
            needsUpdate |= bclass.addTextAreaField("code", "Code", 50, 20);
            needsUpdate |= bclass.addStaticListField(USE_FIELDNAME, "Use this extension", useOptions);
            needsUpdate |= bclass.addBooleanField("parse", "Parse content", "yesno");
            needsUpdate |= bclass.addStaticListField("cache", "Caching policy", "long|short|default|forbid");
            if (StringUtils.isBlank((String)doc.getCreator())) {
                needsUpdate = true;
                doc.setCreator("superadmin");
            }
            if (StringUtils.isBlank((String)doc.getAuthor())) {
                needsUpdate = true;
                doc.setAuthor(doc.getCreator());
            }
            if (StringUtils.isBlank((String)doc.getParent())) {
                needsUpdate = true;
                doc.setParent("XWiki.XWikiClasses");
            }
            if (StringUtils.isBlank((String)doc.getTitle())) {
                needsUpdate = true;
                doc.setTitle("XWiki " + this.getExtensionName() + " Extension Class");
            }
            if (StringUtils.isBlank((String)doc.getContent()) || !"xwiki/2.0".equals(doc.getSyntaxId())) {
                needsUpdate = true;
                doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
                doc.setSyntaxId("xwiki/2.0");
            }
            if (needsUpdate) {
                context.getWiki().saveDocument(doc, context);
            }
            return bclass;
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot initialize skin extension class [" + this.getExtensionClassName() + "]"), (Throwable)ex);
            return null;
        }
    }

    public void notify(XWikiNotificationRule rule, XWikiDocument newdoc, XWikiDocument olddoc, int event, XWikiContext context) {
        boolean remove = false;
        if (newdoc.getObject(this.getExtensionClassName()) != null) {
            if (newdoc.getObject(this.getExtensionClassName(), USE_FIELDNAME, "always", false) != null) {
                if (context.getWiki().getRightService().hasProgrammingRights(newdoc, context)) {
                    this.getAlwaysUsedExtensions(context).add(newdoc.getFullName());
                    return;
                }
                remove = true;
            } else {
                remove = true;
            }
        } else if (olddoc.getObject(this.getExtensionClassName()) != null) {
            remove = true;
        }
        if (remove) {
            this.getAlwaysUsedExtensions(context).remove(newdoc.getFullName());
        }
    }

    public void notify(XWikiNotificationRule rule, XWikiDocument doc, String action, XWikiContext context) {
        if (!action.equals("import")) {
            return;
        }
        if (StringUtils.equals((String)context.getRequest().getParameter("action"), (String)action)) {
            String currentWiki = StringUtils.defaultIfEmpty((String)context.getDatabase(), (String)context.getMainXWiki());
            this.alwaysUsedExtensions.remove(currentWiki);
        }
    }
}

