/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.skinx.SkinExtensionPluginApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSkinExtensionPlugin
extends XWikiDefaultPlugin {
    private static final Log LOG = LogFactory.getLog(AbstractSkinExtensionPlugin.class);
    protected final String contextKey = ((Object)((Object)this)).getClass().getCanonicalName();
    protected final String parametersContextKey = ((Object)((Object)this)).getClass().getCanonicalName() + "_parameters";

    public AbstractSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public abstract String getLink(String var1, XWikiContext var2);

    public abstract Set<String> getAlwaysUsedExtensions(XWikiContext var1);

    public abstract boolean hasPageExtensions(XWikiContext var1);

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SkinExtensionPluginApi((AbstractSkinExtensionPlugin)plugin, context);
    }

    public void use(String resource, XWikiContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Using [%s] as [%s] extension", resource, this.getName()));
        }
        this.getPulledResources(context).add(resource);
        this.getParametersMap(context).remove(resource);
    }

    public void use(String resource, Map<String, Object> parameters, XWikiContext context) {
        this.use(resource, context);
        this.getParametersMap(context).put(resource, parameters);
    }

    protected Set<String> getPulledResources(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Set)context.get((Object)this.contextKey);
    }

    protected Map<String, Map<String, Object>> getParametersMap(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Map)context.get((Object)this.parametersContextKey);
    }

    protected void initializeRequestListIfNeeded(XWikiContext context) {
        if (!context.containsKey((Object)this.contextKey)) {
            context.put((Object)this.contextKey, new LinkedHashSet());
        }
        if (!context.containsKey((Object)this.parametersContextKey)) {
            context.put((Object)this.parametersContextKey, new HashMap());
        }
    }

    public String getImportString(XWikiContext context) {
        StringBuilder result = new StringBuilder();
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.addAll(this.getAlwaysUsedExtensions(context));
        extensions.addAll(this.getPulledResources(context));
        if (this.hasPageExtensions(context)) {
            extensions.add(context.getDoc().getFullName());
        }
        for (String documentName : extensions) {
            result.append(this.getLink(documentName, context));
        }
        return result.toString();
    }

    protected Map<String, Object> getParametersForResource(String resource, XWikiContext context) {
        Map<String, Object> result = this.getParametersMap(context).get(resource);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    protected String parametersAsQueryString(String resource, XWikiContext context) {
        Map<String, Object> parameters = this.getParametersForResource(resource, context);
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if ("forceSkinAction".equals(parameter.getKey())) continue;
            query.append("&amp;");
            query.append(this.sanitize(parameter.getKey()));
            query.append("=");
            query.append(this.sanitize(parameter.getValue().toString()));
        }
        return query.toString();
    }

    protected String sanitize(String value) {
        String result = value;
        result = StringUtils.replace((String)result, (String)"\"", (String)"%22");
        result = StringUtils.replace((String)result, (String)"'", (String)"%27");
        result = StringUtils.replace((String)result, (String)"<", (String)"%3C");
        result = StringUtils.replace((String)result, (String)">", (String)"%3E");
        return result;
    }

    public String endParsing(String content, XWikiContext context) {
        String hook = "<!-- " + ((Object)((Object)this)).getClass().getCanonicalName() + " -->";
        String result = content.replaceFirst(hook, this.getImportString(context));
        return result;
    }
}

