/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.skinx.SkinExtensionPluginApi;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SkinExtensionPlugin
extends XWikiDefaultPlugin {
    private static final Log LOG = LogFactory.getLog(SkinExtensionPlugin.class);

    public abstract String getLink(String var1, XWikiContext var2);

    public abstract Set<String> getAlwaysUsedExtensions(XWikiContext var1);

    public SkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SkinExtensionPluginApi((SkinExtensionPlugin)plugin, context);
    }

    protected Set<String> getRequestList(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Set)context.get((Object)((Object)((Object)this)).getClass().getCanonicalName());
    }

    protected void initializeRequestListIfNeeded(XWikiContext context) {
        if (!context.containsKey((Object)((Object)((Object)this)).getClass().getCanonicalName())) {
            context.put((Object)((Object)((Object)this)).getClass().getCanonicalName(), new LinkedHashSet());
        }
    }

    public void use(String skinFile, XWikiContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Using [%s] as [%s] extension", skinFile, this.getName()));
        }
        this.getRequestList(context).add(skinFile);
    }

    public String getImportString(XWikiContext context) {
        StringBuilder iStr = new StringBuilder();
        if (context.getAction().equals("view") || context.getAction().equals("admin")) {
            for (String docName : this.getAlwaysUsedExtensions(context)) {
                iStr.append(this.getLink(docName, context));
            }
        }
        Set<String> requestList = this.getRequestList(context);
        requestList.removeAll(this.getAlwaysUsedExtensions(context));
        for (String docName : requestList) {
            iStr.append(this.getLink(docName, context));
        }
        return iStr.toString();
    }

    public void beginParsing(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
    }

    public String endParsing(String content, XWikiContext context) {
        String hook = "<!-- " + ((Object)((Object)this)).getClass().getCanonicalName() + " -->";
        String result = content.replaceFirst(hook, this.getImportString(context));
        return result;
    }
}

