/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.spacemanager.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.spacemanager.api.Space;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagerException;
import com.xpn.xwiki.plugin.spacemanager.impl.SpaceManagerImpl;
import java.util.Date;
import java.util.List;

public class SpaceImpl
extends Document
implements Space {
    public static final String SPACE_DISPLAYTITLE = "displayTitle";
    public static final String SPACE_DESCRIPTION = "description";
    public static final String SPACE_TYPE = "type";
    public static final String SPACE_URLSHORTCUT = "urlshortcut";
    public static final String SPACE_POLICY = "policy";
    public static final String SPACE_LANGUAGE = "language";
    protected SpaceManagerImpl manager = null;

    public SpaceImpl(String spaceName, String spaceTitle, boolean create, SpaceManagerImpl manager, XWikiContext context) throws SpaceManagerException {
        super(null, context);
        this.manager = manager;
        if (spaceName == null) {
            spaceName = manager.getSpaceWikiName(spaceTitle, true, context);
        }
        this.initSpaceDoc(spaceName);
        if (create) {
            if (this.isNew()) {
                this.createNewSpaceDoc(spaceTitle);
            } else {
                throw new SpaceManagerException(100, 100001, "Space already exists");
            }
        }
    }

    public boolean isDeleted() {
        return !this.getType().equals(this.manager.getSpaceTypeName());
    }

    public String getSpaceName() {
        return this.doc.getSpace();
    }

    protected void initSpaceDoc(String spaceName) throws SpaceManagerException {
        String docName = this.manager.getSpaceDocumentName(spaceName);
        try {
            this.doc = this.context.getWiki().getDocument(docName, this.context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    protected void createNewSpaceDoc(String spaceTitle) {
        XWikiDocument spaceDoc = this.getDoc();
        String className = this.manager.getSpaceClassName();
        BaseObject spaceObj = new BaseObject();
        spaceObj.setName(this.doc.getFullName());
        spaceObj.setClassName(className);
        spaceDoc.addObject(className, spaceObj);
        className = "XWiki.XWikiPreferences";
        BaseObject xWikiPrefObj = new BaseObject();
        xWikiPrefObj.setName(spaceDoc.getFullName());
        xWikiPrefObj.setClassName(className);
        spaceDoc.addObject(className, xWikiPrefObj);
        spaceObj.setStringValue(SPACE_DISPLAYTITLE, spaceTitle);
    }

    public void setCreator(String creator) {
        this.getDoc().setCreator(creator);
    }

    public String getDisplayTitle() {
        return this.doc.getStringValue(this.manager.getSpaceClassName(), SPACE_DISPLAYTITLE);
    }

    public void setDisplayTitle(String title) {
        this.getDoc().setStringValue(this.manager.getSpaceClassName(), SPACE_DISPLAYTITLE, title);
    }

    public String getType() {
        return this.doc.getStringValue(this.manager.getSpaceClassName(), SPACE_TYPE);
    }

    public void setType(String type) {
        this.getDoc().setStringValue(this.manager.getSpaceClassName(), SPACE_TYPE, type);
    }

    public String getDescription() {
        return this.doc.getStringValue(this.manager.getSpaceClassName(), SPACE_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.getDoc().setLargeStringValue(this.manager.getSpaceClassName(), SPACE_DESCRIPTION, description);
    }

    public String getPolicy() {
        return this.doc.getStringValue(this.manager.getSpaceClassName(), SPACE_POLICY);
    }

    public void setPolicy(String policy) {
        this.getDoc().setStringValue(this.manager.getSpaceClassName(), SPACE_POLICY, policy);
    }

    public String getPreference(String prefName) throws SpaceManagerException {
        try {
            return this.context.getWiki().getPrefsClass(this.context).getStringValue(prefName);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public String getHomeShortcutURL() {
        return this.doc.getStringValue(this.manager.getSpaceClassName(), SPACE_URLSHORTCUT);
    }

    public void setHomeShortcutURL(String homeShortCutURL) {
        this.getDoc().setStringValue(this.manager.getSpaceClassName(), SPACE_URLSHORTCUT, homeShortCutURL);
    }

    public String getHomeURL() throws SpaceManagerException {
        try {
            return this.context.getWiki().getURL(this.getSpace() + ".WebHome", "view", this.context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public List getFieldNames() throws SpaceManagerException {
        try {
            return (List)this.manager.getSpaceClass(this.context).getFieldList();
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void updateSpaceFromRequest() throws SpaceManagerException {
        XWikiDocument doc = this.getDoc();
        try {
            doc.updateObjectFromRequest(this.manager.getSpaceClassName(), this.context);
            doc.updateObjectFromRequest("XWiki.XWikiPreferences", this.context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public boolean validateSpaceData() throws SpaceManagerException {
        try {
            return this.doc.validate(this.context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void setCreationDate(Date date) {
        this.getDoc().setCreationDate(date);
    }
}

