/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.spacemanager.impl;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import com.xpn.xwiki.plugin.spacemanager.api.Space;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManager;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagerException;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagerExtension;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagers;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceUserProfile;
import com.xpn.xwiki.plugin.spacemanager.impl.SpaceImpl;
import com.xpn.xwiki.plugin.spacemanager.impl.SpaceManagerExtensionImpl;
import com.xpn.xwiki.plugin.spacemanager.impl.SpaceUserProfileImpl;
import com.xpn.xwiki.plugin.spacemanager.plugin.SpaceManagerPluginApi;
import com.xpn.xwiki.render.XWikiVelocityRenderer;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class SpaceManagerImpl
extends XWikiDefaultPlugin
implements SpaceManager {
    public static final String SPACEMANAGER_EXTENSION_CFG_PROP = "xwiki.spacemanager.extension";
    public static final String SPACEMANAGER_PROTECTED_SUBSPACES_PROP = "xwiki.spacemanager.protectedsubspaces";
    public static final String SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES = "";
    public static final String SPACEMANAGER_DEFAULT_EXTENSION = "org.xwiki.plugin.spacemanager.impl.SpaceManagerExtensionImpl";
    public static final String SPACEMANAGER_DEFAULT_MAIL_NOTIFICATION = "1";
    private static final Log LOG = LogFactory.getLog(SpaceManagerImpl.class);
    protected SpaceManagerExtension spaceManagerExtension;
    protected boolean mailNotification;

    public SpaceManagerImpl(String name, String className, XWikiContext context) {
        super(name, className, context);
        String mailNotificationCfg = context.getWiki().Param("xwiki.spacemanager.mailnotification", SPACEMANAGER_DEFAULT_MAIL_NOTIFICATION).trim();
        this.mailNotification = SPACEMANAGER_DEFAULT_MAIL_NOTIFICATION.equals(mailNotificationCfg);
    }

    public void flushCache() {
        super.flushCache();
    }

    protected BaseClass getSpaceClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(this.getSpaceClassName(), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setFullName(this.getSpaceClassName());
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(this.getSpaceClassName());
        needsUpdate |= bclass.addTextField("displayTitle", "Display Name", 64);
        needsUpdate |= bclass.addTextAreaField("description", "Description", 45, 4);
        needsUpdate |= bclass.addTextField("type", "Group or plain space", 32);
        needsUpdate |= bclass.addTextField("urlshortcut", "URL Shortcut", 40);
        needsUpdate |= bclass.addStaticListField("policy", "Membership Policy", 1, false, "open=Open membership|closed=Closed membership", "radio");
        needsUpdate |= bclass.addStaticListField("language", "Language", "en=English|zh=Chinese|nl=Dutch|fr=French|de=German|it=Italian|jp=Japanese|kr=Korean|po=Portuguese|ru=Russian|sp=Spanish");
        String content = doc.getContent();
        if (content == null || content.equals(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES)) {
            needsUpdate = true;
            doc.setContent("1 XWikiSpaceClass");
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    public String getSpaceTypeName() {
        return this.getSpaceManagerExtension().getSpaceTypeName();
    }

    public String getSpaceClassName() {
        return this.getSpaceManagerExtension().getSpaceClassName();
    }

    public boolean hasCustomMapping() {
        return this.getSpaceManagerExtension().hasCustomMapping();
    }

    public void init(XWikiContext context) {
        try {
            this.getSpaceManagerExtension(context);
            this.getSpaceManagerExtension().init(this, context);
            SpaceManagers.addSpaceManager(this);
            this.getSpaceClass(context);
            SpaceUserProfileImpl.getSpaceUserProfileClass(context);
            this.migrateSpaceCorruptedRightsData(context);
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing plugin for main database", (Throwable)e);
        }
    }

    public void virtualInit(XWikiContext context) {
        try {
            this.getSpaceClass(context);
            this.getSpaceManagerExtension().virtualInit(this, context);
            this.migrateSpaceCorruptedRightsData(context);
        }
        catch (Exception e) {
            LOG.error((Object)("Error initializing plugin for database [" + context.getDatabase() + "]"), (Throwable)e);
        }
    }

    private void migrateSpaceCorruptedRightsData(XWikiContext context) throws SpaceManagerException {
        try {
            context.getWiki().getHibernateStore().executeWrite(context, true, new XWikiHibernateBaseStore.HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query q = session.createQuery("select s from BaseObject o, StringProperty s where o.className like 'XWiki.XWiki%Rights' and o.id=s.id and (s.name='users' or s.name='groups')");
                    List lst = q.list();
                    if (lst.size() == 0) {
                        return null;
                    }
                    LOG.warn((Object)"[Migrating corrupted rights properties (see http://jira.xwiki.org/jira/browse/XPSM-12)");
                    ArrayList<LargeStringProperty> lst2 = new ArrayList<LargeStringProperty>(lst.size());
                    for (StringProperty sp : lst) {
                        LargeStringProperty lsp = new LargeStringProperty();
                        lsp.setId(sp.getId());
                        lsp.setName(sp.getName());
                        lsp.setValue(sp.getValue());
                        lst2.add(lsp);
                    }
                    Iterator it = lst.iterator();
                    while (it.hasNext()) {
                        session.delete(it.next());
                    }
                    it = lst2.iterator();
                    while (it.hasNext()) {
                        session.save(it.next());
                    }
                    return null;
                }
            });
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SpaceManagerPluginApi((SpaceManager)plugin, context);
    }

    public SpaceManagerExtension getSpaceManagerExtension(XWikiContext context) throws SpaceManagerException {
        if (this.spaceManagerExtension == null) {
            String extensionName = context.getWiki().Param(SPACEMANAGER_EXTENSION_CFG_PROP, SPACEMANAGER_DEFAULT_EXTENSION);
            try {
                if (extensionName != null) {
                    this.spaceManagerExtension = (SpaceManagerExtension)Class.forName(extensionName).newInstance();
                }
            }
            catch (Throwable e) {
                try {
                    this.spaceManagerExtension = (SpaceManagerExtension)Class.forName(SPACEMANAGER_DEFAULT_EXTENSION).newInstance();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
        }
        if (this.spaceManagerExtension == null) {
            this.spaceManagerExtension = new SpaceManagerExtensionImpl();
        }
        return this.spaceManagerExtension;
    }

    public SpaceManagerExtension getSpaceManagerExtension() {
        return this.spaceManagerExtension;
    }

    public String getName() {
        return "spacemanager";
    }

    private Object notImplemented() throws SpaceManagerException {
        throw new SpaceManagerException(100, 1, "not implemented");
    }

    public String getSpaceWikiName(String spaceTitle, boolean unique, XWikiContext context) {
        return this.getSpaceManagerExtension().getSpaceWikiName(spaceTitle, unique, context);
    }

    protected String getSpaceDocumentName(String spaceName) {
        return spaceName + ".WebPreferences";
    }

    public String[] getProtectedSubSpaces(XWikiContext context) {
        String protectedSubSpaces = context.getWiki().Param(SPACEMANAGER_PROTECTED_SUBSPACES_PROP, SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES);
        if (protectedSubSpaces != null && !protectedSubSpaces.equals(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES)) {
            return protectedSubSpaces.split(",");
        }
        return new String[0];
    }

    protected boolean addRightToGroup(String spaceName, String groupName, String level, boolean allow, boolean global, XWikiContext context) throws XWikiException {
        String rightsClass = global ? "XWiki.XWikiGlobalRights" : "XWiki.XWikiRights";
        String prefDocName = spaceName + ".WebPreferences";
        String groupsField = "groups";
        String levelsField = "levels";
        String allowField = "allow";
        XWikiDocument prefDoc = context.getWiki().getDocument(prefDocName, context);
        boolean exists = false;
        boolean isUpdated = false;
        int indx = -1;
        boolean foundlevel = false;
        int allowInt = allow ? 1 : 0;
        Vector objs = prefDoc.getObjects(rightsClass);
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                BaseObject bobj = (BaseObject)objs.get(i);
                if (bobj == null) continue;
                String groups = bobj.getLargeStringValue("groups");
                String levels = bobj.getStringValue("levels");
                int allowDeny = bobj.getIntValue("allow");
                boolean allowdeny = bobj.getIntValue("allow") == 1;
                Object[] levelsarray = levels.split(" ,|");
                Object[] groupsarray = groups.split(" ,|");
                if (!ArrayUtils.contains((Object[])groupsarray, (Object)groupName)) continue;
                exists = true;
                if (!foundlevel) {
                    indx = i;
                }
                if (!ArrayUtils.contains((Object[])levelsarray, (Object)level)) continue;
                foundlevel = true;
                if (allowInt != allowDeny) continue;
                isUpdated = true;
                break;
            }
        }
        if (!exists) {
            BaseObject bobj = new BaseObject();
            bobj.setClassName(rightsClass);
            bobj.setName(prefDoc.getFullName());
            bobj.setLargeStringValue("groups", groupName);
            bobj.setStringValue("levels", level);
            bobj.setIntValue("allow", allowInt);
            prefDoc.addObject(rightsClass, bobj);
            context.getWiki().saveDocument(prefDoc, context);
            return true;
        }
        if (isUpdated) {
            return true;
        }
        BaseObject bobj = (BaseObject)objs.get(indx);
        String groups = bobj.getLargeStringValue("groups");
        String levels = bobj.getStringValue("levels");
        String[] levelsarray = levels.split(" ,|");
        String[] groupsarray = groups.split(" ,|");
        if (levelsarray.length != 1 || groupsarray.length != 1 || levelsarray[0] != level) {
            bobj = new BaseObject();
            bobj.setName(prefDoc.getFullName());
            bobj.setClassName(rightsClass);
            bobj.setStringValue("levels", level);
            bobj.setIntValue("allow", allowInt);
            bobj.setLargeStringValue("groups", groupName);
        }
        prefDoc.addObject(rightsClass, bobj);
        context.getWiki().saveDocument(prefDoc, context);
        return true;
    }

    protected boolean removeRightFromGroup(String spaceName, String groupName, String level, boolean allow, boolean global, XWikiContext context) throws XWikiException {
        String rightsClass = global ? "XWiki.XWikiGlobalRights" : "XWiki.XWikiRights";
        String prefDocName = spaceName + ".WebPreferences";
        String groupsField = "groups";
        String levelsField = "levels";
        String allowField = "allow";
        XWikiDocument prefDoc = context.getWiki().getDocument(prefDocName, context);
        boolean foundlevel = false;
        int allowInt = allow ? 1 : 0;
        Vector objs = prefDoc.getObjects(rightsClass);
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                BaseObject bobj = (BaseObject)objs.get(i);
                if (bobj == null) continue;
                String groups = bobj.getLargeStringValue("groups");
                String levels = bobj.getStringValue("levels");
                int allowDeny = bobj.getIntValue("allow");
                boolean allowdeny = bobj.getIntValue("allow") == 1;
                Object[] levelsarray = levels.split(" ,|");
                Object[] groupsarray = groups.split(" ,|");
                if (!ArrayUtils.contains((Object[])groupsarray, (Object)groupName) || foundlevel || !ArrayUtils.contains((Object[])levelsarray, (Object)level)) continue;
                foundlevel = true;
                if (allowInt != allowDeny) continue;
                prefDoc.removeObject(bobj);
                context.getWiki().saveDocument(prefDoc, context);
                return true;
            }
        }
        return false;
    }

    public void setSpaceRights(Space newspace, XWikiContext context) throws SpaceManagerException {
        try {
            this.addRightToGroup(newspace.getSpaceName(), this.getAdminGroupName(newspace.getSpaceName()), "edit", true, false, context);
            this.addRightToGroup(newspace.getSpaceName(), this.getAdminGroupName(newspace.getSpaceName()), "admin", true, true, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        String[] subSpaces = this.getProtectedSubSpaces(context);
        for (int i = 0; i < subSpaces.length; ++i) {
            this.setSubSpaceRights(newspace, subSpaces[i], context);
        }
    }

    public void updateSpaceRights(Space space, String oldPolicy, String newPolicy, XWikiContext context) throws SpaceManagerException {
        try {
            if (oldPolicy.equals(newPolicy)) {
                return;
            }
            String[] subSpaces = this.getProtectedSubSpaces(context);
            for (int i = 0; i < subSpaces.length; ++i) {
                if (newPolicy.equals("closed")) {
                    this.addRightToGroup(subSpaces[i] + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "view", true, true, context);
                    this.addRightToGroup(subSpaces[i] + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "comment", true, true, context);
                    continue;
                }
                if (!newPolicy.equals("open")) continue;
                this.removeRightFromGroup(subSpaces[i] + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "view", true, true, context);
                this.removeRightFromGroup(subSpaces[i] + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "comment", true, true, context);
            }
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void setSubSpaceRights(Space space, String subSpace, XWikiContext context) throws SpaceManagerException {
        try {
            if (subSpace != null && !subSpace.equals(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES)) {
                this.addRightToGroup(subSpace + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "edit", true, true, context);
                this.addRightToGroup(subSpace + "_" + space.getSpaceName(), this.getAdminGroupName(space.getSpaceName()), "admin", true, true, context);
                this.addRightToGroup(subSpace + "_" + space.getSpaceName(), this.getAdminGroupName(space.getSpaceName()), "edit", true, false, context);
                if ("closed".equals(space.getPolicy())) {
                    this.addRightToGroup(subSpace + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "view", true, true, context);
                    this.addRightToGroup(subSpace + "_" + space.getSpaceName(), this.getMemberGroupName(space.getSpaceName()), "comment", true, true, context);
                }
            }
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public Space createSpace(String spaceTitle, XWikiContext context) throws SpaceManagerException {
        Space newspace = this.newSpace(null, spaceTitle, true, context);
        try {
            this.getSpaceManagerExtension().preCreateSpace(newspace.getSpaceName(), context);
        }
        catch (SpaceManagerException e) {
            throw new SpaceManagerException(100, 100009, "Space creation aborted by extension", (Exception)((Object)e));
        }
        newspace.setType(this.getSpaceTypeName());
        try {
            newspace.saveWithProgrammingRights();
            this.addAdmin(newspace.getSpaceName(), context.getUser(), context);
            this.addMember(newspace.getSpaceName(), context.getUser(), context);
            this.setSpaceRights(newspace, context);
            this.getSpaceManagerExtension().postCreateSpace(newspace.getSpaceName(), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        this.sendMail("Create", newspace, context);
        return newspace;
    }

    public Space createSpaceFromTemplate(String spaceTitle, String templateSpaceName, XWikiContext context) throws SpaceManagerException {
        Space newspace = this.newSpace(null, spaceTitle, false, context);
        try {
            this.getSpaceManagerExtension().preCreateSpace(newspace.getSpaceName(), context);
        }
        catch (SpaceManagerException e) {
            throw new SpaceManagerException(100, 100009, "Space creation aborted by extension", (Exception)((Object)e));
        }
        if (!newspace.isNew()) {
            throw new SpaceManagerException(100, 100001, "Space already exists");
        }
        try {
            context.getWiki().copyWikiWeb(templateSpaceName, context.getDatabase(), context.getDatabase(), null, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        newspace.setType(this.getSpaceTypeName());
        newspace.setDisplayTitle(spaceTitle);
        newspace.setCreator(context.getUser());
        newspace.setCreationDate(new Date());
        try {
            newspace.saveWithProgrammingRights();
            this.addAdmin(newspace.getSpaceName(), context.getUser(), context);
            this.addMember(newspace.getSpaceName(), context.getUser(), context);
            this.setSpaceRights(newspace, context);
            this.getSpaceManagerExtension().postCreateSpace(newspace.getSpaceName(), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        this.sendMail("Create", newspace, context);
        return newspace;
    }

    public Space createSpaceFromApplication(String spaceTitle, String applicationName, XWikiContext context) throws SpaceManagerException {
        this.notImplemented();
        return null;
    }

    public Space createSpaceFromRequest(String templateSpaceName, XWikiContext context) throws SpaceManagerException {
        String spaceTitle = context.getRequest().get(this.spaceManagerExtension.getSpaceClassName() + "_0_displayTitle");
        if (spaceTitle == null) {
            throw new SpaceManagerException(100, 100002, "Space title is missing");
        }
        Space newspace = this.newSpace(null, spaceTitle, true, context);
        try {
            this.getSpaceManagerExtension().preCreateSpace(newspace.getSpaceName(), context);
        }
        catch (SpaceManagerException e) {
            throw new SpaceManagerException(100, 100009, "Space creation aborted by extension", (Exception)((Object)e));
        }
        newspace.updateSpaceFromRequest();
        if (!newspace.validateSpaceData()) {
            throw new SpaceManagerException(100, 100003, "Space data is not valid");
        }
        if (templateSpaceName != null) {
            try {
                List list = context.getWiki().getStore().searchDocumentsNames("where doc.web='" + templateSpaceName + "'", context);
                for (String docname : list) {
                    XWikiDocument doc = context.getWiki().getDocument(docname, context);
                    context.getWiki().copyDocument(doc.getFullName(), newspace.getSpaceName() + "." + doc.getName(), null, null, null, true, false, true, context);
                }
            }
            catch (XWikiException e) {
                throw new SpaceManagerException(e);
            }
        }
        newspace.setType(this.getSpaceTypeName());
        newspace.updateSpaceFromRequest();
        newspace.setCreator(context.getUser());
        newspace.setCreationDate(new Date());
        try {
            newspace.saveWithProgrammingRights();
            this.addAdmin(newspace.getSpaceName(), context.getUser(), context);
            this.addMember(newspace.getSpaceName(), context.getUser(), context);
            this.setSpaceRights(newspace, context);
            this.getSpaceManagerExtension().postCreateSpace(newspace.getSpaceName(), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        this.sendMail("Create", newspace, context);
        return newspace;
    }

    protected Space newSpace(String spaceName, String spaceTitle, boolean create, XWikiContext context) throws SpaceManagerException {
        return new SpaceImpl(spaceName, spaceTitle, create, this, context);
    }

    public Space createSpaceFromRequest(XWikiContext context) throws SpaceManagerException {
        return this.createSpaceFromRequest(null, context);
    }

    public void deleteSpace(String spaceName, boolean deleteData, XWikiContext context) throws SpaceManagerException {
        Space space = this.getSpace(spaceName, context);
        if (deleteData) {
            if (this.getSpaceManagerExtension().preDeleteSpace(space.getSpaceName(), true, context)) {
                String hql = "where doc.web = '" + space.getSpaceName() + "'";
                try {
                    List spaceDocs = context.getWiki().getStore().searchDocuments(hql, context);
                    for (XWikiDocument toBeDeleted : spaceDocs) {
                        context.getWiki().deleteDocument(toBeDeleted, context);
                    }
                    this.getSpaceManagerExtension().postDeleteSpace(space.getSpaceName(), true, context);
                }
                catch (XWikiException e) {
                    throw new SpaceManagerException(e);
                }
            }
        } else if (this.getSpaceManagerExtension().preDeleteSpace(space.getSpaceName(), deleteData, context) && !space.isNew()) {
            space.setType("deleted");
            try {
                space.saveWithProgrammingRights();
                this.getSpaceManagerExtension().postDeleteSpace(space.getSpaceName(), deleteData, context);
            }
            catch (XWikiException e) {
                throw new SpaceManagerException(e);
            }
        }
    }

    public void deleteSpace(String spaceName, XWikiContext context) throws SpaceManagerException {
        this.deleteSpace(spaceName, false, context);
    }

    public void undeleteSpace(String spaceName, XWikiContext context) throws SpaceManagerException {
        Space space = this.getSpace(spaceName, context);
        if (space.isDeleted()) {
            space.setType(this.getSpaceTypeName());
            try {
                space.saveWithProgrammingRights();
            }
            catch (XWikiException e) {
                throw new SpaceManagerException(e);
            }
        }
    }

    public Space getSpace(String spaceName, XWikiContext context) throws SpaceManagerException {
        return this.newSpace(spaceName, spaceName, false, context);
    }

    public List getSpaces(int nb, int start, XWikiContext context) throws SpaceManagerException {
        List spaceNames = this.getSpaceNames(nb, start, context);
        return this.getSpaceObjects(spaceNames, context);
    }

    public List getSpaces(int nb, int start, String ordersql, XWikiContext context) throws SpaceManagerException {
        List spaceNames = this.getSpaceNames(nb, start, ordersql, context);
        return this.getSpaceObjects(spaceNames, context);
    }

    protected List getSpaceObjects(List spaceNames, XWikiContext context) throws SpaceManagerException {
        if (spaceNames == null) {
            return null;
        }
        ArrayList<Space> spaceList = new ArrayList<Space>();
        for (int i = 0; i < spaceNames.size(); ++i) {
            String spaceName = (String)spaceNames.get(i);
            Space space = this.getSpace(spaceName, context);
            spaceList.add(space);
        }
        return spaceList;
    }

    public List getSpaceNames(int nb, int start, XWikiContext context) throws SpaceManagerException {
        return this.getSpaceNames(nb, start, SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES, context);
    }

    public List getSpaceNames(int nb, int start, String ordersql, XWikiContext context) throws SpaceManagerException {
        String type = this.getSpaceTypeName();
        String className = this.getSpaceClassName();
        String sql = this.hasCustomMapping() ? "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, " + className + " as space where doc.fullName = obj.name and obj.className='" + className + "' and obj.id = space.id and space.type='" + type + "'" + ordersql : "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, StringProperty typeprop where doc.fullName=obj.name and obj.className = '" + className + "' and obj.id=typeprop.id.id and typeprop.id.name='type' and typeprop.value='" + type + "'" + ordersql;
        List spaceList = null;
        try {
            spaceList = context.getWiki().getStore().search(sql, nb, start, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        return spaceList;
    }

    public List searchSpaces(String fromsql, String wheresql, String ordersql, int nb, int start, XWikiContext context) throws SpaceManagerException {
        List spaceNames = this.searchSpaceNames(fromsql, wheresql, ordersql, nb, start, context);
        return this.getSpaceObjects(spaceNames, context);
    }

    public List searchSpaces(String fromsql, String wheresql, int nb, int start, XWikiContext context) throws SpaceManagerException {
        return this.searchSpaces(fromsql, wheresql, SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES, nb, start, context);
    }

    public List searchSpaceNames(String fromsql, String wheresql, String ordersql, int nb, int start, XWikiContext context) throws SpaceManagerException {
        String type = this.getSpaceTypeName();
        String className = this.getSpaceClassName();
        String sql = this.hasCustomMapping() ? "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, " + className + " as space" + fromsql + " where doc.fullName = obj.name and obj.className='" + className + "' and obj.id = space.id and space.type='" + type + "'" + wheresql + ordersql : "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, StringProperty as typeprop" + fromsql + " where doc.fullName=obj.name and obj.className = '" + className + "' and obj.id=typeprop.id.id and typeprop.id.name='type' and typeprop.value='" + type + "'" + wheresql + ordersql;
        List spaceList = null;
        try {
            spaceList = context.getWiki().getStore().search(sql, nb, start, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        return spaceList;
    }

    public List searchSpaceNames(String fromsql, String wheresql, int nb, int start, XWikiContext context) throws SpaceManagerException {
        return this.searchSpaceNames(fromsql, wheresql, SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES, nb, start, context);
    }

    public List getSpaces(String userName, String role, XWikiContext context) throws SpaceManagerException {
        List spaceNames = this.getSpaceNames(userName, role, context);
        return this.getSpaceObjects(spaceNames, context);
    }

    public List getSpaceNames(String userName, String role, XWikiContext context) throws SpaceManagerException {
        String sql;
        if (role == null) {
            sql = "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, StringProperty as memberprop where doc.name='MemberGroup' and doc.fullName=obj.name and obj.className = 'XWiki.XWikiGroups' and obj.id=memberprop.id.id and memberprop.id.name='member' and memberprop.value='" + userName + "'";
        } else {
            String roleGroupName = this.getRoleGroupName(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES, role).substring(1);
            sql = "select distinct doc.web from XWikiDocument as doc, BaseObject as obj, StringProperty as memberprop where doc.name='" + roleGroupName + "' and doc.fullName=obj.name and obj.className = 'XWiki.XWikiGroups'" + " and obj.id=memberprop.id.id and memberprop.id.name='member' and memberprop.value='" + userName + "'";
        }
        List spaceList = null;
        try {
            spaceList = context.getWiki().getStore().search(sql, 0, 0, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
        return spaceList;
    }

    public boolean updateSpaceFromRequest(Space space, XWikiContext context) throws SpaceManagerException {
        space.updateSpaceFromRequest();
        return space.validateSpaceData();
    }

    public boolean validateSpaceData(Space space, XWikiContext context) throws SpaceManagerException {
        return space.validateSpaceData();
    }

    public void saveSpace(Space space, XWikiContext context) throws SpaceManagerException {
        try {
            space.saveWithProgrammingRights();
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addAdmin(String spaceName, String username, XWikiContext context) throws SpaceManagerException {
        try {
            this.addUserToGroup(username, this.getAdminGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addAdmins(String spaceName, List usernames, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < usernames.size(); ++i) {
            this.addAdmin(spaceName, (String)usernames.get(i), context);
        }
    }

    public Collection getAdmins(String spaceName, XWikiContext context) throws SpaceManagerException {
        try {
            return this.getGroupService(context).getAllMembersNamesForGroup(this.getAdminGroupName(spaceName), 0, 0, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void removeAdmin(String spaceName, String userName, XWikiContext context) throws SpaceManagerException {
        try {
            this.removeUserFromGroup(userName, this.getAdminGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public boolean isAdmin(String spaceName, String userName, XWikiContext context) throws SpaceManagerException {
        try {
            return this.isMemberOfGroup(userName, this.getAdminGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addUserToRole(String spaceName, String username, String role, XWikiContext context) throws SpaceManagerException {
        try {
            this.addUserToGroup(username, this.getRoleGroupName(spaceName, role), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addUsersToRole(String spaceName, List usernames, String role, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < usernames.size(); ++i) {
            this.addUserToRole(spaceName, (String)usernames.get(i), role, context);
        }
    }

    public Collection getUsersForRole(String spaceName, String role, XWikiContext context) throws SpaceManagerException {
        try {
            return this.sortUserNames(this.getGroupService(context).getAllMembersNamesForGroup(this.getRoleGroupName(spaceName, role), 0, 0, context), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public boolean isMember(String spaceName, String username, XWikiContext context) throws SpaceManagerException {
        try {
            return this.isMemberOfGroup(username, this.getMemberGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addUserToRoles(String spaceName, String username, List roles, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < roles.size(); ++i) {
            this.addUserToRole(spaceName, username, (String)roles.get(i), context);
        }
    }

    public void addUsersToRoles(String spaceName, List usernames, List roles, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < usernames.size(); ++i) {
            this.addUserToRoles(spaceName, (String)usernames.get(i), roles, context);
        }
    }

    public void removeUserFromRoles(String spaceName, String userName, List roles, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < roles.size(); ++i) {
            this.removeUserFromRole(spaceName, userName, (String)roles.get(i), context);
        }
    }

    public void removeUserFromRole(String spaceName, String userName, String role, XWikiContext context) throws SpaceManagerException {
        try {
            this.removeUserFromGroup(userName, this.getRoleGroupName(spaceName, role), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void addMember(String spaceName, String username, XWikiContext context) throws SpaceManagerException {
        try {
            this.addUserToGroup(username, this.getMemberGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public void removeMember(String spaceName, String userName, XWikiContext context) throws SpaceManagerException {
        try {
            if (this.isAdmin(spaceName, userName, context)) {
                this.removeAdmin(spaceName, userName, context);
            }
            for (String role : this.getRoles(spaceName, context)) {
                this.removeUserFromRole(spaceName, userName, role, context);
            }
            this.deleteSpaceUserProfile(spaceName, userName, context);
            this.removeUserFromGroup(userName, this.getMemberGroupName(spaceName), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    protected boolean isMemberOfGroup(String username, String groupname, XWikiContext context) throws XWikiException {
        Collection coll = context.getWiki().getGroupService(context).getAllGroupsNamesForMember(username, 0, 0, context);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (!groupname.equals((String)it.next())) continue;
            return true;
        }
        return false;
    }

    protected void addUserToGroup(String username, String groupName, XWikiContext context) throws XWikiException {
        if (this.isMemberOfGroup(username, groupName, context)) {
            return;
        }
        XWiki xwiki = context.getWiki();
        BaseClass groupClass = xwiki.getGroupClass(context);
        XWikiDocument groupDoc = xwiki.getDocument(groupName, context);
        BaseObject memberObject = (BaseObject)groupClass.newObject(context);
        memberObject.setClassName(groupClass.getName());
        memberObject.setName(groupDoc.getFullName());
        memberObject.setStringValue("member", username);
        groupDoc.addObject(groupClass.getName(), memberObject);
        String content = groupDoc.getContent();
        if (content == null || content.equals(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES)) {
            groupDoc.setContent("#includeForm(\"XWiki.XWikiGroupSheet\")");
        }
        xwiki.saveDocument(groupDoc, context.getMessageTool().get("core.comment.addedUserToGroup"), context);
    }

    private void removeUserFromGroup(String userName, String groupName, XWikiContext context) throws XWikiException {
        if (!this.isMemberOfGroup(userName, groupName, context)) {
            return;
        }
        XWiki xwiki = context.getWiki();
        BaseClass groupClass = xwiki.getGroupClass(context);
        XWikiDocument groupDoc = xwiki.getDocument(groupName, context);
        BaseObject memberObject = groupDoc.getObject(groupClass.getName(), "member", userName);
        if (memberObject == null) {
            return;
        }
        groupDoc.removeObject(memberObject);
        xwiki.saveDocument(groupDoc, context.getMessageTool().get("core.comment.removedUserFromGroup"), context);
    }

    public void addMembers(String spaceName, List usernames, XWikiContext context) throws SpaceManagerException {
        for (int i = 0; i < usernames.size(); ++i) {
            this.addMember(spaceName, (String)usernames.get(i), context);
        }
    }

    public Collection getMembers(String spaceName, XWikiContext context) throws SpaceManagerException {
        try {
            return this.sortUserNames(this.getGroupService(context).getAllMembersNamesForGroup(this.getMemberGroupName(spaceName), 0, 0, context), context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    private List sortUserNames(Collection collectionOfUsers, final XWikiContext context) {
        ArrayList users = new ArrayList(collectionOfUsers);
        Collections.sort(users, new Comparator(){

            public int compare(Object a, Object b) {
                try {
                    XWikiDocument aDoc = context.getWiki().getDocument((String)a, context);
                    XWikiDocument bDoc = context.getWiki().getDocument((String)b, context);
                    String aFirstName = aDoc.getObject("XWiki.XWikiUsers").getStringValue("first_name");
                    String bFirstName = bDoc.getObject("XWiki.XWikiUsers").getStringValue("first_name");
                    int cmp = aFirstName.compareToIgnoreCase(bFirstName);
                    if (cmp == 0) {
                        String aLastName = aDoc.getObject("XWiki.XWikiUsers").getStringValue("last_name");
                        String bLastName = bDoc.getObject("XWiki.XWikiUsers").getStringValue("last_name");
                        return aLastName.compareTo(bLastName);
                    }
                    return cmp;
                }
                catch (Exception e) {
                    return ((String)a).compareTo((String)b);
                }
            }
        });
        return users;
    }

    public String getMemberGroupName(String spaceName) {
        return this.getSpaceManagerExtension().getMemberGroupName(spaceName);
    }

    public String getAdminGroupName(String spaceName) {
        return this.getSpaceManagerExtension().getAdminGroupName(spaceName);
    }

    public String getRoleGroupName(String spaceName, String role) {
        return this.getSpaceManagerExtension().getRoleGroupName(spaceName, role);
    }

    protected XWikiGroupService getGroupService(XWikiContext context) throws XWikiException {
        return context.getWiki().getGroupService(context);
    }

    public SpaceUserProfile getSpaceUserProfile(String spaceName, String username, XWikiContext context) throws SpaceManagerException {
        return this.newUserSpaceProfile(username, spaceName, context);
    }

    private void deleteSpaceUserProfile(String spaceName, String userName, XWikiContext context) throws SpaceManagerException {
        try {
            String docName = this.getSpaceUserProfilePageName(userName, spaceName);
            XWikiDocument doc = context.getWiki().getDocument(docName, context);
            if (!doc.isNew()) {
                context.getWiki().deleteDocument(doc, context);
            }
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public String getSpaceUserProfilePageName(String userName, String spaceName) {
        return this.getSpaceManagerExtension().getSpaceUserProfilePageName(userName, spaceName);
    }

    protected SpaceUserProfile newUserSpaceProfile(String user, String space, XWikiContext context) throws SpaceManagerException {
        try {
            return new SpaceUserProfileImpl(user, space, this, context);
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public List getLastModifiedDocuments(String spaceName, XWikiContext context, boolean recursive, int nb, int start) throws SpaceManagerException {
        this.notImplemented();
        return null;
    }

    public Collection getRoles(String spaceName, XWikiContext context) throws SpaceManagerException {
        return Collections.EMPTY_LIST;
    }

    public Collection getRoles(String spaceName, String memberName, XWikiContext context) throws SpaceManagerException {
        try {
            Collection memberRoles = context.getWiki().getGroupService(context).getAllGroupsNamesForMember(memberName, 0, 0, context);
            Collection spaceRoles = this.getRoles(spaceName, context);
            memberRoles.retainAll(spaceRoles);
            return memberRoles;
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public List getLastModifiedDocuments(String spaceName, XWikiContext context) throws SpaceManagerException {
        this.notImplemented();
        return null;
    }

    public List searchDocuments(String spaceName, String hql, XWikiContext context) throws SpaceManagerException {
        this.notImplemented();
        return null;
    }

    public int countSpaces(XWikiContext context) throws SpaceManagerException {
        String type = this.getSpaceTypeName();
        String className = this.getSpaceClassName();
        String sql = this.hasCustomMapping() ? "select count(*) from XWikiDocument as doc, BaseObject as obj, " + className + " as space" + " where doc.fullName = obj.name and obj.className='" + className + "' and obj.id = space.id and space.type='" + type + "'" : "select count(*) from XWikiDocument as doc, BaseObject as obj, StringProperty as typeprop where doc.fullName=obj.name and obj.className = '" + className + "' and obj.id=typeprop.id.id and typeprop.id.name='type' and typeprop.value='" + type + "'";
        try {
            List result = context.getWiki().search(sql, context);
            Integer res = (Integer)result.get(0);
            return res;
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public boolean joinSpace(String spaceName, XWikiContext context) throws SpaceManagerException {
        try {
            SpaceUserProfile userProfile = this.newUserSpaceProfile(context.getUser(), spaceName, context);
            userProfile.updateProfileFromRequest();
            userProfile.saveWithProgrammingRights();
            this.addMember(spaceName, context.getUser(), context);
            this.sendMail("Join", this.getSpace(spaceName, context), context);
            return true;
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    private void sendMail(String action, Space space, XWikiContext context) throws SpaceManagerException {
        if (!this.mailNotification) {
            return;
        }
        VelocityContext vContext = new VelocityContext();
        vContext.put("space", (Object)space);
        String fromUser = context.getWiki().getXWikiPreference("space_email", context);
        if (fromUser == null || fromUser.trim().length() == 0) {
            fromUser = context.getWiki().getXWikiPreference("admin_email", context);
        }
        String[] toUsers = new String[]{};
        if ("Create".equals(action)) {
            Collection admins = this.getAdmins(space.getSpaceName(), context);
            toUsers = admins.toArray(new String[admins.size()]);
        } else if ("Join".equals(action)) {
            boolean optOutEmail = false;
            try {
                optOutEmail = context.getWiki().getUserPreferenceAsInt("opt_out", context) != 0;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (optOutEmail) {
                return;
            }
            toUsers = new String[]{context.getUser()};
        }
        if (fromUser == null) {
            throw new SpaceManagerException(100, 100004, "Sender email is invalid");
        }
        boolean toUsersValid = toUsers.length > 0;
        for (int i = 0; i < toUsers.length && toUsersValid; ++i) {
            if (!this.isEmailAddress(toUsers[i])) {
                toUsers[i] = this.getEmailAddress(toUsers[i], context);
            }
            if (toUsers[i] != null) continue;
            toUsersValid = false;
        }
        if (!toUsersValid) {
            throw new SpaceManagerException(100, 100005, "Target email is invalid");
        }
        String strToUsers = SpaceManagerImpl.join(toUsers, ",");
        MailSenderPlugin mailSender = this.getMailSenderPlugin(context);
        try {
            String templateDocFullName = this.getTemplateMailPageName(space.getSpaceName(), action, context);
            XWikiDocument mailDoc = context.getWiki().getDocument(templateDocFullName, context);
            XWikiDocument translatedMailDoc = mailDoc.getTranslatedDocument(context);
            mailSender.prepareVelocityContext(fromUser, strToUsers, null, null, vContext, context);
            vContext.put("xwiki", (Object)new com.xpn.xwiki.api.XWiki(context.getWiki(), context));
            vContext.put("context", (Object)new Context(context));
            String mailSubject = XWikiVelocityRenderer.evaluate((String)translatedMailDoc.getTitle(), (String)templateDocFullName, (VelocityContext)vContext, (XWikiContext)context);
            String mailContent = XWikiVelocityRenderer.evaluate((String)translatedMailDoc.getContent(), (String)templateDocFullName, (VelocityContext)vContext, (XWikiContext)context);
            Mail mail = new Mail(fromUser, strToUsers, null, null, mailSubject, mailContent, null);
            mailSender.sendMail(mail, context);
        }
        catch (Exception e) {
            throw new SpaceManagerException(100, 100007, "Sending notification email failed", e);
        }
    }

    private MailSenderPlugin getMailSenderPlugin(XWikiContext context) throws SpaceManagerException {
        MailSenderPlugin mailSender = (MailSenderPlugin)context.getWiki().getPlugin("mailsender", context);
        if (mailSender == null) {
            throw new SpaceManagerException(100, 100006, "SpaceManager requires the mail sender plugin");
        }
        return mailSender;
    }

    private static final String join(String[] array, String separator) {
        StringBuffer result = new StringBuffer(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES);
        if (array.length > 0) {
            result.append(array[0]);
        }
        for (int i = 1; i < array.length; ++i) {
            result.append("," + array[i]);
        }
        return result.toString();
    }

    private boolean isEmailAddress(String str) {
        return str.contains("@");
    }

    private String getEmailAddress(String user, XWikiContext context) throws SpaceManagerException {
        try {
            String wikiuser;
            String string = wikiuser = user.startsWith("XWiki.") ? user : "XWiki." + user;
            if (wikiuser == null) {
                return null;
            }
            XWikiDocument userDoc = null;
            userDoc = context.getWiki().getDocument(wikiuser, context);
            if (userDoc.isNew()) {
                return null;
            }
            String email = SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES;
            try {
                email = userDoc.getObject("XWiki.XWikiUsers").getStringValue("email");
            }
            catch (Exception e) {
                return null;
            }
            if (email == null || email.equals(SPACEMANAGER_DEFAULT_PROTECTED_SUBSPACES)) {
                return null;
            }
            return email;
        }
        catch (Exception e) {
            throw new SpaceManagerException(100, 100008, "Cannot find email address of user " + user, e);
        }
    }

    private String getTemplateMailPageName(String spaceName, String action, XWikiContext context) {
        String docName = spaceName + "." + "MailTemplate" + action + "Space";
        try {
            if (context.getWiki().getDocument(docName, context).isNew()) {
                docName = null;
            }
        }
        catch (XWikiException e) {
            docName = null;
        }
        if (docName == null) {
            docName = this.getDefaultResourceSpace(context) + "." + "MailTemplate" + action + "Space";
        }
        return docName;
    }

    private String getDefaultResourceSpace(XWikiContext context) {
        return context.getWiki().Param("xwiki.spacemanager.resourcespace", "SpaceManagerResources");
    }

    public boolean isMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(boolean mailNotification) {
        this.mailNotification = mailNotification;
    }
}

