/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.spacemanager.impl;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.BooleanClass;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManager;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagerException;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceUserProfile;

public class SpaceUserProfileImpl
extends Document
implements SpaceUserProfile {
    private static final String SPACE_USER_PROFILE_CLASS_NAME = "XWiki.SpaceUserProfileClass";
    private static final String SPACE_USER_PROFILE_PROFILE = "profile";
    private static final String SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS = "allowNotifications";
    private static final String SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS_FROM_SELF = "allowNotificationsFromSelf";
    private String userName;
    private SpaceManager manager;
    private Document userDoc;

    public SpaceUserProfileImpl(String userName, String spaceName, SpaceManager manager, XWikiContext context) throws XWikiException {
        super(null, context);
        this.manager = manager;
        this.userName = userName;
        String docName = manager.getSpaceUserProfilePageName(userName, spaceName);
        this.doc = context.getWiki().getDocument(docName, context);
        if (this.doc.getObject(SpaceUserProfileImpl.getSpaceUserProfileClassName()) == null) {
            this.doc.newObject(SpaceUserProfileImpl.getSpaceUserProfileClassName(), context);
        }
    }

    protected static BaseClass getSpaceUserProfileClass(XWikiContext context) throws XWikiException {
        String content;
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(SpaceUserProfileImpl.getSpaceUserProfileClassName(), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            doc.setFullName(SpaceUserProfileImpl.getSpaceUserProfileClassName());
            needsUpdate = true;
        }
        BaseClass bclass = doc.getxWikiClass();
        bclass.setName(SpaceUserProfileImpl.getSpaceUserProfileClassName());
        needsUpdate |= bclass.addTextAreaField(SPACE_USER_PROFILE_PROFILE, "Profile", 80, 7);
        if (needsUpdate |= bclass.addBooleanField(SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS, "Allow Notifications", "yesno")) {
            ((BooleanClass)bclass.getField(SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS)).setDisplayType("checkbox");
        }
        if (needsUpdate |= bclass.addBooleanField(SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS_FROM_SELF, "Allow Notifications From Self", "yesno")) {
            ((BooleanClass)bclass.getField(SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS_FROM_SELF)).setDisplayType("checkbox");
        }
        if ((content = doc.getContent()) == null || content.equals("")) {
            needsUpdate = true;
            doc.setContent("1 XWiki Space User Profile Class");
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    protected static String getSpaceUserProfileClassName() {
        return SPACE_USER_PROFILE_CLASS_NAME;
    }

    protected Document getUserDocument() throws XWikiException {
        if (this.userDoc == null) {
            this.userDoc = new Document(this.context.getWiki().getDocument(this.userName, this.context), this.context);
        }
        return this.userDoc;
    }

    public String getProfile() {
        return this.doc.getStringValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_PROFILE);
    }

    public void setProfile(String profile) {
        this.getDoc().setLargeStringValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_PROFILE, profile);
    }

    public boolean getAllowNotifications() {
        return this.doc.getIntValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS) == 1;
    }

    public boolean getAllowNotificationsFromSelf() {
        return this.doc.getIntValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS_FROM_SELF) == 1;
    }

    public void setAllowNotifications(boolean allowNotifications) {
        this.getDoc().setIntValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS, allowNotifications ? 1 : 0);
    }

    public void setAllowNotificationsFromSelf(boolean allowNotificationsFromSelf) {
        this.getDoc().setIntValue(SpaceUserProfileImpl.getSpaceUserProfileClassName(), SPACE_USER_PROFILE_ALLOW_NOTIFICATIONS_FROM_SELF, allowNotificationsFromSelf ? 1 : 0);
    }

    public void updateProfileFromRequest() throws SpaceManagerException {
        try {
            this.updateObjectFromRequest(SpaceUserProfileImpl.getSpaceUserProfileClassName());
        }
        catch (XWikiException e) {
            throw new SpaceManagerException(e);
        }
    }

    public String getUserProperty(String propName) {
        try {
            return (String)this.getUserDocument().getObject("XWiki.XWikiUsers").display(propName, "view");
        }
        catch (XWikiException e) {
            return "";
        }
    }

    public String getFirstName() {
        return this.getUserProperty("first_name");
    }

    public String getLastName() {
        return this.getUserProperty("last_name");
    }

    public String getEmail() {
        return this.getUserProperty("email");
    }

    public String getUserURL() {
        try {
            return this.getUserDocument().getURL();
        }
        catch (XWikiException e) {
            return "";
        }
    }
}

