/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.spacemanager.plugin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.spacemanager.api.Space;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManager;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceManagerException;
import com.xpn.xwiki.plugin.spacemanager.api.SpaceUserProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SpaceManagerPluginApi
extends PluginApi {
    public static String getVersion() {
        return "dd";
    }

    public SpaceManagerPluginApi(SpaceManager plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    protected SpaceManager getSpaceManager() {
        return (SpaceManager)this.getProtectedPlugin();
    }

    public Space getCurrentSpace() throws SpaceManagerException {
        return this.getSpace(this.context.getDoc().getSpace());
    }

    public Space getSpace(String spaceName) throws SpaceManagerException {
        Space space = this.getSpaceManager().getSpace(spaceName, this.context);
        return space;
    }

    public Space createSpace(String spaceName) throws SpaceManagerException {
        Space space;
        try {
            if (!this.hasProgrammingRights()) {
                return null;
            }
            space = this.getSpaceManager().createSpace(spaceName, this.context);
        }
        catch (SpaceManagerException e) {
            if (e.getCode() == 100003) {
                return null;
            }
            throw e;
        }
        return space;
    }

    public Space createSpaceFromTemplate(String spaceName, String templateSpaceName) throws SpaceManagerException {
        Space space;
        try {
            if (!this.hasProgrammingRights()) {
                return null;
            }
            space = this.getSpaceManager().createSpaceFromTemplate(spaceName, templateSpaceName, this.context);
        }
        catch (SpaceManagerException e) {
            if (e.getCode() == 100003) {
                return null;
            }
            throw e;
        }
        return space;
    }

    public Space createSpaceFromApplication(String spaceName, String applicationName) throws SpaceManagerException {
        Space space;
        try {
            if (!this.hasProgrammingRights()) {
                return null;
            }
            space = this.getSpaceManager().createSpaceFromApplication(spaceName, applicationName, this.context);
        }
        catch (SpaceManagerException e) {
            if (e.getCode() == 100003) {
                return null;
            }
            throw e;
        }
        return space;
    }

    public Space createSpaceFromRequest() throws SpaceManagerException {
        Space space;
        try {
            if (!this.hasProgrammingRights()) {
                return null;
            }
            space = this.getSpaceManager().createSpaceFromRequest(this.context);
        }
        catch (SpaceManagerException e) {
            if (e.getCode() == 100003) {
                return null;
            }
            throw e;
        }
        return space;
    }

    public Space createSpaceFromRequest(String templateSpace) throws SpaceManagerException {
        Space space;
        try {
            if (!this.hasProgrammingRights()) {
                return null;
            }
            space = this.getSpaceManager().createSpaceFromRequest(templateSpace, this.context);
        }
        catch (SpaceManagerException e) {
            if (e.getCode() == 100003) {
                return null;
            }
            throw e;
        }
        return space;
    }

    public boolean deleteSpace(String spaceName, boolean deleteData) throws SpaceManagerException {
        if (!this.hasProgrammingRights()) {
            return false;
        }
        this.getSpaceManager().deleteSpace(spaceName, deleteData, this.context);
        return true;
    }

    public boolean undeleteSpace(String spaceName) throws SpaceManagerException {
        if (!this.hasProgrammingRights()) {
            return false;
        }
        this.getSpaceManager().undeleteSpace(spaceName, this.context);
        return true;
    }

    public List getSpaces(int nb, int start) throws SpaceManagerException {
        List spacesList = this.getSpaceManager().getSpaces(nb, start, this.context);
        return spacesList;
    }

    public List getSpaces(int nb, int start, String ordersql) throws SpaceManagerException {
        List spacesList = this.getSpaceManager().getSpaces(nb, start, ordersql, this.context);
        return spacesList;
    }

    public List getSpaceNames(int nb, int start) throws SpaceManagerException {
        return this.getSpaceManager().getSpaceNames(nb, start, this.context);
    }

    public List getSpaceNames(int nb, int start, String ordersql) throws SpaceManagerException {
        return this.getSpaceManager().getSpaceNames(nb, start, ordersql, this.context);
    }

    public List searchSpaces(String fromsql, String wheresql, int nb, int start) throws SpaceManagerException {
        List spacesList = this.getSpaceManager().searchSpaces(fromsql, wheresql, nb, start, this.context);
        return spacesList;
    }

    public List searchSpaces(String fromsql, String wheresql, String ordersql, int nb, int start) throws SpaceManagerException {
        List spacesList = this.getSpaceManager().searchSpaces(fromsql, wheresql, ordersql, nb, start, this.context);
        return spacesList;
    }

    public List searchSpaceNames(String fromsql, String wheresql, int nb, int start) throws SpaceManagerException {
        return this.getSpaceManager().searchSpaceNames(fromsql, wheresql, nb, start, this.context);
    }

    public List searchSpaceNames(String fromsql, String wheresql, String ordersql, int nb, int start) throws SpaceManagerException {
        return this.getSpaceManager().searchSpaceNames(fromsql, wheresql, ordersql, nb, start, this.context);
    }

    public List getSpaces(String userName, String role) throws SpaceManagerException {
        List spacesList = this.getSpaceManager().getSpaces(userName, role, this.context);
        return spacesList;
    }

    public List getSpaceNames(String userName, String role) throws SpaceManagerException {
        return this.getSpaceManager().getSpaceNames(userName, role, this.context);
    }

    public boolean updateSpaceFromRequest(Space space) throws SpaceManagerException {
        if (!this.hasProgrammingRights()) {
            return false;
        }
        return this.getSpaceManager().updateSpaceFromRequest(space, this.context);
    }

    public boolean validateSpaceData(Space space) throws SpaceManagerException {
        return this.getSpaceManager().validateSpaceData(space, this.context);
    }

    public List getLastModifiedDocuments(String spaceName, boolean recursive, int nb, int start) throws SpaceManagerException {
        return this.getSpaceManager().getLastModifiedDocuments(spaceName, this.context, recursive, nb, start);
    }

    public Collection getMembers(String spaceName) throws SpaceManagerException {
        return this.getSpaceManager().getMembers(spaceName, this.context);
    }

    public boolean joinSpace(String spaceName) throws SpaceManagerException {
        Space space = this.getSpace(spaceName);
        if ("open".equals(space.getPolicy())) {
            return this.getSpaceManager().joinSpace(spaceName, this.context);
        }
        return false;
    }

    public void addMember(String spaceName, String wikiname) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().addMember(spaceName, wikiname, this.context);
        }
    }

    public void removeMember(String spaceName, String wikiName) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().removeMember(spaceName, wikiName, this.context);
        }
    }

    public void addAdmin(String spaceName, String wikiname) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().addAdmin(spaceName, wikiname, this.context);
        }
    }

    public void removeAdmin(String spaceName, String wikiName) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().removeAdmin(spaceName, wikiName, this.context);
        }
    }

    public Collection getAdmins(String spaceName) throws SpaceManagerException {
        return this.getSpaceManager().getAdmins(spaceName, this.context);
    }

    public Collection getUsersForRole(String spaceName, String role) {
        this.context.remove((Object)"SpaceManagerException");
        try {
            return this.getSpaceManager().getUsersForRole(spaceName, role, this.context);
        }
        catch (SpaceManagerException e) {
            this.context.put((Object)"SpaceManagerException", (Object)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Collection getRoles(String spaceName) {
        this.context.remove((Object)"SpaceManagerException");
        try {
            return this.getSpaceManager().getRoles(spaceName, this.context);
        }
        catch (SpaceManagerException e) {
            this.context.put((Object)"SpaceManagerException", (Object)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Collection getRoles(String spaceName, String memberName) {
        this.context.remove((Object)"SpaceManagerException");
        try {
            return this.getSpaceManager().getRoles(spaceName, memberName, this.context);
        }
        catch (SpaceManagerException e) {
            this.context.put((Object)"SpaceManagerException", (Object)e);
            return Collections.EMPTY_LIST;
        }
    }

    public SpaceUserProfile getSpaceUserProfile(String spaceName, String user) throws SpaceManagerException {
        return this.getSpaceManager().getSpaceUserProfile(spaceName, user, this.context);
    }

    public int countSpaces() throws SpaceManagerException {
        return this.getSpaceManager().countSpaces(this.context);
    }

    public boolean isMember(String spaceName, String username) throws SpaceManagerException {
        return this.getSpaceManager().isMember(spaceName, username, this.context);
    }

    public boolean isAdmin(String spaceName, String userName) throws SpaceManagerException {
        return this.getSpaceManager().isAdmin(spaceName, userName, this.context);
    }

    public void updateSpaceRights(Space space, String oldPolicy, String newPolicy) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().updateSpaceRights(space, oldPolicy, newPolicy, this.context);
        }
    }

    public void setSpaceRights(Space space) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().setSpaceRights(space, this.context);
        }
    }

    public void setSubSpaceRights(Space space, String subSpace) throws SpaceManagerException {
        if (this.hasProgrammingRights()) {
            this.getSpaceManager().setSubSpaceRights(space, subSpace, this.context);
        }
    }
}

