/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.DefaultXObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XClassManager;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.plexus.util.StringUtils;

public class XWikiServer
extends DefaultXObjectDocument {
    private static final String COMMA = ",";

    public XWikiServer(XWikiDocument xdoc, int objectId, XWikiContext context) throws XWikiException {
        super((XClassManager)XWikiServerClass.getInstance(context), xdoc, objectId, context);
    }

    public String getWikiName() {
        return this.sclass.getItemDefaultName(this.getFullName());
    }

    public void setWikiName(String wikiName) {
        this.getDoc().setFullName(this.sclass.getItemDocumentDefaultFullName(wikiName, this.context));
    }

    public String getWikiPrettyName() {
        return this.getStringValue("wikiprettyname");
    }

    public void setWikiPrettyName(String wikiPrettyName) {
        this.setStringValue("wikiprettyname", wikiPrettyName);
    }

    public String getOwner() {
        return this.getStringValue("owner");
    }

    public void setOwner(String owner) {
        this.setStringValue("owner", owner);
    }

    public String getDescription() {
        return this.getStringValue("description");
    }

    public void setDescription(String description) {
        this.setStringValue("description", description);
    }

    public String getServer() {
        return this.getStringValue("server");
    }

    public void setServer(String server) {
        this.setStringValue("server", server);
    }

    public String getVisibility() {
        return this.getStringValue("visibility");
    }

    public void setVisibility(String visibility) {
        this.setStringValue("visibility", visibility);
    }

    public String getWikiLanguage() {
        return this.getStringValue("language");
    }

    public void setWikiLanguage(String language) {
        this.setStringValue("language", language);
    }

    public String getState() {
        return this.getStringValue("state");
    }

    public void setState(String state) {
        this.setStringValue("state", state);
    }

    public boolean getSecure() {
        Boolean secure = this.getBooleanValue("secure");
        return secure != null && secure != false;
    }

    public void setSecure(boolean secure) {
        this.setBooleanValue("secure", secure);
    }

    public String getHomePage() {
        return this.getStringValue("homepage");
    }

    public void setHomePage(String homePage) {
        this.setStringValue("homepage", homePage);
    }

    public void setIsWikiTemplate(boolean isWikiTemplate) {
        this.setBooleanValue("iswikitemplate", isWikiTemplate);
    }

    public boolean isWikiTemplate() {
        return this.getBooleanValue("iswikitemplate");
    }

    public String toString() {
        return this.getFullName() + COMMA + this.getServer() + COMMA + this.getOwner();
    }

    public URL getServerUrl() throws MalformedURLException {
        return this.getServerUrl(null, null);
    }

    public URL getHomePageUrl() throws MalformedURLException {
        return this.getWikiUrl(this.getHomePage());
    }

    public URL getWikiUrl(String pageFullName) throws MalformedURLException {
        if (!StringUtils.isEmpty((String)pageFullName)) {
            XWikiDocument document = new XWikiDocument();
            document.setFullName(pageFullName);
            return this.getServerUrl(document.getSpace(), document.getName());
        }
        return this.getServerUrl(null, null);
    }

    public URL getServerUrl(String spaceName, String pageName) throws MalformedURLException {
        URL url = spaceName == null || pageName == null ? this.context.getWiki().getServerURL(this.getWikiName(), this.context) : this.context.getURLFactory().createURL(spaceName, pageName, "view", null, null, this.getWikiName(), this.context);
        return url;
    }
}

