/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.globalsearch;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearch;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchException;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchMessageTool;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchPlugin;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchQuery;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSearchPluginApi
extends PluginApi {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Log LOG = LogFactory.getLog(GlobalSearchPluginApi.class);
    private XWikiPluginMessageTool messageTool;
    private GlobalSearch search;

    public GlobalSearchPluginApi(GlobalSearchPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        Locale locale = (Locale)context.get((Object)"locale");
        this.messageTool = new GlobalSearchMessageTool(locale, plugin, context);
        context.put((Object)"globalsearchmessagetool", (Object)this.messageTool);
        this.search = new GlobalSearch(this.messageTool);
    }

    public GlobalSearchQuery newQuery() {
        return new GlobalSearchQuery();
    }

    public Collection<GlobalSearchResult> search(GlobalSearchQuery query) throws XWikiException {
        Collection<GlobalSearchResult> results;
        try {
            results = this.hasProgrammingRights() ? this.search.search(query, this.context) : Collections.emptyList();
        }
        catch (GlobalSearchException e) {
            LOG.error((Object)this.messageTool.get("globalsearch.plugin.log.searchdocuments"), (Throwable)((Object)e));
            this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)new Integer(e.getCode()));
            this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi((XWikiException)e, this.context));
            results = Collections.emptyList();
        }
        return results;
    }

    public Collection<Document> searchDocuments(GlobalSearchQuery query, boolean distinctbylanguage) throws XWikiException {
        List<Object> documentList;
        try {
            Collection<XWikiDocument> documents = this.search.searchDocuments(query, distinctbylanguage, false, true, this.context);
            documentList = new ArrayList<Document>(documents.size());
            for (XWikiDocument doc : documents) {
                documentList.add(doc.newDocument(this.context));
            }
        }
        catch (GlobalSearchException e) {
            LOG.error((Object)this.messageTool.get("globalsearch.plugin.log.searchdocuments"), (Throwable)((Object)e));
            this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)new Integer(e.getCode()));
            this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi((XWikiException)e, this.context));
            documentList = Collections.emptyList();
        }
        return documentList;
    }

    public Collection<String> searchDocumentsNames(GlobalSearchQuery query, boolean distinctbylanguage, boolean checkRight) throws XWikiException {
        Collection<String> results;
        try {
            results = this.search.searchDocumentsNames(query, distinctbylanguage, false, checkRight, this.context);
        }
        catch (GlobalSearchException e) {
            LOG.error((Object)this.messageTool.get("globalsearch.plugin.log.searchdocuments"), (Throwable)((Object)e));
            this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)new Integer(e.getCode()));
            this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi((XWikiException)e, this.context));
            results = Collections.emptyList();
        }
        return results;
    }
}

