/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.Wiki;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import com.xpn.xwiki.util.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WikiManager {
    protected static final Log LOG = LogFactory.getLog(WikiManager.class);
    private static WikiManager instance;

    private WikiManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiManager getInstance() {
        Class<WikiManager> clazz = WikiManager.class;
        synchronized (WikiManager.class) {
            if (instance == null) {
                instance = new WikiManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return WikiManagerMessageTool.getDefault(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument(String wikiName, XWikiDocument doc, String comment, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            context.getWiki().saveDocument(doc, comment, context);
        }
        finally {
            context.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiDocument getDocument(String wikiName, String fullname, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            XWikiDocument xWikiDocument = context.getWiki().getDocument(fullname, context);
            return xWikiDocument;
        }
        finally {
            context.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XWikiDocument> searchDocuments(String wikiName, String wheresql, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            List list = context.getWiki().getStore().searchDocuments(wheresql, context);
            return list;
        }
        finally {
            context.setDatabase(database);
        }
    }

    public Wiki getWikiFromDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        return new Wiki(document, context);
    }

    public Wiki getWikiFromName(String wikiName, XWikiContext context) throws XWikiException {
        return this.getWikiFromDocumentName(XWikiServerClass.getInstance(context).getItemDocumentDefaultFullName(wikiName, context), context);
    }

    public Wiki getWikiFromDocumentName(String documentFullName, XWikiContext context) throws XWikiException {
        return this.getWikiFromDocument(context.getWiki().getDocument(documentFullName, context), context);
    }

    public List<Wiki> getAllWikis(XWikiContext context) throws XWikiException {
        ArrayList<Wiki> wikiList = new ArrayList<Wiki>();
        ArrayList parameterValues = new ArrayList();
        String wheresql = XWikiServerClass.getInstance(context).createWhereClause(null, parameterValues);
        List documents = context.getWiki().getStore().searchDocuments(wheresql, parameterValues, context);
        for (XWikiDocument document : documents) {
            wikiList.add(new Wiki(document, context));
        }
        return wikiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection[] getDocsNames(String wiki, XWikiContext context) throws XWikiException {
        Collection[] docsNames = new Collection[2];
        ApplicationManagerPluginApi appmanager = (ApplicationManagerPluginApi)context.getWiki().getPluginApi("applicationmanager", context);
        if (appmanager == null) {
            return null;
        }
        String database = context.getDatabase();
        try {
            context.setDatabase(wiki);
            XWikiApplication rootApp = appmanager.getRootApplication();
            if (rootApp != null) {
                docsNames[0] = rootApp.getDocsNameToInclude(true);
                docsNames[1] = rootApp.getDocsNameToLink(true);
            } else {
                List applications = appmanager.getApplicationDocumentList();
                docsNames[0] = XWikiApplication.getDocsNameToInclude((Collection)applications);
                docsNames[1] = XWikiApplication.getDocsNameToLink((Collection)applications);
            }
        }
        finally {
            context.setDatabase(database);
        }
        return docsNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWiki(String sourceWiki, String targetWiki, String language, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        xwiki.copyWikiWeb(null, sourceWiki, targetWiki, language, true, context);
        String database = context.getDatabase();
        try {
            context.setDatabase(targetWiki);
            Collection[] docsNames = this.getDocsNames(sourceWiki, context);
            Object[] includeFormatParams = new Object[]{sourceWiki, ":", null};
            Collection docsNameToInclude = docsNames[0];
            for (Object item : docsNameToInclude) {
                String docFullName = (String)item;
                XWikiDocument targetDoc = xwiki.getDocument(docFullName, context);
                includeFormatParams[2] = docFullName;
                targetDoc.setContent(MessageFormat.format("#includeInContext(\"{0}{1}{2}\")", includeFormatParams));
            }
            Collection docsNameToLink = docsNames[1];
            for (Object item : docsNameToLink) {
                String docFullName = (String)item;
                XWikiDocument targetDoc = xwiki.getDocument(docFullName, context);
                includeFormatParams[2] = docFullName;
                targetDoc.setContent(MessageFormat.format("#includeTopic(\"{0}{1}{2}\")", includeFormatParams));
            }
        }
        finally {
            context.setDatabase(database);
        }
    }

    public XWikiServer createNewWikiFromPackage(XWikiServer userWikiSuperDoc, String packageName, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, null, packageName, comment, context);
    }

    public XWikiServer createNewWikiFromTemplate(XWikiServer userWikiSuperDoc, String templateWikiName, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, templateWikiName, null, comment, context);
    }

    public XWikiServer createNewWiki(XWikiServer userWikiSuperDoc, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, null, null, comment, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiServer createNewWiki(XWikiServer userWikiSuperDoc, boolean failOnExist, String templateWikiName, String packageName, String comment, XWikiContext context) throws XWikiException {
        XWikiPluginMessageTool msg = this.getMessageTool(context);
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, msg.get("wikimanager.plugin.error.xwikinotvirtual"));
        }
        String newWikiName = userWikiSuperDoc.getWikiName();
        String database = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            XWikiDocument userdoc = this.getDocument(xwiki.getDatabase(), userWikiSuperDoc.getOwner(), context);
            if (userdoc.isNew()) {
                throw new WikiManagerException(50091, msg.get("wikimanager.plugin.error.userdoesnotexists", userWikiSuperDoc.getOwner()));
            }
            String wikiForbiddenList = xwiki.Param("xwiki.virtual.reserved_wikis");
            if (Util.contains((String)newWikiName, (String)wikiForbiddenList, (String)", ")) {
                throw new WikiManagerException(50036, msg.get("wikimanager.plugin.error.wikinameforbidden", newWikiName));
            }
            XWikiServer wikiSuperDocToSave = this.getWikiDescriptorToSave(userWikiSuperDoc, failOnExist, context);
            this.createWikiDatabase(newWikiName, context);
            String language = userWikiSuperDoc.getLanguage();
            if (language.length() == 0) {
                language = null;
            }
            if (templateWikiName != null) {
                this.copyWiki(templateWikiName, newWikiName, language, comment, context);
            }
            if (packageName != null) {
                this.importPackage(packageName, newWikiName, context);
            }
            context.setDatabase(context.getMainXWiki());
            wikiSuperDocToSave.save(comment);
            XWikiServer xWikiServer = wikiSuperDocToSave;
            return xWikiServer;
        }
        finally {
            context.setDatabase(database);
        }
    }

    private XWikiServer getWikiDescriptorToSave(XWikiServer userWikiSuperDoc, boolean failOnExist, XWikiContext context) throws XWikiException {
        XWikiServer wikiSuperDocToSave;
        XWikiPluginMessageTool msg = this.getMessageTool(context);
        XWiki xwiki = context.getWiki();
        XWikiServerClass wikiClass = XWikiServerClass.getInstance(context);
        if (!userWikiSuperDoc.isFromCache()) {
            XWikiDocument docToSave = this.getDocument(context.getMainXWiki(), userWikiSuperDoc.getFullName(), context);
            if (!docToSave.isNew() && wikiClass.isInstance(docToSave)) {
                if (failOnExist) {
                    throw new WikiManagerException(50033, msg.get("wikimanager.plugin.error.descriptoralreadyexists", userWikiSuperDoc.getFullName()));
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)msg.get("wikimanager.plugin.log.createwiki.descriptoralreadyexists", userWikiSuperDoc.toString()));
                }
            }
            if (!(wikiSuperDocToSave = (XWikiServer)wikiClass.newXObjectDocument(docToSave, 0, context)).getServer().equals(userWikiSuperDoc.getServer())) {
                xwiki.getVirtualWikiMap().flushEntry(userWikiSuperDoc.getServer());
            }
            wikiSuperDocToSave.mergeObject(userWikiSuperDoc);
        } else {
            wikiSuperDocToSave = userWikiSuperDoc;
        }
        return wikiSuperDocToSave;
    }

    private void createWikiDatabase(String targetWiki, XWikiContext context) throws WikiManagerException {
        XWikiPluginMessageTool msg = this.getMessageTool(context);
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, msg.get("wikimanager.plugin.error.xwikinotvirtual"));
        }
        try {
            xwiki.getStore().createWiki(targetWiki, context);
        }
        catch (Exception e) {
            LOG.warn((Object)msg.get("wikimanager.plugin.log.createwiki.databasecreationexception", targetWiki), (Throwable)e);
        }
        try {
            xwiki.updateDatabase(targetWiki, true, context);
        }
        catch (Exception e) {
            throw new WikiManagerException(50035, msg.get("wikimanager.plugin.error.updatedatabase", targetWiki), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPackage(String packageName, String targetWiki, XWikiContext context) throws XWikiException {
        XWikiPluginMessageTool msg = this.getMessageTool(context);
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, msg.get("wikimanager.plugin.error.xwikinotvirtual"));
        }
        XWikiDocument doc = context.getDoc();
        XWikiAttachment packFile = doc.getAttachment(packageName);
        if (packFile == null) {
            throw new WikiManagerException(50038, msg.get("wikimanager.plugin.error.packagedoesnotexists", packageName));
        }
        PackageAPI importer = (PackageAPI)context.getWiki().getPluginApi("package", context);
        String database = context.getDatabase();
        try {
            context.setDatabase(targetWiki);
            try {
                importer.Import(packFile.getContent(context));
            }
            catch (IOException e) {
                throw new WikiManagerException(50039, msg.get("wikimanager.plugin.error.packageimport", packageName), e);
            }
            if (importer.install() == 0) {
                throw new WikiManagerException(50040, msg.get("wikimanager.plugin.error.packageinstall", packageName));
            }
        }
        finally {
            context.setDatabase(database);
        }
    }

    public void deleteWiki(String wikiNameToDelete, boolean deleteDatabase, XWikiContext context) throws XWikiException {
        Wiki wiki = this.getWikiFromName(wikiNameToDelete, context);
        if (!XWikiServerClass.getInstance(context).isInstance(wiki)) {
            throw new WikiManagerException(50034, this.getMessageTool(context).get("wikimanager.plugin.error.wikidoesnotexists", wikiNameToDelete));
        }
        wiki.delete(deleteDatabase);
    }

    public void deleteWikiAlias(String wikiNameToDelete, int objectId, XWikiContext context) throws XWikiException {
        Wiki wiki = this.getWikiFromName(wikiNameToDelete, context);
        XWikiServer alias = wiki.getWikiAlias(objectId);
        if (wiki.countWikiAliases() == 1) {
            wiki.delete(true);
        } else {
            alias.delete();
        }
    }

    public XWikiServer getWikiAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).getWikiAlias(wikiName, objectId, validate, context);
    }

    public List getWikiAliasList(XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).searchXObjectDocuments(context);
    }

    public boolean isWikiAliasExist(String wikiName, int objectId, XWikiContext context) {
        try {
            return this.getWikiAlias(wikiName, objectId, true, context) != null;
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public XWikiServer getWikiTemplateAlias(String wikiName, int objectId, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiServerClass.getInstance(context).getWikiTemplateAlias(wikiName, objectId, validate, context);
    }

    public List getWikiTemplateAliasList(XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).searchXObjectDocumentsByField("iswikitemplate", 1, "IntegerProperty", context);
    }

    public void createWikiTemplate(XWikiServer wikiXObjectDocument, String packageName, String comment, XWikiContext context) throws XWikiException {
        wikiXObjectDocument.setIsWikiTemplate(true);
        this.createNewWikiFromPackage(wikiXObjectDocument, packageName, false, comment, context);
    }
}

