/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.AbstractXClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocument;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocumentDoesNotExistException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;

public class XWikiServerClass
extends AbstractXClassManager {
    public static final String DEFAULT_FIELDS = "|";
    public static final String FIELD_WIKIPRETTYNAME = "wikiprettyname";
    public static final String FIELDPN_WIKIPRETTYNAME = "Wiki pretty name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELDPN_OWNER = "Owner";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELDPN_DESCRIPTION = "Description";
    public static final String FIELD_SERVER = "server";
    public static final String FIELDPN_SERVER = "Server";
    public static final String FIELD_VISIBILITY = "visibility";
    public static final String FIELDL_VISIBILITY_PUBLIC = "public";
    public static final String FIELDL_VISIBILITY_PRIVATE = "private";
    public static final String FIELDL_VISIBILITY = "public|private|";
    public static final String FIELDPN_VISIBILITY = "Visibility";
    public static final String FIELD_STATE = "state";
    public static final String FIELDL_STATE_ACTIVE = "active";
    public static final String FIELDL_STATE_INACTIVE = "inactive";
    public static final String FIELDL_STATE_LOCKED = "locked";
    public static final String FIELDL_STATE = "active|inactive|locked";
    public static final String FIELDPN_STATE = "State";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELDL_LANGUAGE = "en|fr";
    public static final String FIELDPN_LANGUAGE = "Language";
    public static final String FIELD_SECURE = "secure";
    public static final String FIELDPN_SECURE = "Secure";
    public static final String FIELDDT_SECURE = "checkbox";
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELDPN_HOMEPAGE = "Home page";
    public static final String FIELD_ISWIKITEMPLATE = "iswikitemplate";
    public static final String FIELDPN_ISWIKITEMPLATE = "Template";
    public static final String FIELDDT_ISWIKITEMPLATE = "checkbox";
    public static final String DEFAULT_PAGE_PARENT = "WikiManager.WebHome";
    public static final String DEFAULT_WIKI_HOMEPAGE = "Main.WebHome";
    private static final String CLASS_SPACE = "XWiki";
    private static final String CLASS_PREFIX = "XWikiServer";
    private static XWikiServerClass instance;

    protected XWikiServerClass() {
        super(CLASS_SPACE, CLASS_PREFIX, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XWikiServerClass getInstance(XWikiContext context) throws XWikiException {
        Class<XWikiServerClass> clazz = XWikiServerClass.class;
        synchronized (XWikiServerClass.class) {
            if (instance == null) {
                instance = new XWikiServerClass();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            instance.check(context);
            return instance;
        }
    }

    protected boolean updateBaseClass(BaseClass baseClass) {
        boolean needsUpdate = super.updateBaseClass(baseClass);
        baseClass.setName(this.getClassFullName());
        needsUpdate |= baseClass.addTextField(FIELD_WIKIPRETTYNAME, FIELDPN_WIKIPRETTYNAME, 30);
        needsUpdate |= baseClass.addUsersField(FIELD_OWNER, FIELDPN_OWNER, false);
        needsUpdate |= baseClass.addTextAreaField(FIELD_DESCRIPTION, FIELDPN_DESCRIPTION, 40, 5);
        needsUpdate |= baseClass.addTextField(FIELD_SERVER, FIELDPN_SERVER, 30);
        needsUpdate |= baseClass.addStaticListField(FIELD_VISIBILITY, FIELDPN_VISIBILITY, FIELDL_VISIBILITY);
        needsUpdate |= baseClass.addStaticListField(FIELD_STATE, FIELDPN_STATE, FIELDL_STATE);
        needsUpdate |= baseClass.addStaticListField(FIELD_LANGUAGE, FIELDPN_LANGUAGE, FIELDL_LANGUAGE);
        needsUpdate |= baseClass.addBooleanField(FIELD_SECURE, FIELDPN_SECURE, "checkbox");
        needsUpdate |= baseClass.addTextField(FIELD_HOMEPAGE, FIELDPN_HOMEPAGE, 30);
        return needsUpdate |= baseClass.addBooleanField(FIELD_ISWIKITEMPLATE, FIELDPN_ISWIKITEMPLATE, "checkbox");
    }

    protected boolean updateClassTemplateDocument(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (!DEFAULT_PAGE_PARENT.equals(doc.getParent())) {
            doc.setParent(DEFAULT_PAGE_PARENT);
            needsUpdate = true;
        }
        if (!DEFAULT_WIKI_HOMEPAGE.equals(doc.getStringValue(this.getClassFullName(), FIELD_HOMEPAGE))) {
            doc.setStringValue(this.getClassFullName(), FIELD_HOMEPAGE, DEFAULT_WIKI_HOMEPAGE);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    public XWikiServer getWikiAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        try {
            return (XWikiServer)this.getXObjectDocument(wikiName, objectId, validate, context);
        }
        catch (XObjectDocumentDoesNotExistException e) {
            throw new WikiManagerException(50034, WikiManagerMessageTool.getDefault(context).get("wikimanager.plugin.error.wikialiasdoesnotexists", wikiName), e);
        }
    }

    public XWikiServer getWikiTemplateAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        XWikiServer wiki = this.getWikiAlias(wikiName, objectId, validate, context);
        if (validate && !wiki.isWikiTemplate()) {
            throw new WikiManagerException(50034, WikiManagerMessageTool.getDefault(context).get("wikimanager.plugin.error.wikitemplatealiasdoesnotexists", wikiName));
        }
        return wiki;
    }

    public XObjectDocument newXObjectDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return new XWikiServer(doc, objId, context);
    }
}

