/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.xar;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class XarMojo
extends AbstractMojo {
    private MavenProject project;
    protected ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getResources().size() < 1) {
            this.getLog().warn((CharSequence)"No XAR created as no resources were found");
            return;
        }
        try {
            this.performArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating XAR file", e);
        }
    }

    private void performArchive() throws ArchiverException, IOException, MojoExecutionException {
        File xarFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + ".xar");
        File sourceDir = new File(this.project.getBuild().getOutputDirectory());
        ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(xarFile);
        archiver.setIncludeEmptyDirs(false);
        archiver.setCompress(true);
        this.unpackDependentXars();
        archiver.addDirectory(sourceDir);
        if (archiver.getFiles().get("package.xml") == null) {
            File generatedPackageFile = new File(sourceDir, "package.xml");
            this.generatePackageXml(generatedPackageFile, archiver.getFiles().keySet());
            archiver.addFile(generatedPackageFile, "package.xml");
        }
        archiver.createArchive();
        this.project.getArtifact().setFile(xarFile);
    }

    private void generatePackageXml(File packageFile, Set files) throws IOException {
        this.getLog().info((CharSequence)("Generating package.xml descriptor at [" + packageFile.getPath() + "]"));
        FileWriter fw = new FileWriter(packageFile);
        fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        fw.write("<package>\n");
        fw.write("  <infos>\n");
        fw.write("    <name>" + this.project.getName() + "</name>\n");
        fw.write("    <description>" + this.project.getDescription() + "</description>\n");
        fw.write("    <licence></licence>\n");
        fw.write("    <author>XWiki.Admin</author>\n");
        fw.write("    <version>" + this.project.getVersion() + "</version>\n");
        fw.write("    <backupPack>true</backupPack>\n");
        fw.write("  </infos>\n");
        fw.write("  <files>\n");
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            StringTokenizer st = new StringTokenizer(fileName, "/");
            if (st.countTokens() != 2) {
                this.getLog().warn((CharSequence)("Invalid file location [" + fileName + "], skipping it."));
                continue;
            }
            fw.write("    <file defaultAction=\"0\" language=\"\">" + st.nextToken() + "." + st.nextToken() + "</file>\n");
        }
        fw.write("  </files>\n");
        fw.write("</package>\n");
        fw.close();
    }

    private void unpackDependentXars() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"xar".equals(type = artifact.getType())) continue;
            this.unpackXarToOutputDirectory(artifact);
        }
    }

    private void unpackXarToOutputDirectory(Artifact artifact) throws MojoExecutionException {
        File outputLocation = new File(this.project.getBuild().getOutputDirectory());
        if (!outputLocation.exists()) {
            outputLocation.mkdirs();
        }
        File file = artifact.getFile();
        try {
            this.unpack(file, outputLocation);
        }
        catch (NoSuchArchiverException e) {
            this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
        }
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        try {
            ZipUnArchiver unArchiver = new ZipUnArchiver();
            unArchiver.enableLogging((Logger)new ConsoleLogger(3, "XarMojo"));
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.setOverwrite(true);
            ArrayList<1> filters = new ArrayList<1>();
            filters.add(new ArchiveFileFilter(){

                public boolean include(InputStream dataStream, String entryName) {
                    return !entryName.equals("package.xml");
                }
            });
            unArchiver.setArchiveFilters(filters);
            unArchiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error unpacking file [" + file + "] to [" + location + "]", e);
        }
    }
}

