/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.xar;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class UnXarMojo
extends AbstractMojo {
    private MavenProject project;
    private String groupId;
    private String artifactId;
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        try {
            this.performUnArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while expanding the XAR file [" + this.groupId + ":" + this.artifactId + "]", e);
        }
    }

    private Artifact findArtifact() throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        this.getLog().debug((CharSequence)("Searching for an artifact that matches [" + this.groupId + ":" + this.artifactId + "]..."));
        Iterator it = this.project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Checking artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + "]..."));
            if (!artifact.getGroupId().equals(this.groupId) || !artifact.getArtifactId().equals(this.artifactId)) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException("Artifact [" + this.groupId + ":" + this.artifactId + "] is not a dependency of the project.");
        }
        return resolvedArtifact;
    }

    private void performUnArchive() throws ArchiverException, IOException, MojoExecutionException {
        Artifact artifact = this.findArtifact();
        this.getLog().debug((CharSequence)("Source XAR = [" + artifact.getFile() + "]"));
        ZipUnArchiver unArchiver = new ZipUnArchiver();
        unArchiver.setSourceFile(artifact.getFile());
        unArchiver.setDestFile(this.outputDirectory);
        unArchiver.enableLogging((Logger)new ConsoleLogger(3, "UnXarMojo"));
        unArchiver.extract();
    }
}

