/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URI;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.resources.BaseAttachmentsResource;

@Component(value="org.xwiki.rest.resources.attachments.AttachmentResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments/{attachmentName}")
public class AttachmentResource
extends BaseAttachmentsResource {
    @GET
    public Response getAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Attachment xwikiAttachment = doc.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok().type(xwikiAttachment.getMimeType()).entity((Object)xwikiAttachment.getContent()).build();
    }

    @PUT
    public Response putAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName, byte[] content) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        attachmentName = Utils.getXWikiContext(this.componentManager).getWiki().clearName(attachmentName, false, true, Utils.getXWikiContext(this.componentManager));
        BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAttachment(doc, attachmentName, content);
        if (attachmentInfo.isAlreadyExisting()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
        }
        return Response.created((URI)this.uriInfo.getAbsolutePath()).entity((Object)attachmentInfo.getAttachment()).build();
    }

    @DELETE
    public void deleteAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Attachment xwikiAttachment = doc.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(this.componentManager));
        XWikiAttachment baseXWikiAttachment = xwikiDocument.getAttachment(attachmentName);
        xwikiDocument.deleteAttachment(baseXWikiAttachment, Utils.getXWikiContext(this.componentManager));
        Utils.getXWiki(this.componentManager).saveDocument(xwikiDocument, Utils.getXWikiContext(this.componentManager));
    }
}

