/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.BaseAttachmentsResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;

@Component(value="org.xwiki.rest.resources.attachments.AttachmentsResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments")
public class AttachmentsResource
extends BaseAttachmentsResource {
    private static String FORM_FILENAME_FIELD = "filename";

    @GET
    public Attachments getAttachments(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        return this.getAttachmentsForDocument(doc, start, number);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response addAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, Multipart multipart) throws MessagingException, IOException, XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String attachmentName = null;
        String actualFileName = null;
        String overriddenFileName = null;
        String contentType = null;
        InputStream inputStream = null;
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            Enumeration e = bodyPart.getMatchingHeaders(new String[]{"Content-disposition"});
            while (e.hasMoreElements()) {
                String[] fieldData;
                Header h = (Header)e.nextElement();
                if (!h.getValue().startsWith("form-data")) continue;
                for (String s : fieldData = h.getValue().split(";")) {
                    String[] pair = s.split("=");
                    if (pair.length != 2) continue;
                    String key = pair[0].trim();
                    String value = pair[1].replace("\"", "").trim();
                    if ("name".equals(key)) {
                        if (!FORM_FILENAME_FIELD.equals(value)) continue;
                        overriddenFileName = bodyPart.getContent().toString();
                        continue;
                    }
                    if (!"filename".equals(key)) continue;
                    actualFileName = value;
                    contentType = bodyPart.getContentType();
                    inputStream = bodyPart.getInputStream();
                }
            }
        }
        attachmentName = overriddenFileName != null ? overriddenFileName : actualFileName;
        if (attachmentName == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        attachmentName = Utils.getXWikiContext(this.componentManager).getWiki().clearName(attachmentName, false, true, Utils.getXWikiContext(this.componentManager));
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int read;
            if ((read = inputStream.read(buffer)) != 4096) {
                if (read == -1) break;
                baos.write(buffer, 0, read);
                break;
            }
            baos.write(buffer);
        }
        baos.flush();
        BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAttachment(doc, attachmentName, baos.toByteArray());
        if (attachmentInfo.isAlreadyExisting()) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
        }
        return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(AttachmentResource.class).build(new Object[]{wikiName, spaceName, pageName, attachmentName})).entity((Object)attachmentInfo.getAttachment()).build();
    }
}

