/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.Utils;
import org.xwiki.rest.model.jaxb.ObjectFactory;

public class XWikiResource {
    protected XWikiContext xwikiContext = (XWikiContext)org.restlet.Context.getCurrent().getAttributes().get("xwikiContext");
    protected com.xpn.xwiki.XWiki xwiki = (com.xpn.xwiki.XWiki)org.restlet.Context.getCurrent().getAttributes().get("xwiki");
    protected XWiki xwikiApi = (XWiki)org.restlet.Context.getCurrent().getAttributes().get("xwikiApi");
    protected String xwikiUser = (String)org.restlet.Context.getCurrent().getAttributes().get("xwikiUser");
    @Context
    protected UriInfo uriInfo;
    protected Logger logger;
    protected ObjectFactory objectFactory;
    protected QueryManager queryManager = (QueryManager)com.xpn.xwiki.web.Utils.getComponent(QueryManager.class);

    public XWikiResource() {
        if (this.xwikiContext == null || this.xwiki == null || this.xwikiApi == null || this.xwikiUser == null || this.queryManager == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.logger = Logger.getLogger(this.getClass().getName());
        this.objectFactory = new ObjectFactory();
        this.logger.log(Level.FINE, String.format("Resource %s initialized. Serving user: '%s'\n", this.getClass().getName(), this.xwikiUser));
    }

    public DocumentInfo getDocumentInfo(String wikiName, String spaceName, String pageName, String language, String version, boolean failIfDoesntExist, boolean failIfLocked) throws XWikiException {
        if (wikiName == null || spaceName == null || pageName == null) {
            throw new IllegalArgumentException(String.format("wikiName, spaceName and pageName must all be not null. Current values: (%s:%s.%s)", wikiName, spaceName, pageName));
        }
        String pageFullName = Utils.getPageId(wikiName, spaceName, pageName);
        boolean existed = this.xwikiApi.exists(pageFullName);
        if (failIfDoesntExist && !existed) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Document doc = this.xwikiApi.getDocument(pageFullName);
        if (doc == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (language != null && !language.equals((doc = doc.getTranslatedDocument(language)).getLanguage())) {
            if (failIfDoesntExist) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            XWikiDocument xwikiDocument = new XWikiDocument(spaceName, pageName);
            xwikiDocument.setDatabase(wikiName);
            xwikiDocument.setLanguage(language);
            doc = new Document(xwikiDocument, this.xwikiContext);
            existed = false;
        }
        if (version != null) {
            doc = doc.getDocumentRevision(version);
        }
        if (failIfLocked && doc.getLocked()) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return new DocumentInfo(doc, !existed);
    }

    @GET
    @Produces(value={"uritemplate"})
    public String getUriTemplate() {
        return this.getClass().getAnnotation(Path.class).value();
    }

    protected static class DocumentInfo {
        private Document document;
        private boolean created;

        public DocumentInfo(Document document, boolean created) {
            this.document = document;
            this.created = created;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

