/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.net.URL;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.pages.PageResource;

@Path(value="/wikis/{wikiName}/attachments")
public class BaseAttachmentsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachments getAttachments(String wikiName, String name, String page, String space, String author, String types, Integer start, Integer number) throws QueryException {
        String database = this.xwikiContext.getDatabase();
        Attachments attachments = this.objectFactory.createAttachments();
        try {
            this.xwikiContext.setDatabase(wikiName);
            HashMap<String, String> filters = new HashMap<String, String>();
            if (!name.equals("")) {
                filters.put("name", name);
            }
            if (!page.equals("")) {
                filters.put("page", name);
            }
            if (!space.equals("")) {
                filters.put("space", space);
            }
            if (!author.equals("")) {
                filters.put("author", author);
            }
            Formatter f = new Formatter();
            f.format("select doc.space, doc.name, doc.version, attachment from XWikiDocument as doc, XWikiAttachment as attachment where (attachment.docId=doc.id ", new Object[0]);
            if (filters.keySet().size() > 0) {
                for (String param : filters.keySet()) {
                    if (param.equals("name")) {
                        f.format(" and upper(attachment.filename) like :name ", new Object[0]);
                    }
                    if (param.equals("page")) {
                        f.format(" and upper(doc.fullName) like :page ", new Object[0]);
                    }
                    if (param.equals("space")) {
                        f.format(" and upper(doc.space) like :space ", new Object[0]);
                    }
                    if (!param.equals("author")) continue;
                    f.format(" and upper(attachment.author) like :author ", new Object[0]);
                }
            }
            f.format(")", new Object[0]);
            String queryString = f.toString();
            QueryManager queryManager = (QueryManager)com.xpn.xwiki.web.Utils.getComponent(QueryManager.class);
            Query query = queryManager.createQuery(queryString, "xwql").setLimit(number.intValue()).setOffset(start.intValue());
            for (String param : filters.keySet()) {
                query.bindValue(param, (Object)String.format("%%%s%%", ((String)filters.get(param)).toUpperCase()));
            }
            List queryResult = null;
            queryResult = query.execute();
            HashSet<String> acceptedMimeTypes = new HashSet<String>();
            if (!types.equals("")) {
                String[] acceptedMimetypesArray;
                for (String type : acceptedMimetypesArray = types.split(",")) {
                    acceptedMimeTypes.add(type);
                }
            }
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String pageSpace = (String)fields[0];
                String pageName = (String)fields[1];
                String pageId = Utils.getPageId(wikiName, pageSpace, pageName);
                String pageVersion = (String)fields[2];
                XWikiAttachment xwikiAttachment = (XWikiAttachment)fields[3];
                String mimeType = xwikiAttachment.getMimeType(this.xwikiContext);
                boolean add = true;
                if (acceptedMimeTypes.size() > 0) {
                    add = false;
                    for (String type : acceptedMimeTypes) {
                        if (!mimeType.toUpperCase().contains(type.toUpperCase())) continue;
                        add = true;
                        break;
                    }
                }
                if (!add) continue;
                Attachment attachment = this.objectFactory.createAttachment();
                attachment.setId(String.format("%s@%s", pageId, xwikiAttachment.getFilename()));
                attachment.setName(xwikiAttachment.getFilename());
                attachment.setSize(xwikiAttachment.getFilesize());
                attachment.setMimeType(mimeType);
                attachment.setAuthor(xwikiAttachment.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(xwikiAttachment.getDate());
                attachment.setDate(calendar);
                attachment.setPageId(pageId);
                attachment.setPageVersion(pageVersion);
                attachment.setVersion(xwikiAttachment.getVersion());
                URL absoluteUrl = this.xwikiContext.getURLFactory().createAttachmentURL(xwikiAttachment.getFilename(), pageSpace, pageName, "download", null, wikiName, this.xwikiContext);
                attachment.setXwikiAbsoluteUrl(absoluteUrl.toString());
                attachment.setXwikiRelativeUrl(this.xwikiContext.getURLFactory().getURL(absoluteUrl, this.xwikiContext));
                String baseUri = this.uriInfo.getBaseUri().toString();
                String pageUri = UriBuilder.fromUri((String)baseUri).path(PageResource.class).build(new Object[]{wikiName, pageSpace, pageName}).toString();
                Link pageLink = this.objectFactory.createLink();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                attachment.getLinks().add(pageLink);
                String attachmentUri = UriBuilder.fromUri((String)baseUri).path(AttachmentResource.class).build(new Object[]{wikiName, pageSpace, pageName, xwikiAttachment.getFilename()}).toString();
                Link attachmentLink = this.objectFactory.createLink();
                attachmentLink.setHref(attachmentUri);
                attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
                attachment.getLinks().add(attachmentLink);
                attachments.getAttachments().add(attachment);
            }
        }
        finally {
            this.xwikiContext.setDatabase(database);
        }
        return attachments;
    }
}

