/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.web.Utils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;

@Path(value="/wikis/{wikiName}/modifications")
public class ModificationsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public History getModifications(@PathParam(value="wikiName") String wikiName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="25") Integer number, @QueryParam(value="order") @DefaultValue(value="desc") String order, @QueryParam(value="date") @DefaultValue(value="0") Long ts) throws XWikiException, QueryException {
        String database = this.xwikiContext.getDatabase();
        History history = new History();
        try {
            this.xwikiContext.setDatabase(wikiName);
            String query = String.format("select doc.space, doc.name, doc.language, rcs.id, rcs.date, rcs.author from XWikiRCSNodeInfo as rcs, XWikiDocument as doc where rcs.id.docId=doc.id and rcs.date > :date order by rcs.date %s, rcs.id.version1 %s, rcs.id.version2 %s", order, order, order);
            QueryManager queryManager = (QueryManager)Utils.getComponent(QueryManager.class);
            List queryResult = null;
            queryResult = queryManager.createQuery(query, "xwql").bindValue("date", (Object)new Date(ts)).setLimit(number.intValue()).setOffset(start.intValue()).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[0];
                String pageName = (String)fields[1];
                String language = (String)fields[2];
                if (language.equals("")) {
                    language = null;
                }
                XWikiRCSNodeId nodeId = (XWikiRCSNodeId)fields[3];
                Timestamp timestamp = (Timestamp)fields[4];
                Date modified = new Date(timestamp.getTime());
                String modifier = (String)fields[5];
                HistorySummary historySummary = DomainObjectFactory.createHistorySummary(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaceName, pageName, language, nodeId.getVersion(), modifier, modified);
                history.getHistorySummaries().add(historySummary);
            }
        }
        finally {
            this.xwikiContext.setDatabase(database);
        }
        return history;
    }
}

