/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.pages.ModifiablePageResource;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/tags")
public class PageTagsResource
extends ModifiablePageResource {
    @GET
    public Tags getPageTags(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName) throws XWikiException {
        String pageId = Utils.getPageId(wikiName, spaceName, pageName);
        List<String> tagNames = this.getTagsFromDocument(pageId);
        Tags tags = this.objectFactory.createTags();
        for (String tagName : tagNames) {
            Tag tag = this.objectFactory.createTag();
            tag.setName(tagName);
            String tagUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PagesForTagsResource.class).build(new Object[]{wikiName, tagName}).toString();
            Link tagLink = this.objectFactory.createLink();
            tagLink.setHref(tagUri);
            tagLink.setRel("http://www.xwiki.org/rel/tag");
            tag.getLinks().add(tagLink);
            tags.getTags().add(tag);
        }
        return tags;
    }

    @PUT
    public Response setTags(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, Tags tags) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", this.xwikiUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Tag tag : tags.getTags()) {
            tagNames.add(tag.getName());
        }
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        BaseObject xwikiObject = xwikiDocument.getObject("XWiki.TagClass", 0);
        if (xwikiObject == null) {
            int objectNumber = xwikiDocument.createNewObject("XWiki.TagClass", this.xwikiContext);
            xwikiObject = xwikiDocument.getObject("XWiki.TagClass", objectNumber);
            if (xwikiObject == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            BaseClass xwikiClass = this.xwiki.getClass(xwikiObject.getClassName(), this.xwikiContext);
            String[] arr$ = xwikiClass.getPropertyNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String propertyNameObject;
                String propertyName = propertyNameObject = arr$[i$];
                xwikiObject.set(propertyName, (Object)"", this.xwikiContext);
            }
        }
        xwikiObject.set("tags", tagNames, this.xwikiContext);
        doc.save();
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)tags).build();
    }

    private List<String> getTagsFromDocument(String documentId) throws XWikiException {
        BaseProperty prop;
        XWikiDocument document = this.xwiki.getDocument(documentId, this.xwikiContext);
        BaseObject object = document.getObject("XWiki.TagClass");
        if (object != null && (prop = (BaseProperty)object.safeget("tags")) != null) {
            return (List)prop.getValue();
        }
        return new ArrayList<String>();
    }
}

