/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.query.QueryException;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Pages;

@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages")
public class PagesResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Pages getPages(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number, @QueryParam(value="parentId") String parentFilterExpression) throws XWikiException, QueryException {
        String database = this.xwikiContext.getDatabase();
        Pages pages = this.objectFactory.createPages();
        try {
            this.xwikiContext.setDatabase(wikiName);
            List pageNames = this.queryManager.getNamedQuery("getSpaceDocsName").bindValue("space", (Object)spaceName).setOffset(start.intValue()).setLimit(number.intValue()).execute();
            Pattern parentFilter = null;
            if (parentFilterExpression != null) {
                parentFilter = parentFilterExpression.equals("null") ? Pattern.compile("") : Pattern.compile(parentFilterExpression);
            }
            for (String pageName : pageNames) {
                String pageFullName = Utils.getPageId(wikiName, spaceName, pageName);
                if (!this.xwikiApi.exists(pageFullName)) {
                    this.logger.warning(String.format("[Page '%s' appears to be in space '%s' but no information is available.]", pageName, spaceName));
                    continue;
                }
                Document doc = this.xwikiApi.getDocument(pageFullName);
                if (doc == null) continue;
                boolean add = true;
                Document parent = Utils.getParentDocument(doc, this.xwikiApi);
                if (parentFilter != null) {
                    String parentId = "";
                    if (parent != null && !parent.isNew()) {
                        parentId = parent.getPrefixedFullName();
                    }
                    add = parentFilter.matcher(parentId).matches();
                }
                if (!add) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, this.xwikiApi));
            }
        }
        finally {
            this.xwikiContext.setDatabase(database);
        }
        return pages;
    }
}

