/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.XWikiRestComponent;

public class XWikiSetupCleanupFilter
extends Filter {
    protected int beforeHandle(Request request, Response response) {
        this.getContext().getAttributes().put("httpRequest", XWikiSetupCleanupFilter.getHttpRequest(request));
        return 0;
    }

    protected void afterHandle(Request request, Response response) {
        ConcurrentMap attributes = this.getContext().getAttributes();
        ComponentManager componentManager = (ComponentManager)attributes.get("xwikiComponentManager");
        List releasableComponents = (List)attributes.get("currentComponentReference");
        if (releasableComponents != null) {
            for (XWikiRestComponent component : releasableComponents) {
                try {
                    componentManager.release((Object)component);
                }
                catch (ComponentLifecycleException e) {
                    this.getLogger().log(Level.WARNING, String.format("Unable to release component %s. (%s)", component.getClass().getName(), e.getMessage()));
                }
            }
        }
        if (response.getEntity() != null && !response.getEntity().isAvailable()) {
            response.setEntity(null);
        }
    }

    protected static HttpServletRequest getHttpRequest(Request req) {
        HttpRequest httpRequest;
        HttpCall httpCall;
        if (req instanceof HttpRequest && (httpCall = (httpRequest = (HttpRequest)req).getHttpCall()) instanceof ServletCall) {
            return ((ServletCall)httpCall).getRequest();
        }
        return null;
    }
}

