/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.gwt.api.client.widgets;

import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class WordListSuggestOracle
extends SuggestOracle {
    protected SuggestOracle wordOracle;
    protected String separators;
    protected boolean suggestUnique;

    public WordListSuggestOracle() {
        this((SuggestOracle)new MultiWordSuggestOracle(), " ", false);
    }

    public WordListSuggestOracle(SuggestOracle wordOracle) {
        this(wordOracle, " ", false);
    }

    public WordListSuggestOracle(SuggestOracle wordOracle, String separators) {
        this(wordOracle, separators, false);
    }

    public WordListSuggestOracle(SuggestOracle wordOracle, String separators, boolean suggestUnique) {
        this.setWordOracle(wordOracle);
        this.setSeparators(separators);
        this.setSuggestUnique(suggestUnique);
    }

    public void requestSuggestions(SuggestOracle.Request request, final SuggestOracle.Callback callback) {
        String query = request.getQuery();
        int lastSeparator = -1;
        for (int i = 0; i < this.separators.length(); ++i) {
            int currentSeparator = query.lastIndexOf(this.separators.charAt(i));
            if (currentSeparator <= lastSeparator) continue;
            lastSeparator = currentSeparator;
        }
        String oneWordQuery = query.substring(lastSeparator + 1);
        final String prefix = query.substring(0, lastSeparator + 1);
        final HashSet existingWords = this.suggestUnique ? this.parseQueryString(prefix) : new HashSet();
        request.setQuery(oneWordQuery);
        SuggestOracle.Callback innerCallback = new SuggestOracle.Callback(){

            public void onSuggestionsReady(SuggestOracle.Request defaultRequest, SuggestOracle.Response defaultResponse) {
                SuggestOracle.Response wordListResponse = new SuggestOracle.Response();
                ArrayList<MultiWordSuggestOracle.MultiWordSuggestion> suggestions = new ArrayList<MultiWordSuggestOracle.MultiWordSuggestion>();
                for (SuggestOracle.Suggestion oldSuggestion : defaultResponse.getSuggestions()) {
                    String oneWordSuggestion = oldSuggestion.getReplacementString();
                    if (WordListSuggestOracle.this.suggestUnique && existingWords.contains(oneWordSuggestion)) continue;
                    MultiWordSuggestOracle.MultiWordSuggestion newSuggestion = new MultiWordSuggestOracle.MultiWordSuggestion(prefix + oneWordSuggestion, oldSuggestion.getDisplayString());
                    suggestions.add(newSuggestion);
                }
                wordListResponse.setSuggestions(suggestions);
                callback.onSuggestionsReady(defaultRequest, wordListResponse);
            }
        };
        this.wordOracle.requestSuggestions(request, innerCallback);
    }

    protected Set parseQueryString(String queryString) {
        HashSet<String> existingWords = new HashSet<String>();
        int lastSeparator = queryString.length();
        if (this.suggestUnique) {
            while (lastSeparator > 0) {
                int currentLastSeparator = -1;
                for (int i = 0; i < this.separators.length(); ++i) {
                    int currentSeparator = queryString.substring(0, lastSeparator).lastIndexOf(this.separators.charAt(i));
                    if (currentSeparator <= currentLastSeparator) continue;
                    currentLastSeparator = currentSeparator;
                }
                String currentWord = queryString.substring(currentLastSeparator + 1, lastSeparator);
                if (currentWord.length() > 0) {
                    existingWords.add(currentWord);
                }
                lastSeparator = currentLastSeparator;
            }
        }
        return existingWords;
    }

    public String getSeparators() {
        return this.separators;
    }

    public void setSeparators(String separators) {
        this.separators = separators;
    }

    public boolean isDisplayStringHTML() {
        return this.wordOracle.isDisplayStringHTML();
    }

    public SuggestOracle getWordOracle() {
        return this.wordOracle;
    }

    public void setWordOracle(SuggestOracle wordOracle) {
        this.wordOracle = wordOracle;
    }

    public boolean getSuggestUnique() {
        return this.suggestUnique;
    }

    public void setSuggestUnique(boolean suggestUnique) {
        this.suggestUnique = suggestUnique;
    }
}

