/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.plugin.font;

/**
 * Interface to test if two objects match.
 * 
 * @param <T> the type of the matched objects
 * @version $Id: Matcher.java 18958 2009-04-22 21:16:29Z mflorea $
 */
public interface Matcher<T>
{
    /**
     * @param leftValue the left value
     * @param rightValue the right value
     * @return {@code true} if the left and right values match, {@code false} otherwise
     */
    boolean match(T leftValue, T rightValue);
}
