/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.plugin.line;

import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.dom.client.Range;

import com.google.gwt.dom.client.Node;
import com.xpn.xwiki.wysiwyg.client.Wysiwyg;
import com.xpn.xwiki.wysiwyg.client.util.Config;
import com.xpn.xwiki.wysiwyg.client.widget.rta.RichTextArea;

/**
 * Internet Explorer specific implementation of the {@link LinePlugin}.
 * 
 * @version $Id: IELinePlugin.java 21743 2009-07-01 08:53:31Z mflorea $
 */
public class IELinePlugin extends LinePlugin implements InnerHTMLListener
{
    /**
     * {@inheritDoc}
     * 
     * @see LinePlugin#init(Wysiwyg, RichTextArea, Config)
     */
    public void init(Wysiwyg wysiwyg, RichTextArea textArea, Config config)
    {
        super.init(wysiwyg, textArea, config);
        getTextArea().getDocument().addInnerHTMLListener(this);
    }

    /**
     * {@inheritDoc}
     * 
     * @see LinePlugin#destroy()
     */
    public void destroy()
    {
        getTextArea().getDocument().removeInnerHTMLListener(this);
        super.destroy();
    }

    /**
     * {@inheritDoc}<br/>
     * If the caret is inside an empty block level container and we insert an empty line before then the caret doesn't
     * remain in its place. We have to reset the caret.
     * 
     * @see LinePlugin#insertEmptyLine(Node, Range)
     */
    protected void insertEmptyLine(Node container, Range caret)
    {
        super.insertEmptyLine(container, caret);

        if (!container.hasChildNodes()) {
            container.appendChild(container.getOwnerDocument().createTextNode(""));
            caret.selectNodeContents(container.getFirstChild());
        }
    }

    /**
     * {@inheritDoc}
     * 
     * @see InnerHTMLListener#onInnerHTMLChange(Element)
     */
    public void onInnerHTMLChange(Element element)
    {
        element.ensureEditable();
    }
}
