/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavResourceFactory;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavSessionProvider;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavRequestImpl;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.WebdavResponseImpl;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.apache.jackrabbit.webdav.simple.LocatorFactoryImplEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;

public class DavServlet
extends AbstractWebdavServlet {
    private static final long serialVersionUID = 7255582612577585483L;
    private static final Logger LOG = LoggerFactory.getLogger(DavServlet.class);
    private static final String AUTHENTICATE_HEADER_VALUE = "Basic realm=\"XWiki Webdav Server\"";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private DavLocatorFactory locatorFactory;
    private DavResourceFactory resourceFactory;
    private DavSessionProvider davSessionProvider;
    private LockManager lockManager;

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        return !resource.exists() || request.matchesIfHeader(resource);
    }

    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            this.locatorFactory = new LocatorFactoryImplEx("");
        }
        return this.locatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public DavResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new XWikiDavResourceFactory(this.getLockManager());
            ((XWikiDavResourceFactory)this.resourceFactory).setServletContext(this.getServletContext());
        }
        return this.resourceFactory;
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public synchronized DavSessionProvider getDavSessionProvider() {
        if (this.davSessionProvider == null) {
            this.davSessionProvider = new XWikiDavSessionProvider();
        }
        return this.davSessionProvider;
    }

    public synchronized void setDavSessionProvider(DavSessionProvider sessionProvider) {
        this.davSessionProvider = sessionProvider;
    }

    public String getAuthenticateHeaderValue() {
        return AUTHENTICATE_HEADER_VALUE;
    }

    public LockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = new SimpleLockManager();
        }
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    protected void initializeContainerComponent(XWikiContext context) throws ServletException {
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent((String)ServletContainerInitializer.ROLE);
        try {
            containerInitializer.initializeRequest(context.getRequest().getHttpServletRequest(), (Object)context);
            containerInitializer.initializeResponse(context.getResponse().getHttpServletResponse());
            containerInitializer.initializeSession(context.getRequest().getHttpServletRequest());
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize Request/Response or Session", (Throwable)e);
        }
    }

    protected void cleanupComponents() {
        Container container = (Container)Utils.getComponent((String)Container.ROLE);
        Execution execution = (Execution)Utils.getComponent((String)Execution.ROLE);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        execution.removeContext();
    }

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XWikiContext context = null;
        WebdavRequestImpl webdavRequest = new WebdavRequestImpl(request, this.getLocatorFactory());
        int methodCode = DavMethods.getMethodCode((String)request.getMethod());
        boolean noCache = DavMethods.isDeltaVMethod((DavServletRequest)webdavRequest) && 20 != methodCode && 19 != methodCode;
        WebdavResponseImpl webdavResponse = new WebdavResponseImpl(response, noCache);
        try {
            if (!this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) {
                return;
            }
            XWikiDavResource resource = (XWikiDavResource)this.getResourceFactory().createResource(webdavRequest.getRequestLocator(), (DavServletRequest)webdavRequest, (DavServletResponse)webdavResponse);
            context = resource.getXwikiContext();
            this.initializeContainerComponent(resource.getXwikiContext());
            if ("XWiki.XWikiGuest".equals(context.getUser())) {
                webdavResponse.setStatus(401);
                webdavResponse.setHeader(WWW_AUTHENTICATE_HEADER, this.getAuthenticateHeaderValue());
                return;
            }
            if (!this.isPreconditionValid((WebdavRequest)webdavRequest, resource)) {
                webdavResponse.sendError(412);
                return;
            }
            if (!this.execute((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, methodCode, resource)) {
                super.service(request, response);
            }
        }
        catch (DavException e) {
            if (e.getErrorCode() == 401) {
                webdavResponse.setHeader(WWW_AUTHENTICATE_HEADER, this.getAuthenticateHeaderValue());
                webdavResponse.sendError(e.getErrorCode(), e.getStatusPhrase());
            } else {
                LOG.error("WebDAV Exception Occurred : ", (Throwable)e);
                webdavResponse.sendError(e);
            }
        }
        finally {
            try {
                this.cleanupComponents();
                this.getDavSessionProvider().releaseSession((WebdavRequest)webdavRequest);
            }
            catch (Throwable e) {
                LOG.error("Exception Ocurred while cleaning up : ", e);
            }
            if (context != null && context.getWiki() != null) {
                context.getWiki().getStore().cleanUp(context);
            }
        }
    }

    protected boolean execute(WebdavRequest request, WebdavResponse response, int method, DavResource resource) throws ServletException, IOException, DavException {
        XWikiDavResource res = (XWikiDavResource)resource;
        LOG.warn("Resource : [" + res.getDisplayName() + "] Method : [" + request.getMethod() + "]");
        return super.execute(request, response, method, resource);
    }
}

